/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.sqlcs.ddl;

import java.math.BigDecimal;
import java.sql.SQLException;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.misc.Rational;
import net.morilib.db.sqlcs.ddl.SqlColumnType;

public final class SqlTypeNumeric
extends SqlColumnType {
    public static final int UNLIMITED = 0;
    private int length;
    private int scale;

    public SqlTypeNumeric(int j, int k) {
        this.length = j;
        this.scale = k;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public Object cast(String s) throws SQLException {
        try {
            return s.equals("") ? "" : Rational.valueOf(new BigDecimal(s));
        }
        catch (NumberFormatException e) {
            throw ErrorBundle.getDefault(10035, s);
        }
    }

    @Override
    public String string(Object o) throws SQLException {
        if (o.equals("")) {
            return "";
        }
        if (o instanceof Rational) {
            BigDecimal d = ((Rational)o).toBigDecimal(this.scale);
            if (this.length > 0 && d.scale() > this.length) {
                throw ErrorBundle.getDefault(10044, new Object[0]);
            }
            return d.toString();
        }
        throw ErrorBundle.getDefault(10043, new Object[0]);
    }

    @Override
    public int getSqlType() {
        return 2;
    }

    @Override
    public Class<?> getTypeClass() {
        return Rational.class;
    }

    public int hashCode() {
        return this.length * this.scale;
    }

    public boolean equals(Object o) {
        return o instanceof SqlTypeNumeric && ((SqlTypeNumeric)o).length == this.length && ((SqlTypeNumeric)o).scale == this.scale;
    }

    public String toString() {
        if (this.scale > 0) {
            return "NUMERIC(" + this.length + "," + this.scale + ")";
        }
        return "NUMERIC(" + this.length + ")";
    }
}

