/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.schema;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.morilib.db.fichier.FabriqueDeFichier;
import net.morilib.db.misc.NullBoolean;
import net.morilib.db.relations.NamedRelation;
import net.morilib.db.relations.Relation;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.relations.TableRenameRelation;
import net.morilib.db.schema.SqlSchema;
import net.morilib.db.sqlcs.ddl.SqlCreateTable;

public class WithSqlSchema
implements SqlSchema {
    private SqlSchema wrap;
    private Map<String, Relation> rels;

    public WithSqlSchema(SqlSchema w, Map<String, Relation> r) {
        this.wrap = w;
        this.rels = new HashMap<String, Relation>(r);
    }

    public WithSqlSchema(SqlSchema w) {
        this.wrap = w;
        this.rels = new HashMap<String, Relation>();
    }

    @Override
    public NamedRelation readRelation(String name, String as) throws IOException, SQLException {
        return this.rels.containsKey(name) ? new TableRenameRelation(this.rels.get(name), as) : this.wrap.readRelation(name, as);
    }

    @Override
    public void writeRelation(String name, Collection<RelationTuple> z) throws IOException, SQLException {
        this.wrap.writeRelation(name, z);
    }

    @Override
    public SqlCreateTable getCreateTable(String name) throws IOException, SQLException {
        return this.wrap.getCreateTable(name);
    }

    @Override
    public boolean isTable(String name) throws IOException, SQLException {
        return this.wrap.isTable(name);
    }

    @Override
    public void putCreateTable(String name, SqlCreateTable table) throws IOException, SQLException {
        this.wrap.putCreateTable(name, table);
    }

    @Override
    public Collection<String> getTableNames() throws IOException, SQLException {
        return this.wrap.getTableNames();
    }

    @Override
    public void truncateTable(String name) throws IOException, SQLException {
        this.wrap.truncateTable(name);
    }

    @Override
    public void removeCreateTable(String name) throws IOException, SQLException {
        this.wrap.removeCreateTable(name);
    }

    @Override
    public void alterCreateTable(String name, SqlCreateTable table) throws IOException, SQLException {
        this.wrap.alterCreateTable(name, table);
    }

    @Override
    public SqlSchema fork() {
        return new WithSqlSchema(this.wrap, this.rels);
    }

    @Override
    public NullBoolean isReadonly() {
        return this.wrap.isReadonly();
    }

    @Override
    public NullBoolean usesLocalFiles() {
        return this.wrap.usesLocalFiles();
    }

    @Override
    public NullBoolean usesLocalFilePerTable() {
        return this.wrap.usesLocalFilePerTable();
    }

    @Override
    public FabriqueDeFichier fabrique() {
        return this.wrap.fabrique();
    }

    @Override
    public void bindSchema(String name, Relation r) {
        this.rels.put(name, r);
    }

    @Override
    public boolean isAutoCommit() {
        return this.wrap.isAutoCommit();
    }

    @Override
    public boolean isLocked(String name) {
        return this.wrap.isLocked(name);
    }

    @Override
    public boolean isUsed(String name) {
        return this.wrap.isUsed(name);
    }

    @Override
    public void lock(String name) throws IOException {
        this.wrap.lock(name);
    }

    @Override
    public void unlock(String name) throws IOException {
        this.wrap.unlock(name);
    }
}

