/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.misc;

import java.io.PrintWriter;
import net.morilib.parser.html.HTMLHandler;
import net.morilib.parser.html.HTMLParseException;
import net.morilib.parser.html.HTMLParser;

public abstract class XmlReplaceTag
implements HTMLHandler {
    String tag;
    private PrintWriter wr;
    private boolean tagw;
    private boolean tagp;
    private int nest = 0;

    public XmlReplaceTag(String tag, PrintWriter w) {
        this.tag = tag;
        this.wr = w;
    }

    public abstract void insertFragment(PrintWriter var1);

    private void puttagw() {
        if (this.tagw) {
            this.wr.print('>');
            this.tagw = false;
        }
    }

    @Override
    public void string(String s) throws HTMLParseException {
        this.puttagw();
        if (this.nest == 0) {
            this.wr.print(HTMLParser.escape(s));
        }
    }

    @Override
    public void startTag(String s) throws HTMLParseException {
        this.puttagw();
        if (this.nest == 0) {
            this.wr.format("<%s", HTMLParser.escape(s));
            this.tagw = true;
        }
        this.tagp = s.equals(this.tag) && this.nest++ == 0;
    }

    @Override
    public void endTag(String s) throws HTMLParseException {
        this.puttagw();
        if (s.equals(this.tag) && --this.nest == 0) {
            this.insertFragment(this.wr);
        }
        if (this.nest == 0) {
            this.wr.format("</%s>", HTMLParser.escape(s));
        }
    }

    @Override
    public void tagAttribute(String k, String v) throws HTMLParseException {
        if (this.nest == 0 || this.tagp) {
            this.wr.format(" %s=\"%s\"", HTMLParser.escape(k), HTMLParser.escape(v));
        }
    }

    @Override
    public void meta(String s) throws HTMLParseException {
        this.wr.println(s);
    }

    @Override
    public void comment(String s) throws HTMLParseException {
        this.wr.format("<!--%s-->", s);
    }
}

