/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.functions;

import java.sql.SQLException;
import java.util.List;
import net.morilib.db.delay.Delay;
import net.morilib.db.expr.RelationFunction;
import net.morilib.db.functions.FunctionType;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.misc.Rational;
import net.morilib.db.relations.RelationAggregate;

public class FnRound
extends RelationFunction {
    private static Rational rnd(Object o, Object p) throws SQLException {
        if (!(o instanceof Rational) || !(p instanceof Rational)) {
            throw ErrorBundle.getDefault(10008, "ROUND");
        }
        if (!((Rational)p).isInteger()) {
            throw ErrorBundle.getDefault(10008, "ROUND");
        }
        int x = ((Rational)p).intCeil();
        return Rational.valueOf(((Rational)o).toBigDecimal(x));
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    @Override
    public Object operate(RelationAggregate m, List<Object> group, final Object ... args) throws SQLException {
        if (args.length == 1) {
            if (args[0] instanceof Delay) {
                Delay d = new Delay(){

                    @Override
                    public Object force() throws SQLException {
                        Object o = ((Delay)args[0]).force();
                        return FnRound.rnd(o, Rational.ZERO);
                    }

                    @Override
                    public void add(Object ... o) throws SQLException {
                        ((Delay)args[0]).add(o);
                    }
                };
                m.put(group, d);
                return d;
            }
            return FnRound.rnd(args[0], Rational.ZERO);
        }
        if (args.length == 2) {
            if (args[0] instanceof Delay) {
                Delay d = new Delay(){

                    @Override
                    public Object force() throws SQLException {
                        Object o = ((Delay)args[0]).force();
                        Object p = args[1] instanceof Delay ? ((Delay)args[1]).force() : args[1];
                        return FnRound.rnd(o, p);
                    }

                    @Override
                    public void add(Object ... o) throws SQLException {
                        ((Delay)args[0]).add(o);
                    }
                };
                m.put(group, d);
                return d;
            }
            return FnRound.rnd(args[0], args[1]);
        }
        throw ErrorBundle.getDefault(10007, "ROUND");
    }

    @Override
    public Object init() throws SQLException {
        return Rational.ZERO;
    }

    @Override
    public FunctionType getType() {
        return FunctionType.NUMERIC;
    }
}

