/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.expr;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import net.morilib.db.functions.FunctionLoader;
import net.morilib.db.functions.FunctionType;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.relations.RelationAggregate;

public abstract class RelationFunction {
    private static Map<String, RelationFunction> map = FunctionLoader.load();

    public static RelationFunction get(String s) throws SQLException {
        RelationFunction f = map.get(s.toUpperCase());
        if (f != null) {
            return f;
        }
        throw ErrorBundle.getDefault(10011, s.toUpperCase());
    }

    public static String getListString(FunctionType t) {
        StringBuffer b = new StringBuffer();
        String d = "";
        for (Map.Entry<String, RelationFunction> s : map.entrySet()) {
            if (s.getValue().getType() != t) continue;
            b.append(d).append(s.getKey());
            d = ",";
        }
        return b.toString();
    }

    public abstract boolean isAggregate();

    public abstract Object operate(RelationAggregate var1, List<Object> var2, Object ... var3) throws SQLException;

    public abstract Object init() throws SQLException;

    public abstract FunctionType getType();
}

