/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.schema;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.morilib.db.fichier.FabriqueDeFichier;
import net.morilib.db.fichier.Fichier;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.misc.NullBoolean;
import net.morilib.db.misc.XlsxSharedString;
import net.morilib.db.misc.XmlTags;
import net.morilib.db.relations.NamedRelation;
import net.morilib.db.relations.Relation;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.relations.TableRenameRelation;
import net.morilib.db.schema.SqlSchema;
import net.morilib.db.schema.SqlSchemata;
import net.morilib.db.schema.XlsxReadTable;
import net.morilib.db.schema.XlsxRelsAdd;
import net.morilib.db.schema.XlsxRelsMax;
import net.morilib.db.schema.XlsxRelsSearch;
import net.morilib.db.schema.XlsxTables;
import net.morilib.db.schema.XlsxWriteTable;
import net.morilib.db.schema.XlsxWriteTables;
import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;
import net.morilib.db.sqlcs.ddl.SqlCreateTable;
import net.morilib.parser.html.HTMLHandler;
import net.morilib.parser.html.HTMLParser;

public class XlsxSqlSchema
implements SqlSchema {
    private String xlsx;
    private Map<String, Relation> rels;

    public XlsxSqlSchema(String xlsxfile) {
        this.xlsx = xlsxfile;
    }

    private List<List<String>> gettbl(String name) throws SQLException, IOException {
        BufferedReader b = null;
        ZipInputStream z = null;
        XlsxTables y = this._getTableNames();
        String n = y.getSheet(name.toUpperCase());
        if (n == null) {
            throw ErrorBundle.getDefault(10015, name);
        }
        XlsxSharedString s = XlsxSharedString.fromXlsx(this.fabrique().newInstance(this.xlsx));
        try {
            ZipEntry t;
            z = new ZipInputStream(this.fabrique().newInstance(this.xlsx).openInputStream());
            while ((t = z.getNextEntry()) != null) {
                if (!t.getName().equalsIgnoreCase("xl/worksheets/" + n)) continue;
                b = new BufferedReader(new InputStreamReader((InputStream)z, "UTF-8"));
                XlsxReadTable h = new XlsxReadTable(s);
                HTMLParser.parse((HTMLHandler)h, b);
                List<List<String>> list = h.values;
                return list;
            }
            return null;
        }
        finally {
            if (z != null) {
                z.close();
            }
        }
    }

    @Override
    public NamedRelation readRelation(String name, String as) throws IOException, SQLException {
        if (this.rels != null && this.rels.containsKey(name.toUpperCase())) {
            return new TableRenameRelation(this.rels.get(name.toUpperCase()), (as != null ? as : name).toUpperCase());
        }
        List<List<String>> l = this.gettbl(name);
        if (l == null) {
            throw ErrorBundle.getDefault(10015, name);
        }
        return SqlSchemata.readRelation(name, as, l);
    }

    private static void _copy(InputStream in, OutputStream os) throws IOException {
        int l;
        byte[] b = new byte[4096];
        while ((l = in.read(b)) >= 0) {
            os.write(b, 0, l);
        }
    }

    void _writeRelation(SqlCreateTable c, Collection<RelationTuple> l) throws IOException, SQLException {
        ZipOutputStream o = null;
        BufferedReader b = null;
        ZipInputStream z = null;
        OutputStream os = null;
        BufferedInputStream is = null;
        XlsxTables y = this._getTableNames();
        String n = y.getSheet(c.getName());
        if (n == null) {
            throw ErrorBundle.getDefault(10015, c.getName());
        }
        XlsxSharedString s = XlsxSharedString.fromListOfTuple(this.fabrique().newInstance(this.xlsx), l);
        List<SqlColumnDefinition> q = c.getColumnDefinitions();
        int i = 0;
        while (i < q.size()) {
            s.addString(q.get(i).getName());
            ++i;
        }
        Fichier f = this.fabrique().createTempFile("table", ".xlsx");
        try {
            ZipEntry t;
            z = new ZipInputStream(this.fabrique().newInstance(this.xlsx).openInputStream());
            o = new ZipOutputStream(f.openOutputStream());
            while ((t = z.getNextEntry()) != null) {
                o.putNextEntry(new ZipEntry(t.getName()));
                if (t.getName().equalsIgnoreCase("xl/worksheets/" + n)) {
                    b = new BufferedReader(new InputStreamReader((InputStream)z, "UTF-8"));
                    PrintWriter w = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)o, "UTF-8")), true);
                    XlsxWriteTable h = new XlsxWriteTable(w, s, c, l, null);
                    HTMLParser.parse((HTMLHandler)h, b);
                    w.flush();
                } else if (t.getName().equalsIgnoreCase("xl/sharedStrings.xml")) {
                    s.write(o);
                } else {
                    XlsxSqlSchema._copy(z, o);
                }
                z.closeEntry();
                o.closeEntry();
            }
        }
        finally {
            if (z != null) {
                z.close();
            }
            if (o != null) {
                o.close();
            }
        }
        try {
            is = new BufferedInputStream(f.openInputStream());
            os = new BufferedOutputStream(this.fabrique().newInstance(this.xlsx).openOutputStream());
            XlsxSqlSchema._copy(is, os);
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    @Override
    public void writeRelation(String name, Collection<RelationTuple> l) throws IOException, SQLException {
        this._writeRelation(this.getCreateTable(name), l);
    }

    @Override
    public SqlCreateTable getCreateTable(String name) throws IOException, SQLException {
        List<List<String>> l = this.gettbl(name);
        if (l == null) {
            throw ErrorBundle.getDefault(10015, name);
        }
        return SqlSchemata.guessTable(name, l);
    }

    @Override
    public boolean isTable(String name) throws IOException, SQLException {
        return this.getTableNames().contains(name);
    }

    @Override
    public void putCreateTable(String name, SqlCreateTable table) throws IOException, SQLException {
        Map<String, String> m;
        String d;
        ZipOutputStream o = null;
        BufferedReader b = null;
        ZipInputStream z = null;
        OutputStream os = null;
        InputStream is = null;
        ArrayList<String> y = new ArrayList<String>(this.getTableNames());
        y.add(name);
        XlsxSharedString s = XlsxSharedString.fromXlsx(this.fabrique().newInstance(this.xlsx));
        List<SqlColumnDefinition> q = table.getColumnDefinitions();
        int i = 0;
        while (i < q.size()) {
            s.addString(q.get(i).getName());
            ++i;
        }
        try {
            d = XlsxRelsMax.fromXlsx(this.fabrique().newInstance(this.xlsx));
            d = d.replaceFirst("^rId", "");
            d = "rId" + (Integer.parseInt(d) + 1);
            m = XlsxRelsSearch.fromXlsx(this.fabrique().newInstance(this.xlsx));
            m.put(String.valueOf(y.size()), d);
        }
        catch (NumberFormatException e) {
            throw ErrorBundle.getDefault(10046, new Object[0]);
        }
        Fichier f = this.fabrique().createTempFile("table", ".xlsx");
        try {
            PrintWriter w;
            ZipEntry t;
            z = new ZipInputStream(this.fabrique().newInstance(this.xlsx).openInputStream());
            o = new ZipOutputStream(f.openOutputStream());
            while ((t = z.getNextEntry()) != null) {
                o.putNextEntry(new ZipEntry(t.getName()));
                if (t.getName().equalsIgnoreCase("xl/workbook.xml")) {
                    b = new BufferedReader(new InputStreamReader((InputStream)z, "UTF-8"));
                    w = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)o, "UTF-8")));
                    XlsxWriteTables g = new XlsxWriteTables(w, m, y);
                    HTMLParser.parse((HTMLHandler)g, b);
                    w.flush();
                } else if (t.getName().equalsIgnoreCase("xl/sharedStrings.xml")) {
                    s.write(o);
                } else if (t.getName().equalsIgnoreCase("xl/_rels/workbook.xml.rels")) {
                    b = new BufferedReader(new InputStreamReader((InputStream)z, "UTF-8"));
                    w = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)o, "UTF-8")));
                    XlsxRelsAdd a = new XlsxRelsAdd(w, y.size(), d);
                    HTMLParser.parse((HTMLHandler)a, b);
                    w.flush();
                } else {
                    XlsxSqlSchema._copy(z, o);
                }
                z.closeEntry();
                o.closeEntry();
            }
            o.putNextEntry(new ZipEntry("xl/worksheets/sheet" + y.size() + ".xml"));
            is = XlsxSqlSchema.class.getResourceAsStream("/net/morilib/db/schema/sheettemplate.xml");
            b = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            w = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)o, "UTF-8")), true);
            XlsxWriteTable h = new XlsxWriteTable(w, s, table, Collections.<RelationTuple>emptyList(), d);
            HTMLParser.parse((HTMLHandler)h, b);
            w.flush();
            o.closeEntry();
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (z != null) {
                z.close();
            }
            if (o != null) {
                o.close();
            }
            is = null;
        }
        try {
            is = new BufferedInputStream(f.openInputStream());
            os = new BufferedOutputStream(this.fabrique().newInstance(this.xlsx).openOutputStream());
            XlsxSqlSchema._copy(is, os);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    XlsxTables _getTableNames() throws IOException, SQLException {
        BufferedReader b = null;
        ZipInputStream z = null;
        try {
            ZipEntry t;
            z = new ZipInputStream(this.fabrique().newInstance(this.xlsx).openInputStream());
            while ((t = z.getNextEntry()) != null) {
                if (!t.getName().equalsIgnoreCase("xl/workbook.xml")) continue;
                b = new BufferedReader(new InputStreamReader((InputStream)z, "UTF-8"));
                XlsxTables h = new XlsxTables();
                HTMLParser.parse((HTMLHandler)h, b);
                XlsxTables xlsxTables = h;
                return xlsxTables;
            }
            return null;
        }
        finally {
            if (z != null) {
                z.close();
            }
        }
    }

    @Override
    public Collection<String> getTableNames() throws IOException, SQLException {
        return Collections.unmodifiableSet(this._getTableNames().map.keySet());
    }

    @Override
    public void truncateTable(String name) throws IOException, SQLException {
        this.writeRelation(name, Collections.<RelationTuple>emptyList());
    }

    @Override
    public void removeCreateTable(String name) throws IOException, SQLException {
        ZipOutputStream o = null;
        ZipInputStream z = null;
        OutputStream os = null;
        BufferedInputStream is = null;
        SqlCreateTable c = this.getCreateTable(name);
        XlsxTables y = this._getTableNames();
        String n = y.getSheet(c.getName());
        if (n == null) {
            throw ErrorBundle.getDefault(10015, c.getName());
        }
        Map<String, String> m = XlsxRelsSearch.fromXlsx(this.fabrique().newInstance(this.xlsx));
        String d = n.replaceFirst("^sheet", "");
        d = d.replaceFirst("\\.xml$", "");
        d = m.get(d);
        Fichier f = this.fabrique().createTempFile("table", ".xlsx");
        try {
            ZipEntry t;
            z = new ZipInputStream(this.fabrique().newInstance(this.xlsx).openInputStream());
            o = new ZipOutputStream(f.openOutputStream());
            while ((t = z.getNextEntry()) != null) {
                if (t.getName().equalsIgnoreCase("xl/workbook.xml")) {
                    o.putNextEntry(new ZipEntry(t.getName()));
                    XmlTags.removeTag(z, o, "sheet", "r:id", d);
                    o.closeEntry();
                } else if (t.getName().equalsIgnoreCase("xl/_rels/workbook.xml.rels")) {
                    o.putNextEntry(new ZipEntry(t.getName()));
                    XmlTags.removeTag(z, o, "Relationship", "Id", d);
                    o.closeEntry();
                } else if (!t.getName().equalsIgnoreCase("xl/worksheets/" + n)) {
                    o.putNextEntry(new ZipEntry(t.getName()));
                    XlsxSqlSchema._copy(z, o);
                    o.closeEntry();
                }
                z.closeEntry();
            }
        }
        finally {
            if (z != null) {
                z.close();
            }
            if (o != null) {
                o.close();
            }
        }
        try {
            is = new BufferedInputStream(f.openInputStream());
            os = new BufferedOutputStream(this.fabrique().newInstance(this.xlsx).openOutputStream());
            XlsxSqlSchema._copy(is, os);
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    @Override
    public void alterCreateTable(String name, SqlCreateTable table) throws IOException, SQLException {
        this._writeRelation(table, Collections.<RelationTuple>emptyList());
    }

    @Override
    public SqlSchema fork() {
        return this;
    }

    @Override
    public NullBoolean isReadonly() {
        return NullBoolean.TRUE;
    }

    @Override
    public NullBoolean usesLocalFiles() {
        return NullBoolean.TRUE;
    }

    @Override
    public NullBoolean usesLocalFilePerTable() {
        return NullBoolean.FALSE;
    }

    @Override
    public FabriqueDeFichier fabrique() {
        return FabriqueDeFichier.getDefault();
    }

    @Override
    public void bindSchema(String name, Relation r) {
        this.rels.put(name, r);
    }
}

