/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.schema;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.morilib.db.fichier.Fichier;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.parser.html.HTMLHandler;
import net.morilib.parser.html.HTMLParser;

class XlsxRelsSearch
implements HTMLHandler {
    Map<String, String> vals = new HashMap<String, String>();
    private boolean tagr = false;
    private String tid;
    private String tval;

    XlsxRelsSearch() {
    }

    static Map<String, String> fromXlsx(Fichier f) throws SQLException, IOException {
        XlsxRelsSearch h = new XlsxRelsSearch();
        ZipInputStream zip = null;
        try {
            ZipEntry ent;
            zip = new ZipInputStream(f.openInputStream());
            while ((ent = zip.getNextEntry()) != null) {
                if (!ent.getName().equals("xl/_rels/workbook.xml.rels")) continue;
                h = new XlsxRelsSearch();
                HTMLParser.parse((HTMLHandler)h, new InputStreamReader((InputStream)zip, "UTF-8"));
                Map<String, String> map = h.vals;
                return map;
            }
            throw ErrorBundle.getDefault(10046, new Object[0]);
        }
        finally {
            if (zip != null) {
                zip.close();
            }
        }
    }

    @Override
    public void string(String s) throws SQLException {
    }

    @Override
    public void startTag(String s) throws SQLException {
        this.tagr = s.equals("Relationship");
    }

    @Override
    public void endTag(String s) throws SQLException {
        if (this.tagr) {
            this.vals.put(this.tval, this.tid);
        }
        this.tagr = false;
    }

    @Override
    public void tagAttribute(String k, String v) throws SQLException {
        if (this.tagr && k.equals("Id")) {
            this.tid = v;
        } else if (this.tagr && k.equals("Target")) {
            this.tval = v.replaceFirst("^worksheets/sheet", "");
            this.tval = this.tval.replaceFirst("\\.xml$", "");
        }
    }

    @Override
    public void meta(String s) throws SQLException {
    }

    @Override
    public void comment(String s) throws SQLException {
    }
}

