/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.schema;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.misc.XlsxSharedString;
import net.morilib.parser.html.HTMLHandler;

class XlsxReadTable
implements HTMLHandler {
    private static final Pattern PT1 = Pattern.compile("[A-Z]+");
    private static final BigDecimal ML1 = BigDecimal.valueOf(86400000L);
    private static final BigDecimal SU1 = BigDecimal.valueOf(25569L);
    private static final SimpleDateFormat FM1 = new SimpleDateFormat("yyyy/MM/dd");
    List<List<String>> values = new ArrayList<List<String>>();
    private XlsxSharedString share;
    private List<String> value;
    private F sflg;
    private int colno;
    private S stat = S.INIT;

    XlsxReadTable(XlsxSharedString s) {
        this.share = s;
    }

    private static int colno(String s) throws SQLException {
        int x = 0;
        Matcher m = PT1.matcher(s.toUpperCase());
        if (m.lookingAt()) {
            String v = m.group();
            int i = v.length() - 1;
            while (i >= 0) {
                x = x * 26 + (v.charAt(i) - 65);
                --i;
            }
            return x;
        }
        throw ErrorBundle.getDefault(10046, new Object[0]);
    }

    private static String serialToYMD(String serial) throws SQLException {
        try {
            BigDecimal b = new BigDecimal(serial);
            b = b.subtract(SU1).multiply(ML1);
            Date d = new Date(b.longValue());
            return FM1.format(d);
        }
        catch (NumberFormatException e) {
            throw ErrorBundle.getDefault(10046, new Object[0]);
        }
    }

    private void _put(int x, String s) {
        if (x < this.value.size()) {
            this.value.set(x, s);
        } else {
            int i = this.value.size();
            while (i < x) {
                this.value.set(i, "");
                ++i;
            }
            this.value.add(s);
        }
    }

    @Override
    public void string(String s) throws SQLException {
        switch (this.stat) {
            case INIT: 
            case WORKSHEET: 
            case SHEET_DATA: 
            case ROW: 
            case C: {
                break;
            }
            case V: {
                if (this.colno < 0) {
                    throw ErrorBundle.getDefault(10046, new Object[0]);
                }
                if (this.sflg == F.SHARED) {
                    try {
                        this._put(this.colno, this.share.getString(Integer.parseInt(s)));
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw ErrorBundle.getDefault(10046, new Object[0]);
                    }
                }
                if (this.sflg == F.DATE) {
                    this._put(this.colno, XlsxReadTable.serialToYMD(s));
                    break;
                }
                this._put(this.colno, s);
            }
        }
    }

    @Override
    public void startTag(String s) throws SQLException {
        switch (this.stat) {
            case INIT: {
                if (!s.equals("worksheet")) break;
                this.stat = S.WORKSHEET;
                break;
            }
            case WORKSHEET: {
                if (!s.equals("sheetData")) break;
                this.stat = S.SHEET_DATA;
                break;
            }
            case SHEET_DATA: {
                if (!s.equals("row")) break;
                this.stat = S.ROW;
                this.value = new ArrayList<String>();
                break;
            }
            case ROW: {
                if (!s.equals("c")) break;
                this.stat = S.C;
                this.sflg = F.NONE;
                this.colno = -1;
                break;
            }
            case C: {
                if (!s.equals("v")) break;
                this.stat = S.V;
                break;
            }
        }
    }

    @Override
    public void endTag(String s) throws SQLException {
        switch (this.stat) {
            case INIT: {
                break;
            }
            case WORKSHEET: {
                if (!s.equals("worksheet")) break;
                this.stat = S.INIT;
                break;
            }
            case SHEET_DATA: {
                if (!s.equals("sheetData")) break;
                this.stat = S.WORKSHEET;
                break;
            }
            case ROW: {
                if (!s.equals("row")) break;
                this.values.add(this.value);
                this.stat = S.SHEET_DATA;
                break;
            }
            case C: {
                if (!s.equals("c")) break;
                this.stat = S.ROW;
                break;
            }
            case V: {
                if (!s.equals("v")) break;
                this.stat = S.C;
            }
        }
    }

    @Override
    public void tagAttribute(String k, String v) throws SQLException {
        switch (this.stat) {
            case INIT: 
            case WORKSHEET: 
            case SHEET_DATA: 
            case ROW: 
            case V: {
                break;
            }
            case C: {
                if (k.equals("r")) {
                    this.colno = XlsxReadTable.colno(v);
                    break;
                }
                if (k.equals("t")) {
                    if (!v.equals("s")) break;
                    this.sflg = F.SHARED;
                    break;
                }
                if (!k.equals("s") || !v.equals("1")) break;
                this.sflg = F.DATE;
            }
        }
    }

    @Override
    public void meta(String s) throws SQLException {
    }

    @Override
    public void comment(String s) throws SQLException {
    }

    private static enum F {
        NONE,
        SHARED,
        DATE;

    }

    private static enum S {
        INIT,
        WORKSHEET,
        SHEET_DATA,
        ROW,
        C,
        V;

    }
}

