/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.relations;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.morilib.db.engine.SqlEngine;
import net.morilib.db.expr.RelationExpression;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.relations.CorrelatedRelationTuple;
import net.morilib.db.relations.DefaultRelationTuple;
import net.morilib.db.relations.Relation;
import net.morilib.db.relations.RelationAggregate;
import net.morilib.db.relations.RelationCursor;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.relations.TableRelation;
import net.morilib.db.schema.SqlSchema;
import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;
import net.morilib.db.sqlcs.dml.SqlSelectDistinct;

public abstract class AbstractRelation
implements Relation {
    @Override
    public Relation project(final List<String> names) throws SQLException {
        final RelationCursor t = this.iterator();
        if (!this.getColumnNames().containsAll(names)) {
            throw ErrorBundle.getDefault(10004, new Object[0]);
        }
        return new AbstractRelation(){

            @Override
            public RelationCursor iterator() {
                return new RelationCursor(){

                    @Override
                    public boolean hasNext() {
                        return t.hasNext();
                    }

                    @Override
                    public RelationTuple next() throws IOException, SQLException {
                        final RelationTuple x = t.next();
                        return new RelationTuple(){

                            @Override
                            public Object get(String name) throws SQLException {
                                if (!names.contains(name)) {
                                    throw ErrorBundle.getDefault(10009, name);
                                }
                                return x.get(name);
                            }

                            @Override
                            public RelationTuple copy() throws SQLException {
                                return new DefaultRelationTuple(this.toMap());
                            }

                            @Override
                            public Map<String, Object> toMap() throws SQLException {
                                List<SqlColumnDefinition> ases = this.getColumnNames();
                                LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
                                int i = 0;
                                while (i < ases.size()) {
                                    m.put(ases.get(i).getName(), this.get(ases.get(i).getName()));
                                    ++i;
                                }
                                return m;
                            }
                        };
                    }
                };
            }

            @Override
            public List<SqlColumnDefinition> getColumnNames() {
                ArrayList<SqlColumnDefinition> l = new ArrayList<SqlColumnDefinition>();
                for (String s : names) {
                    l.add(this.getDefinition(s));
                }
                return l;
            }

            @Override
            public SqlColumnDefinition getDefinition(String name) {
                return AbstractRelation.this.getDefinition(name);
            }
        };
    }

    @Override
    public Relation select(SqlEngine v, SqlSchema f, RelationExpression pred, RelationAggregate m, SqlSelectDistinct d, RelationTuple c, List<String> group, List<Object> h) throws IOException, SQLException {
        Collection<RelationTuple> r = d.create();
        RelationCursor i = this.iterator();
        while (i.hasNext()) {
            RelationTuple x = i.next().copy();
            CorrelatedRelationTuple t = new CorrelatedRelationTuple(x, c);
            if (!pred.test(v, f, t, m, group, h).isTrue()) continue;
            r.add(x);
        }
        return new TableRelation(this.getColumnNames(), r);
    }
}

