/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.misc;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import net.morilib.db.jdbc.RelationsJDBCUtils;

public final class ErrorBundle {
    private static Logger logger = RelationsJDBCUtils.logger;
    private static final ErrorBundle _DEF = ErrorBundle.getInstance(Locale.getDefault());
    private ResourceBundle bundle;

    private ErrorBundle(ResourceBundle b) {
        this.bundle = b;
    }

    public static synchronized ErrorBundle getInstance(Locale locale) {
        ResourceBundle b = ResourceBundle.getBundle("net/morilib/db/misc/relations_errors", locale);
        return new ErrorBundle(b);
    }

    public SQLException getException(int code, Object ... mesg) {
        SQLException e;
        String s = this.bundle.getString(String.valueOf(code));
        StringWriter t = new StringWriter();
        PrintWriter w = new PrintWriter(t);
        if (s != null) {
            s = String.format(s, mesg);
            e = new SQLException(s, null, code);
        } else {
            e = new SQLException("unknown code: " + code, null, 99999);
        }
        e.printStackTrace(w);
        w.flush();
        logger.finer(w.toString());
        return e;
    }

    public SQLException getIOException(Throwable z, Object ... mesg) {
        String s = this.bundle.getString("10037");
        StringWriter t = new StringWriter();
        PrintWriter w = new PrintWriter(t);
        s = String.format(s, mesg);
        SQLException e = new SQLException(s, null, 10037, z);
        e.printStackTrace(w);
        w.flush();
        logger.finer(t.toString());
        return e;
    }

    public static SQLException getDefault(int code, Object ... mesg) {
        return _DEF.getException(code, mesg);
    }

    public static SQLException getIODefault(Throwable z, Object ... mesg) {
        return _DEF.getIOException(z, mesg);
    }
}

