/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.jdbc;

import java.io.IOException;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import net.morilib.db.jdbc.RelationsConnection;
import net.morilib.db.jdbc.RelationsJDBCUtils;
import net.morilib.db.jdbc.RelationsResultSet;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.relations.Relation;

public class RelationsStatement
implements Statement {
    private static Logger logger = RelationsJDBCUtils.logger;
    RelationsConnection conn;
    int maxFieldSize = 0;
    int maxRows = 0;
    Relation select0 = null;
    int count0 = -1;
    List<String> batch;

    RelationsStatement(RelationsConnection c) {
        this.conn = c;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        logger.finer("unwrap");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        logger.finer("isWrapperFor");
        return false;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        logger.finer("executeQuery");
        try {
            Object o = this.conn.engine.execute(this.conn.schema, sql);
            if (o instanceof Relation) {
                return new RelationsResultSet(this, (Relation)o);
            }
            throw ErrorBundle.getDefault(10038, new Object[0]);
        }
        catch (IOException e) {
            throw ErrorBundle.getIODefault(e, new Object[0]);
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        logger.finer("executeUpdate");
        try {
            Object o = this.conn.engine.execute(this.conn.schema, sql);
            if (o instanceof Number) {
                return ((Number)o).intValue();
            }
            return 0;
        }
        catch (IOException e) {
            throw ErrorBundle.getIODefault(e, new Object[0]);
        }
    }

    void checkclose() throws SQLException {
        logger.finer("checkclose");
        if (this.conn == null) {
            throw ErrorBundle.getDefault(20002, new Object[0]);
        }
    }

    @Override
    public void close() throws SQLException {
        logger.finer("close");
        this.checkclose();
        this.conn = null;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        logger.finer("getMaxFieldSize");
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        logger.finer("setMaxFieldSize");
        this.maxFieldSize = max;
        if (this.maxFieldSize < 0) {
            throw ErrorBundle.getDefault(20001, new Object[0]);
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        logger.finer("getMaxRows");
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        logger.finer("setMaxRows");
        this.maxRows = max;
        if (this.maxRows < 0) {
            throw ErrorBundle.getDefault(20001, new Object[0]);
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        logger.finer("setEscapeProcessing");
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        logger.finer("getQueryTimeout");
        return 0;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        logger.finer("setQueryTimeout");
    }

    @Override
    public void cancel() throws SQLException {
        logger.finer("cancel");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        logger.finer("getWarnings");
        this.checkclose();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        logger.finer("clearWarnings");
        this.checkclose();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        logger.finer("setCursorName");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        block5: {
            Object o;
            block4: {
                logger.finer("execute");
                this.checkclose();
                try {
                    o = this.conn.engine.execute(this.conn.schema, sql);
                    if (!(o instanceof Relation)) break block4;
                    this.select0 = (Relation)o;
                    return true;
                }
                catch (IOException e) {
                    throw ErrorBundle.getIODefault(e, new Object[0]);
                }
            }
            if (!(o instanceof Number)) break block5;
            this.count0 = ((Number)o).intValue();
            return false;
        }
        this.count0 = 0;
        return false;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        logger.finer("getResultSet");
        this.checkclose();
        if (this.select0 != null) {
            Relation s = this.select0;
            this.select0 = null;
            return new RelationsResultSet(this, s);
        }
        return null;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        logger.finer("getUpdateCount");
        this.checkclose();
        if (this.select0 != null) {
            int s = this.count0;
            this.count0 = -1;
            return s;
        }
        return -1;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        logger.finer("getMoreResults");
        this.checkclose();
        return this.select0 != null;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        logger.finer("setFetchDirection");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        logger.finer("getFetchDirection");
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        logger.finer("setFetchSize");
    }

    @Override
    public int getFetchSize() throws SQLException {
        logger.finer("getFetchSize");
        return 0;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        logger.finer("getResultSetConcurrency");
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        logger.finer("getResultSetType");
        return 1003;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch(String sql) throws SQLException {
        logger.finer("addBatch");
        this.checkclose();
        RelationsStatement relationsStatement = this;
        synchronized (relationsStatement) {
            this.batch.add(sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearBatch() throws SQLException {
        logger.finer("clearBatch");
        this.checkclose();
        RelationsStatement relationsStatement = this;
        synchronized (relationsStatement) {
            this.batch.clear();
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int[] r = new int[this.batch.size()];
        logger.finer("executeBatch");
        this.checkclose();
        int i = 0;
        while (i < this.batch.size()) {
            try {
                Object o = this.conn.engine.execute(this.conn.schema, this.batch.get(i));
                if (o instanceof Relation) {
                    throw new BatchUpdateException();
                }
                r[i] = o instanceof Number ? ((Number)o).intValue() : -2;
            }
            catch (SQLException e) {
                throw new BatchUpdateException(e);
            }
            catch (IOException e) {
                throw ErrorBundle.getIODefault(e, new Object[0]);
            }
            ++i;
        }
        return r;
    }

    @Override
    public Connection getConnection() throws SQLException {
        logger.finer("getConnection");
        this.checkclose();
        return this.conn;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        logger.finer("getMoreResults");
        this.checkclose();
        return this.getMoreResults();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        logger.finer("getGeneratedKeys");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        logger.finer("executeUpdate");
        logger.finer("sql:" + sql);
        logger.finer("autoGeneratedKeys:" + autoGeneratedKeys);
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        logger.finer("executeUpdate");
        logger.finer("sql:" + sql);
        logger.finer("columnIndexes:" + Arrays.toString(columnIndexes));
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        logger.finer("executeUpdate");
        logger.finer("sql:" + sql);
        logger.finer("columnNames:" + Arrays.toString(columnNames));
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        logger.finer("execute");
        logger.finer("sql:" + sql);
        logger.finer("autoGeneratedKeys:" + autoGeneratedKeys);
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        logger.finer("execute");
        logger.finer("sql:" + sql);
        logger.finer("columnIndexes:" + Arrays.toString(columnIndexes));
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        logger.finer("execute");
        logger.finer("sql:" + sql);
        logger.finer("columnNames:" + Arrays.toString(columnNames));
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        logger.finer("getResultSetHoldability");
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        logger.finer("isClosed");
        return this.conn == null;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        logger.finer("setPoolable");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        logger.finer("isPoolable");
        return false;
    }
}

