/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.jdbc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.morilib.db.jdbc.AbstractBeanResultSet;
import net.morilib.db.jdbc.RelationsJDBCUtils;
import net.morilib.db.misc.ErrorBundle;

public class BeanListResultSet
extends AbstractBeanResultSet {
    private static Logger logger = RelationsJDBCUtils.logger;
    private List<Object> list;
    private int ptr = -1;
    private Object last = "last";

    public BeanListResultSet(Class<?> c, List<String> l, List<?> m) {
        super(c, l);
        this.list = new ArrayList(m);
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public boolean next() throws SQLException {
        return this.relative(1);
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.last.equals("");
    }

    static String _tolower(String s) {
        StringBuffer b = new StringBuffer();
        boolean e = false;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (b.length() == 0 || e) {
                b.append(Character.toUpperCase(c));
                e = false;
            } else if (c == '_') {
                e = true;
            } else {
                b.append(c);
                e = false;
            }
            ++i;
        }
        return b.toString();
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        logger.finer("getObject");
        if (this.ptr < 0 || this.ptr >= this.list.size()) {
            throw ErrorBundle.getDefault(20003, new Object[0]);
        }
        try {
            String s = "get" + BeanListResultSet._tolower(columnLabel);
            Method m = this.classe.getMethod(s, new Class[0]);
            Object o = this.list.get(this.ptr);
            Object p = m.invoke(o, new Object[0]);
            this.last = p == null ? "" : p;
            logger.finer(String.valueOf(columnLabel) + ":" + this.last);
            return this.last;
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw ErrorBundle.getDefault(10009, columnLabel);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.ptr < 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.ptr >= this.list.size();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.ptr == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.ptr == this.list.size() - 1;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.ptr = -1;
    }

    @Override
    public void afterLast() throws SQLException {
        this.ptr = this.list.size();
    }

    @Override
    public boolean first() throws SQLException {
        this.ptr = 0;
        return this.list.size() > 0;
    }

    @Override
    public boolean last() throws SQLException {
        this.ptr = this.list.size() - 1;
        return this.list.size() > 0;
    }

    @Override
    public int getRow() throws SQLException {
        return this.ptr + 1;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        int n = this.ptr = row < 0 ? this.list.size() + row : row - 1;
        int n2 = this.ptr < 0 ? -1 : (this.ptr = this.ptr > this.list.size() ? this.list.size() : this.ptr);
        return this.ptr >= 0 && this.ptr < this.list.size();
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.ptr += rows;
        int n = this.ptr < 0 ? -1 : (this.ptr = this.ptr > this.list.size() ? this.list.size() : this.ptr);
        return this.ptr >= 0 && this.ptr < this.list.size();
    }

    @Override
    public boolean previous() throws SQLException {
        return this.relative(-1);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1002;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public int getType() throws SQLException {
        return 1005;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public Statement getStatement() throws SQLException {
        return null;
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }
}

