/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.expr;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import net.morilib.db.delay.Delay;
import net.morilib.db.engine.SqlEngine;
import net.morilib.db.expr.RelationExpression;
import net.morilib.db.expr.RelationTernaryOperator;
import net.morilib.db.relations.RelationAggregate;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.schema.SqlSchema;

public class RelationTernaryOperate
extends RelationExpression {
    private RelationTernaryOperator op;
    private RelationExpression pa;
    private RelationExpression pb;
    private RelationExpression pc;

    public RelationTernaryOperate(RelationTernaryOperator o, RelationExpression a, RelationExpression b, RelationExpression c) {
        this.op = o;
        this.pa = a;
        this.pb = b;
        this.pc = c;
    }

    @Override
    public Object eval(SqlEngine v, SqlSchema f, RelationTuple tuple, RelationAggregate m, List<String> group, List<Object> h) throws IOException, SQLException {
        Object o = this.pa.eval(v, f, tuple, m, group, h);
        Object p = this.pb.eval(v, f, tuple, m, group, h);
        Object q = this.pc.eval(v, f, tuple, m, group, h);
        if (o instanceof Delay) {
            return o;
        }
        if (p instanceof Delay) {
            return p;
        }
        if (q instanceof Delay) {
            return q;
        }
        return this.op.op(o, p, q);
    }

    @Override
    public boolean isAggregate() throws SQLException {
        return this.pa.isAggregate() || this.pb.isAggregate() || this.pc.isAggregate();
    }

    @Override
    public Object init(SqlEngine v, SqlSchema f) throws SQLException {
        final Object o = this.pa.init(v, f);
        final Object p = this.pb.init(v, f);
        final Object q = this.pc.init(v, f);
        if (o instanceof Delay && p instanceof Delay && q instanceof Delay) {
            return new Delay(){

                @Override
                public Object force() throws SQLException {
                    return RelationTernaryOperate.this.op.op(((Delay)o).force(), ((Delay)p).force(), ((Delay)q).force());
                }

                @Override
                public void add(Object ... args) throws SQLException {
                    ((Delay)o).add(args);
                    ((Delay)p).add(args);
                    ((Delay)q).add(args);
                }
            };
        }
        if (o instanceof Delay && p instanceof Delay) {
            return new Delay(){

                @Override
                public Object force() throws SQLException {
                    return RelationTernaryOperate.this.op.op(((Delay)o).force(), ((Delay)p).force(), q);
                }

                @Override
                public void add(Object ... args) throws SQLException {
                    ((Delay)o).add(args);
                    ((Delay)p).add(args);
                }
            };
        }
        if (o instanceof Delay && q instanceof Delay) {
            return new Delay(){

                @Override
                public Object force() throws SQLException {
                    return RelationTernaryOperate.this.op.op(((Delay)o).force(), p, ((Delay)q).force());
                }

                @Override
                public void add(Object ... args) throws SQLException {
                    ((Delay)o).add(args);
                    ((Delay)q).add(args);
                }
            };
        }
        if (p instanceof Delay && q instanceof Delay) {
            return new Delay(){

                @Override
                public Object force() throws SQLException {
                    return RelationTernaryOperate.this.op.op(o, ((Delay)p).force(), ((Delay)q).force());
                }

                @Override
                public void add(Object ... args) throws SQLException {
                    ((Delay)p).add(args);
                    ((Delay)q).add(args);
                }
            };
        }
        if (o instanceof Delay) {
            return new Delay(){

                @Override
                public Object force() throws SQLException {
                    return RelationTernaryOperate.this.op.op(((Delay)o).force(), p, q);
                }

                @Override
                public void add(Object ... args) throws SQLException {
                    ((Delay)o).add(args);
                }
            };
        }
        if (p instanceof Delay) {
            return new Delay(){

                @Override
                public Object force() throws SQLException {
                    return RelationTernaryOperate.this.op.op(o, ((Delay)p).force(), q);
                }

                @Override
                public void add(Object ... args) throws SQLException {
                    ((Delay)p).add(args);
                }
            };
        }
        if (q instanceof Delay) {
            return new Delay(){

                @Override
                public Object force() throws SQLException {
                    return RelationTernaryOperate.this.op.op(o, p, ((Delay)q).force());
                }

                @Override
                public void add(Object ... args) throws SQLException {
                    ((Delay)q).add(args);
                }
            };
        }
        return this.op.op(o, p, q);
    }
}

