/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.expr;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import net.morilib.db.engine.SqlEngine;
import net.morilib.db.expr.RelationExpression;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.relations.Relation;
import net.morilib.db.relations.RelationAggregate;
import net.morilib.db.relations.RelationCursor;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.schema.SqlSchema;
import net.morilib.db.sqlcs.dml.SqlSelect;

public class RelationReferSubquery
extends RelationExpression {
    private SqlSelect select;
    private String name;

    public RelationReferSubquery(SqlSelect s) throws SQLException {
        if (s.getData().size() != 1) {
            throw ErrorBundle.getDefault(10013, new Object[0]);
        }
        this.select = s;
        this.name = s.getData().get(0).getAs();
        this.name = this.name != null ? this.name : "0";
    }

    @Override
    public Object eval(SqlEngine v, SqlSchema f, RelationTuple tuple, RelationAggregate m, List<String> group, List<Object> h) throws IOException, SQLException {
        Relation r = v.visit(f, this.select, tuple, h);
        RelationCursor i = r.iterator();
        if (i.hasNext()) {
            RelationTuple t = i.next();
            if (i.hasNext()) {
                throw ErrorBundle.getDefault(10014, new Object[0]);
            }
            return t.get(this.name);
        }
        return RelationExpression.NONE;
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    @Override
    public Object init(SqlEngine v, SqlSchema f) throws SQLException {
        return "";
    }
}

