/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.engine;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.morilib.db.engine.SqlEngine;
import net.morilib.db.expr.RelationBinaryOperate;
import net.morilib.db.expr.RelationBinaryOperator;
import net.morilib.db.expr.RelationConst;
import net.morilib.db.expr.RelationExists;
import net.morilib.db.expr.RelationExpression;
import net.morilib.db.expr.RelationFunction;
import net.morilib.db.expr.RelationFunctionApply;
import net.morilib.db.expr.RelationIn;
import net.morilib.db.expr.RelationInSubquery;
import net.morilib.db.expr.RelationRefer;
import net.morilib.db.expr.RelationReferSubquery;
import net.morilib.db.expr.RelationTernaryOperate;
import net.morilib.db.expr.RelationTernaryOperator;
import net.morilib.db.expr.RelationUnaryOperate;
import net.morilib.db.expr.RelationUnaryOperator;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.misc.Rational;
import net.morilib.db.misc.SqlResponse;
import net.morilib.db.relations.DefaultRelationTuple;
import net.morilib.db.relations.IsolatedRelation;
import net.morilib.db.relations.NamedRelation;
import net.morilib.db.relations.OperatedRelation;
import net.morilib.db.relations.Relation;
import net.morilib.db.relations.RelationAggregate;
import net.morilib.db.relations.RelationCursor;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.relations.Relations;
import net.morilib.db.relations.SingleTableRelation;
import net.morilib.db.relations.TableRelation;
import net.morilib.db.relations.TableRenameRelation;
import net.morilib.db.relations.UnionAllRelation;
import net.morilib.db.relations.VirtualCrossJoinRelation;
import net.morilib.db.schema.SqlSchema;
import net.morilib.db.schema.WithSqlSchema;
import net.morilib.db.sqlcs.ddl.SqlAlterTableAdd;
import net.morilib.db.sqlcs.ddl.SqlAlterTableDrop;
import net.morilib.db.sqlcs.ddl.SqlAlterTableModify;
import net.morilib.db.sqlcs.ddl.SqlAlterTableRenameColumn;
import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;
import net.morilib.db.sqlcs.ddl.SqlCreateTable;
import net.morilib.db.sqlcs.ddl.SqlDropTable;
import net.morilib.db.sqlcs.ddl.SqlTruncateTable;
import net.morilib.db.sqlcs.dml.SqlBinaryOperation;
import net.morilib.db.sqlcs.dml.SqlDelete;
import net.morilib.db.sqlcs.dml.SqlExists;
import net.morilib.db.sqlcs.dml.SqlExpression;
import net.morilib.db.sqlcs.dml.SqlExpressions;
import net.morilib.db.sqlcs.dml.SqlFunction;
import net.morilib.db.sqlcs.dml.SqlIn;
import net.morilib.db.sqlcs.dml.SqlInSubquery;
import net.morilib.db.sqlcs.dml.SqlInsertSelect;
import net.morilib.db.sqlcs.dml.SqlInsertValues;
import net.morilib.db.sqlcs.dml.SqlJoin;
import net.morilib.db.sqlcs.dml.SqlNumeric;
import net.morilib.db.sqlcs.dml.SqlPlaceHolder;
import net.morilib.db.sqlcs.dml.SqlRelation;
import net.morilib.db.sqlcs.dml.SqlSelect;
import net.morilib.db.sqlcs.dml.SqlSetBinaryOperation;
import net.morilib.db.sqlcs.dml.SqlSetExpression;
import net.morilib.db.sqlcs.dml.SqlString;
import net.morilib.db.sqlcs.dml.SqlSubqueryLiteral;
import net.morilib.db.sqlcs.dml.SqlSubqueryRelation;
import net.morilib.db.sqlcs.dml.SqlSymbol;
import net.morilib.db.sqlcs.dml.SqlTable;
import net.morilib.db.sqlcs.dml.SqlTernaryOperation;
import net.morilib.db.sqlcs.dml.SqlUnaryOperation;
import net.morilib.db.sqlcs.dml.SqlUpdate;
import net.morilib.db.sqlcs.dml.SqlWith;

public class DefaultSqlEngine
extends SqlEngine {
    @Override
    public Relation visit(SqlSchema f, SqlRelation t, List<Object> h) throws IOException, SQLException {
        if (t instanceof SqlTable) {
            SqlTable tt = (SqlTable)t;
            return f.readRelation(tt.getName(), tt.getAs());
        }
        if (t instanceof SqlJoin) {
            SqlJoin tj = (SqlJoin)t;
            Relation a = this.visit(f, tj.getJoinee(), h);
            Relation b = this.visit(f, tj.getJoiner(), h);
            return Relations.join(this, f, this.visit(tj.getOn(), h), a, b, null, null, tj.getType(), h);
        }
        if (t instanceof SqlSubqueryRelation) {
            SqlSubqueryRelation ts = (SqlSubqueryRelation)t;
            return new TableRenameRelation(this.visit(f, ts.getSubquery(), Relations.NULLTUPLE, h), ts.getAs());
        }
        throw new RuntimeException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Relation visit(SqlSchema sch, SqlSelect t, RelationTuple e, List<Object> hl) throws IOException, SQLException {
        Collection<RelationTuple> l;
        LinkedHashMap<String, Object> n;
        RelationCursor c;
        SqlSchema f;
        boolean[] ag = new boolean[1];
        Relation r = null;
        Map<String, SqlSetExpression> b = t.getWith();
        if (b != null) {
            f = new WithSqlSchema(sch);
            for (String string : b.keySet()) {
                f.bindSchema(string, this.visit(f, b.get(string), Collections.<Object>emptyList()));
            }
        } else {
            f = sch;
        }
        if (t.getTables() != null && t.getTables().size() > 0) {
            for (SqlRelation sqlRelation : t.getTables()) {
                Relation a = this.visit(f, sqlRelation, hl);
                Relation relation = r = r != null ? new VirtualCrossJoinRelation(r, a) : a;
            }
            if (r instanceof SingleTableRelation) {
                r = new IsolatedRelation((SingleTableRelation)r, ((SingleTableRelation)r).getName());
            } else if (r instanceof TableRenameRelation) {
                r = new IsolatedRelation(((TableRenameRelation)r).getRelation(), ((TableRenameRelation)r).getName());
            }
        } else {
            r = Relations.DUAL;
        }
        r = r.select(this, f, this.visit(t.getWhere(), hl), null, t.getDistinct(), e, null, hl);
        OperatedRelation o = Relations.operate(this, f, r, t.getData(), t.getGroupby(), hl, ag);
        if (t.getGroupby() != null && t.getGroupby().size() > 0 || ag[0]) {
            String v;
            void var22_14;
            c = o.iterator();
            while (c.hasNext()) {
                c.next();
            }
            n = new LinkedHashMap<String, Object>();
            l = t.getDistinct().create();
            ArrayList<SqlColumnDefinition> h = new ArrayList<SqlColumnDefinition>();
            boolean bl = false;
            while (var22_14 < t.getData().size()) {
                v = t.getData().get((int)var22_14).getAs();
                v = v != null ? v : String.valueOf((int)var22_14);
                String k = o.getColumnNames().get((int)var22_14).getName();
                h.add(new SqlColumnDefinition(v, o.getDefinition(k).getType(), o.getDefinition(k).getAttributes()));
                ++var22_14;
            }
            List<RelationAggregate> m = o.getMap();
            if (!m.get(0).isEmpty()) {
                for (Object object : m.get(0).keySet()) {
                    int i2 = 0;
                    while (i2 < t.getData().size()) {
                        RelationAggregate p = m.get(i2);
                        v = t.getData().get(i2).getAs();
                        String string = v = v != null ? v : String.valueOf(i2);
                        if (p.containsKey(object)) {
                            n.put(v, p.get(object).force());
                        } else {
                            n.put(v, "");
                        }
                        ++i2;
                    }
                    l.add(new DefaultRelationTuple(n));
                }
            } else if (t.getGroupby() == null || t.getGroupby().size() == 0) {
                void var22_17;
                boolean bl2 = false;
                while (var22_17 < t.getData().size()) {
                    v = t.getData().get((int)var22_17).getAs();
                    String string = v = v != null ? v : String.valueOf((int)var22_17);
                    if (m.get((int)var22_17).getInit() != null) {
                        n.put(v, m.get((int)var22_17).getInit().force());
                    } else {
                        n.put(v, Rational.ZERO);
                    }
                    ++var22_17;
                }
                l.add(new DefaultRelationTuple(n));
            }
            r = new TableRelation(h, l);
            r = r.select(this, f, this.visit(t.getHaving(), hl), null, t.getDistinct(), e, null, hl);
        } else {
            r = o;
        }
        if (t.getOrderby() != null && t.getOrderby().size() > 0) {
            ArrayList<RelationTuple> s = new ArrayList<RelationTuple>();
            c = r.iterator();
            while (c.hasNext()) {
                s.add(c.next());
            }
            RelationTuple[] d = s.toArray(new RelationTuple[0]);
            Arrays.sort(d, Relations.getComparator(r, t.getOrderby()));
            s = Arrays.asList(d);
            r = new TableRelation(r.getColumnNames(), s);
        }
        l = t.getDistinct().create();
        n = new LinkedHashMap();
        c = r.iterator();
        while (c.hasNext()) {
            RelationTuple w = c.next();
            for (SqlColumnDefinition sqlColumnDefinition : r.getColumnNames()) {
                n.put(sqlColumnDefinition.getName(), w.get(sqlColumnDefinition.getName()));
            }
            l.add(new DefaultRelationTuple(n));
        }
        r = new TableRelation(r.getColumnNames(), l);
        return r;
    }

    @Override
    public RelationExpression visit(SqlExpression e, List<Object> h) throws SQLException {
        ArrayList<RelationExpression> l = new ArrayList<RelationExpression>();
        if (e == null) {
            return new RelationConst(Rational.ONE);
        }
        if (e instanceof SqlNumeric) {
            return new RelationConst(((SqlNumeric)e).getValue());
        }
        if (e instanceof SqlString) {
            return new RelationConst(((SqlString)e).getValue());
        }
        if (e instanceof SqlSymbol) {
            return new RelationRefer(((SqlSymbol)e).getValue());
        }
        if (e instanceof SqlSubqueryLiteral) {
            return new RelationReferSubquery(((SqlSubqueryLiteral)e).getQuery());
        }
        if (e instanceof SqlPlaceHolder) {
            int j = ((SqlPlaceHolder)e).getNumber() - 1;
            if (j < 0 || j >= h.size()) {
                throw ErrorBundle.getDefault(10036, new Object[0]);
            }
            return new RelationConst(h.get(j));
        }
        if (e instanceof SqlBinaryOperation) {
            SqlBinaryOperation b = (SqlBinaryOperation)e;
            return new RelationBinaryOperate(RelationBinaryOperator.get(b.getOperator()), this.visit(b.getOperand1(), h), this.visit(b.getOperand2(), h));
        }
        if (e instanceof SqlUnaryOperation) {
            SqlUnaryOperation u = (SqlUnaryOperation)e;
            return new RelationUnaryOperate(RelationUnaryOperator.get(u.getOperator()), this.visit(u.getOperand1(), h));
        }
        if (e instanceof SqlTernaryOperation) {
            SqlTernaryOperation t = (SqlTernaryOperation)e;
            return new RelationTernaryOperate(RelationTernaryOperator.get(t.getOperator()), this.visit(t.getOperand1(), h), this.visit(t.getOperand2(), h), this.visit(t.getOperand3(), h));
        }
        if (e instanceof SqlIn) {
            SqlIn n = (SqlIn)e;
            for (SqlExpression p : n.getValues()) {
                l.add(this.visit(p, h));
            }
            return new RelationIn(this.visit(n.getExpression(), h), l);
        }
        if (e instanceof SqlInSubquery) {
            SqlInSubquery q = (SqlInSubquery)e;
            return new RelationInSubquery(this.visit(q.getExpression(), h), q.getSelect());
        }
        if (e instanceof SqlExists) {
            return new RelationExists(((SqlExists)e).getQuery());
        }
        if (e instanceof SqlFunction) {
            for (SqlExpression p : ((SqlFunction)e).getArguments()) {
                l.add(this.visit(p, h));
            }
            return new RelationFunctionApply(RelationFunction.get(((SqlFunction)e).getName()), l);
        }
        if (e == SqlExpressions.ANY) {
            return Relations.ANY;
        }
        throw new RuntimeException();
    }

    @Override
    public synchronized int visit(SqlSchema f, SqlInsertValues t, List<Object> h) throws IOException, SQLException {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        ArrayList<RelationTuple> z = new ArrayList<RelationTuple>();
        NamedRelation r = f.readRelation(t.getName(), null);
        SqlCreateTable c = f.getCreateTable(t.getName());
        RelationCursor j = r.iterator();
        List<String> l = t.getColumns();
        if (l == null) {
            l = new ArrayList<String>();
            for (SqlColumnDefinition v : r.getColumnNames()) {
                l.add(v.getName());
            }
        }
        int i = 0;
        while (i < t.getExprs().size()) {
            RelationExpression x = this.visit(t.getExprs().get(i), h);
            m.put(l.get(i), x.eval(this, f, Relations.NULLTUPLE, null, null, h));
            ++i;
        }
        i = 0;
        while (i < c.getColumnDefinitions().size()) {
            String s = c.getColumnDefinitions().get(i).getName();
            if (!m.containsKey(s)) {
                m.put(s, "");
            }
            ++i;
        }
        while (j.hasNext()) {
            RelationTuple p = j.next();
            if (Relations.isKey(p, m, c.getKeys())) {
                throw ErrorBundle.getDefault(10001, new Object[0]);
            }
            z.add(p);
        }
        z.add(new DefaultRelationTuple(m));
        f.writeRelation(t.getName(), z);
        return 1;
    }

    @Override
    public int visit(SqlSchema f, SqlUpdate t, List<Object> h) throws IOException, SQLException {
        ArrayList<RelationTuple> z = new ArrayList<RelationTuple>();
        NamedRelation r = f.readRelation(t.getTable(), null);
        RelationCursor j = r.iterator();
        RelationExpression x = null;
        int n = 0;
        if (t.getWhere() != null) {
            x = this.visit(t.getWhere(), h);
        }
        ArrayList<RelationExpression> y = new ArrayList<RelationExpression>();
        for (SqlExpression b : t.getExpressions()) {
            y.add(this.visit(b, h));
        }
        while (j.hasNext()) {
            RelationTuple p = j.next();
            if (x != null && !x.test(this, f, p, null, null, h).isTrue()) {
                z.add(p);
                continue;
            }
            LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>(p.toMap());
            int i = 0;
            while (i < y.size()) {
                m.put(t.getNames().get(i), ((RelationExpression)y.get(i)).eval(this, f, p, null, null, h));
                ++i;
            }
            z.add(new DefaultRelationTuple(m));
            ++n;
        }
        f.writeRelation(t.getTable(), z);
        return n;
    }

    @Override
    public int visit(SqlSchema f, SqlDelete t, List<Object> h) throws IOException, SQLException {
        ArrayList<RelationTuple> z = new ArrayList<RelationTuple>();
        NamedRelation r = f.readRelation(t.getName(), null);
        RelationCursor j = r.iterator();
        RelationExpression x = null;
        int n = 0;
        if (t.getExpression() != null) {
            x = this.visit(t.getExpression(), h);
        }
        while (j.hasNext()) {
            RelationTuple p = j.next();
            if (x != null && !x.test(this, f, p, null, null, h).isTrue()) {
                z.add(p);
                continue;
            }
            ++n;
        }
        f.writeRelation(t.getName(), z);
        return n;
    }

    Relation _union(SqlSchema f, Relation a, Relation b) throws IOException, SQLException {
        List<SqlColumnDefinition> p = a.getColumnNames();
        if (p.size() != b.getColumnNames().size()) {
            throw ErrorBundle.getDefault(10002, new Object[0]);
        }
        LinkedHashSet<RelationTuple> l = new LinkedHashSet<RelationTuple>();
        RelationCursor c = a.iterator();
        while (c.hasNext()) {
            l.add(new DefaultRelationTuple(c.next().toMap()));
        }
        c = b.iterator();
        LinkedHashMap<String, Object> n = new LinkedHashMap<String, Object>();
        while (c.hasNext()) {
            int i = 0;
            Map<String, Object> m = c.next().toMap();
            for (String s : m.keySet()) {
                n.put(p.get(i++).getName(), m.get(s));
            }
            l.add(new DefaultRelationTuple(n));
        }
        return new TableRelation(p, l);
    }

    Relation _intersect(SqlSchema f, Relation a, Relation b) throws IOException, SQLException {
        List<SqlColumnDefinition> p = a.getColumnNames();
        if (p.size() != b.getColumnNames().size()) {
            throw ErrorBundle.getDefault(10002, new Object[0]);
        }
        LinkedHashSet<RelationTuple> l = new LinkedHashSet<RelationTuple>();
        RelationCursor c = a.iterator();
        while (c.hasNext()) {
            l.add(new DefaultRelationTuple(c.next().toMap()));
        }
        LinkedHashSet<DefaultRelationTuple> q = new LinkedHashSet<DefaultRelationTuple>();
        c = b.iterator();
        LinkedHashMap<String, Object> n = new LinkedHashMap<String, Object>();
        while (c.hasNext()) {
            int i = 0;
            Map<String, Object> m = c.next().toMap();
            for (String s : m.keySet()) {
                n.put(p.get(i++).getName(), m.get(s));
            }
            q.add(new DefaultRelationTuple(n));
        }
        l.retainAll(q);
        return new TableRelation(p, l);
    }

    Relation _except(SqlSchema f, Relation a, Relation b) throws IOException, SQLException {
        List<SqlColumnDefinition> p = a.getColumnNames();
        if (p.size() != b.getColumnNames().size()) {
            throw ErrorBundle.getDefault(10002, new Object[0]);
        }
        LinkedHashSet<RelationTuple> l = new LinkedHashSet<RelationTuple>();
        RelationCursor c = a.iterator();
        while (c.hasNext()) {
            l.add(new DefaultRelationTuple(c.next().toMap()));
        }
        c = b.iterator();
        LinkedHashMap<String, Object> n = new LinkedHashMap<String, Object>();
        while (c.hasNext()) {
            int i = 0;
            Map<String, Object> m = c.next().toMap();
            for (String s : m.keySet()) {
                n.put(p.get(i++).getName(), m.get(s));
            }
            DefaultRelationTuple t = new DefaultRelationTuple(n);
            if (!l.contains(t)) continue;
            l.remove(t);
        }
        return new TableRelation(p, l);
    }

    private boolean _in(RelationTuple t, RelationTuple v, Relation b) throws SQLException {
        for (SqlColumnDefinition s : b.getColumnNames()) {
            if (t.get(s.getName()).equals(v.get(s.getName()))) continue;
            return false;
        }
        return true;
    }

    Relation _divide(SqlSchema f, Relation a, Relation b) throws IOException, SQLException {
        LinkedHashMap<String, Object> n = new LinkedHashMap<String, Object>();
        LinkedHashSet<DefaultRelationTuple> l = null;
        ArrayList<SqlColumnDefinition> p = new ArrayList<SqlColumnDefinition>(a.getColumnNames());
        Iterator i = p.iterator();
        while (i.hasNext()) {
            SqlColumnDefinition d = (SqlColumnDefinition)i.next();
            for (SqlColumnDefinition g : b.getColumnNames()) {
                if (!d.getName().equals(g.getName())) continue;
                i.remove();
            }
        }
        RelationCursor c = b.iterator();
        while (c.hasNext()) {
            RelationTuple t = c.next();
            RelationCursor j = a.iterator();
            LinkedHashSet<DefaultRelationTuple> m = new LinkedHashSet<DefaultRelationTuple>();
            while (j.hasNext()) {
                RelationTuple v = j.next();
                if (!this._in(v, t, b)) continue;
                for (SqlColumnDefinition s : p) {
                    n.put(s.getName(), v.get(s.getName()));
                }
                m.add(new DefaultRelationTuple(n));
            }
            if (l == null) {
                l = m;
                continue;
            }
            l.retainAll(m);
        }
        if (l == null) {
            throw ErrorBundle.getDefault(10003, new Object[0]);
        }
        return new TableRelation(p, l);
    }

    @Override
    public Relation visit(SqlSchema f, SqlSetExpression s, List<Object> h) throws IOException, SQLException {
        if (s instanceof SqlSetBinaryOperation) {
            SqlSetBinaryOperation b = (SqlSetBinaryOperation)s;
            Relation x = this.visit(f, b.getExpression1(), h);
            Relation y = this.visit(f, b.getExpression2(), h);
            switch (b.getOpeator()) {
                case UNION: {
                    return this._union(f, x, y);
                }
                case UNION_ALL: {
                    return new UnionAllRelation(x, y);
                }
                case INTERSECT: {
                    return this._intersect(f, x, y);
                }
                case MINUS: {
                    return this._except(f, x, y);
                }
                case DIVIDE: {
                    return this._divide(f, x, y);
                }
            }
        } else {
            if (s instanceof SqlSelect) {
                return this.visit(f, (SqlSelect)s, Relations.NULLTUPLE, h);
            }
            throw new NullPointerException();
        }
        return null;
    }

    @Override
    public Object visit(SqlSchema f, SqlCreateTable c) throws IOException, SQLException {
        f.putCreateTable(c.getName(), c);
        return new SqlResponse(true, "Table created");
    }

    @Override
    public Object visit(SqlSchema f, SqlDropTable c) throws IOException, SQLException {
        f.removeCreateTable(c.getName());
        return new SqlResponse(true, "Table dropped");
    }

    @Override
    public Object visit(SqlSchema f, SqlTruncateTable c) throws IOException, SQLException {
        f.truncateTable(c.getName());
        return new SqlResponse(true, "Table truncated");
    }

    @Override
    public Object visit(SqlSchema f, SqlAlterTableAdd c) throws IOException, SQLException {
        SqlCreateTable t = f.getCreateTable(c.getName());
        List<SqlColumnDefinition> l = t.getColumnDefinitions();
        l = new ArrayList<SqlColumnDefinition>(l);
        for (SqlColumnDefinition x : c.getColumnDefinitions()) {
            if (t.findColumn(x.getName()) != null) {
                throw ErrorBundle.getDefault(10005, new Object[0]);
            }
            l.add(x);
        }
        ArrayList<RelationTuple> z = new ArrayList<RelationTuple>();
        NamedRelation r = f.readRelation(c.getName(), null);
        RelationCursor s = r.iterator();
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        while (s.hasNext()) {
            RelationTuple v = s.next();
            for (SqlColumnDefinition x : t.getColumnDefinitions()) {
                m.put(x.getName(), v.get(x.getName()));
            }
            for (SqlColumnDefinition x : c.getColumnDefinitions()) {
                m.put(x.getName(), "");
            }
            z.add(new DefaultRelationTuple(m));
        }
        t = new SqlCreateTable(c.getName(), l);
        f.alterCreateTable(c.getName(), t);
        f.writeRelation(c.getName(), z);
        return new SqlResponse(true, "Table columns added");
    }

    @Override
    public Object visit(SqlSchema f, SqlAlterTableModify c) throws IOException, SQLException {
        List<SqlColumnDefinition> p;
        SqlCreateTable t = f.getCreateTable(c.getName());
        List<SqlColumnDefinition> l = p = t.getColumnDefinitions();
        l = new ArrayList<SqlColumnDefinition>(l);
        for (SqlColumnDefinition x : c.getColumnDefinitions()) {
            SqlColumnDefinition y = t.findColumn(x.getName());
            if (y == null) {
                throw ErrorBundle.getDefault(10006, new Object[0]);
            }
            l.set(l.indexOf(y), x);
        }
        ArrayList<RelationTuple> z = new ArrayList<RelationTuple>();
        NamedRelation r = f.readRelation(c.getName(), null);
        RelationCursor s = r.iterator();
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        while (s.hasNext()) {
            RelationTuple v = s.next();
            int i = 0;
            while (i < l.size()) {
                m.put(l.get(i).getName(), v.get(p.get(i).getName()));
                ++i;
            }
            z.add(new DefaultRelationTuple(m));
        }
        t = new SqlCreateTable(c.getName(), l);
        f.alterCreateTable(c.getName(), t);
        f.writeRelation(c.getName(), z);
        return new SqlResponse(true, "Table columns modified");
    }

    @Override
    public Object visit(SqlSchema f, SqlAlterTableDrop c) throws IOException, SQLException {
        SqlCreateTable t = f.getCreateTable(c.getName());
        List<SqlColumnDefinition> l = t.getColumnDefinitions();
        l = new ArrayList<SqlColumnDefinition>(l);
        for (String x : c.getColumnNames()) {
            SqlColumnDefinition y = t.findColumn(x);
            if (y == null) {
                throw ErrorBundle.getDefault(10006, new Object[0]);
            }
            l.remove(y);
        }
        ArrayList<RelationTuple> z = new ArrayList<RelationTuple>();
        NamedRelation r = f.readRelation(c.getName(), null);
        RelationCursor s = r.iterator();
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        while (s.hasNext()) {
            RelationTuple v = s.next();
            int i = 0;
            while (i < l.size()) {
                m.put(l.get(i).getName(), v.get(l.get(i).getName()));
                ++i;
            }
            z.add(new DefaultRelationTuple(m));
        }
        t = new SqlCreateTable(c.getName(), l);
        f.alterCreateTable(c.getName(), t);
        f.writeRelation(c.getName(), z);
        return new SqlResponse(true, "Table columns dropped");
    }

    @Override
    public Object visit(SqlSchema f, SqlAlterTableRenameColumn c) throws IOException, SQLException {
        List<SqlColumnDefinition> p;
        SqlCreateTable t = f.getCreateTable(c.getTableName());
        List<SqlColumnDefinition> l = p = t.getColumnDefinitions();
        l = new ArrayList<SqlColumnDefinition>(l);
        SqlColumnDefinition y = t.findColumn(c.getColumnNameFrom());
        if (y == null) {
            throw ErrorBundle.getDefault(10006, new Object[0]);
        }
        SqlColumnDefinition d = new SqlColumnDefinition(c.getColumnNameTo(), y.getType(), y.getAttributes());
        l.set(l.indexOf(y), d);
        ArrayList<RelationTuple> z = new ArrayList<RelationTuple>();
        NamedRelation r = f.readRelation(c.getTableName(), null);
        RelationCursor s = r.iterator();
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        while (s.hasNext()) {
            RelationTuple v = s.next();
            int i = 0;
            while (i < l.size()) {
                m.put(l.get(i).getName(), v.get(p.get(i).getName()));
                ++i;
            }
            z.add(new DefaultRelationTuple(m));
        }
        t = new SqlCreateTable(c.getTableName(), l);
        f.alterCreateTable(c.getTableName(), t);
        f.writeRelation(c.getTableName(), z);
        return new SqlResponse(true, "Table column renamed");
    }

    @Override
    public int visit(SqlSchema f, SqlInsertSelect t, List<Object> h) throws IOException, SQLException {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        ArrayList<RelationTuple> z = new ArrayList<RelationTuple>();
        NamedRelation r = f.readRelation(t.getName(), null);
        SqlCreateTable c = f.getCreateTable(t.getName());
        Relation v = this.visit(f, t.getSelect(), Relations.NULLTUPLE, h);
        if (t.getColumns().size() != r.getColumnNames().size()) {
            throw ErrorBundle.getDefault(10002, new Object[0]);
        }
        RelationCursor j = r.iterator();
        while (j.hasNext()) {
            z.add(j.next());
        }
        RelationCursor k = v.iterator();
        int w = 0;
        while (k.hasNext()) {
            RelationTuple q = k.next();
            int i = 0;
            while (i < t.getColumns().size()) {
                m.put(t.getColumns().get(i), q.get(v.getColumnNames().get(i).getName()));
                ++i;
            }
            j = r.iterator();
            while (j.hasNext()) {
                RelationTuple p = j.next();
                if (!Relations.isKey(p, m, c.getKeys())) continue;
                throw ErrorBundle.getDefault(10001, new Object[0]);
            }
            z.add(new DefaultRelationTuple(m));
            ++w;
        }
        f.writeRelation(t.getName(), z);
        return w;
    }

    @Override
    public Object visit(SqlSchema f, SqlWith c) throws IOException, SQLException {
        Map<String, SqlSetExpression> m = c.getWith();
        for (String x : m.keySet()) {
            f.bindSchema(x, this.visit(f, m.get(x), Collections.<Object>emptyList()));
        }
        return new SqlResponse(true, "With statement processed");
    }
}

