package net.morilib.db.fichier;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class FileFichier implements Fichier {

	File file;

	FileFichier(File f) {
		file = f;
	}

	@Override
	public boolean isFile() {
		return file.isFile();
	}

	@Override
	public boolean createNewFile() throws IOException {
		return file.createNewFile();
	}

	@Override
	public Reader openReader() throws IOException {
		return new FileReader(file);
	}

	@Override
	public Writer openWriter() throws IOException {
		return new FileWriter(file);
	}

	@Override
	public String getName() {
		return file.getName();
	}

	@Override
	public boolean delete() {
		return file.delete();
	}

	@Override
	public Fichier[] listFichiers() {
		File[] a = file.listFiles();
		Fichier[] f = new Fichier[a.length];

		for(int i = 0; i < a.length; i++) {
			f[i] = new FileFichier(a[i]);
		}
		return f;
	}

	@Override
	public boolean renameTo(Fichier name) {
		return file.renameTo(((FileFichier)name).file);
	}

}
