/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.sqlcs.ddl;

import java.util.EnumSet;
import net.morilib.db.sqlcs.ddl.SqlColumnAttribute;
import net.morilib.db.sqlcs.ddl.SqlColumnType;

public class SqlColumnDefinition {
    private String name;
    private SqlColumnType type;
    private EnumSet<SqlColumnAttribute> attrs;

    public SqlColumnDefinition(String name, SqlColumnType type, EnumSet<SqlColumnAttribute> attrs) {
        this.name = name;
        this.type = type;
        this.attrs = attrs;
    }

    public String getName() {
        return this.name;
    }

    public SqlColumnType getType() {
        return this.type;
    }

    public EnumSet<SqlColumnAttribute> getAttributes() {
        return EnumSet.copyOf(this.attrs);
    }

    public boolean isSame(SqlColumnDefinition d) {
        return this.type.equals(d.type) && this.attrs.equals(d.getAttributes());
    }

    public String toString() {
        StringBuffer b = new StringBuffer(this.name);
        b.append(' ').append(this.type);
        for (SqlColumnAttribute a : this.attrs) {
            b.append(' ').append((Object)a);
        }
        return b.toString();
    }
}

