/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.sql;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.SQLException;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.misc.Rational;
import net.morilib.db.sql.DbSqlReserved;
import net.morilib.db.sql.DbSqlSymbol;
import net.morilib.db.sqlcs.dml.SqlBinaryOperator;

public class DbSqlLexer {
    static final Object END = new Object(){

        public String toString() {
            return "END";
        }
    };
    private Object lookahead;
    private PushbackReader reader;
    private int placeNumber = 1;

    public DbSqlLexer(Reader r) throws IOException, SQLException {
        this.reader = new PushbackReader(r);
        this.lookahead = DbSqlLexer.lex(this.reader);
    }

    public boolean eq(Object c) throws IOException, SQLException {
        Object l = this.get();
        if (l == c) {
            this.next();
            return true;
        }
        return false;
    }

    public void eat(Object c) throws IOException, SQLException {
        Object l = this.get();
        if (l != c) {
            throw ErrorBundle.getDefault(10020, c.toString(), l.toString());
        }
        this.next();
    }

    public boolean eqchar(char c) throws IOException, SQLException {
        Object l = this.get();
        if (l instanceof Character && ((Character)l).charValue() == c) {
            this.next();
            return true;
        }
        return false;
    }

    public void eatchar(char c) throws IOException, SQLException {
        Object l = this.get();
        if (!(l instanceof Character) || ((Character)l).charValue() != c) {
            throw ErrorBundle.getDefault(10020, Character.toString(c), l.toString());
        }
        this.next();
    }

    public boolean eqsym(String s) throws IOException, SQLException {
        Object l = this.get();
        if (l instanceof DbSqlSymbol && ((DbSqlSymbol)l).toString().equalsIgnoreCase(s)) {
            this.next();
            return true;
        }
        return false;
    }

    public void eatsym(String s) throws IOException, SQLException {
        Object l = this.get();
        if (!(l instanceof DbSqlSymbol) || !((DbSqlSymbol)l).toString().equalsIgnoreCase(s)) {
            throw ErrorBundle.getDefault(10020, s, l.toString());
        }
        this.next();
    }

    public String getsym() throws IOException, SQLException {
        Object l = this.get();
        if (l instanceof DbSqlSymbol) {
            this.next();
            return l.toString();
        }
        return null;
    }

    public String eatsym() throws IOException, SQLException {
        Object l = this.get();
        if (l instanceof DbSqlSymbol) {
            this.next();
            return l.toString();
        }
        throw ErrorBundle.getDefault(10020, "symbol", l.toString());
    }

    public String getstr() throws IOException, SQLException {
        Object l = this.get();
        if (l instanceof String) {
            this.next();
            return l.toString();
        }
        return null;
    }

    public Rational getnum() throws IOException, SQLException {
        Object l = this.get();
        if (l instanceof Rational) {
            this.next();
            return (Rational)l;
        }
        return null;
    }

    public SqlBinaryOperator getrelop() throws IOException, SQLException {
        Object l = this.get();
        if (l instanceof SqlBinaryOperator) {
            this.next();
            return (SqlBinaryOperator)((Object)l);
        }
        return null;
    }

    public int eatsmallint() throws IOException, SQLException {
        Object l = this.get();
        if (l instanceof Rational) {
            try {
                int j = ((Rational)l).toBigDecimal().intValueExact();
                this.next();
                return j;
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
        throw ErrorBundle.getDefault(10020, "small integer", l.toString());
    }

    public boolean isEnd() {
        return this.lookahead == END;
    }

    private static Object lex(PushbackReader r) throws IOException, SQLException {
        StringBuffer b = null;
        S stat = S.INI;
        block15: while (true) {
            int c = r.read();
            switch (stat) {
                case INI: {
                    if (c < 0) {
                        return END;
                    }
                    if (c == 39) {
                        b = new StringBuffer();
                        stat = S.QUO;
                        continue block15;
                    }
                    if (c == 34) {
                        b = new StringBuffer();
                        stat = S.DQO;
                        continue block15;
                    }
                    if (c == 124) {
                        stat = S.BAR;
                        continue block15;
                    }
                    if (Character.isJavaIdentifierStart(c)) {
                        b = new StringBuffer().append((char)c);
                        stat = S.SYM;
                        continue block15;
                    }
                    if (c == 60) {
                        stat = S.LT;
                        continue block15;
                    }
                    if (c == 62) {
                        stat = S.GT;
                        continue block15;
                    }
                    if (c == 33) {
                        stat = S.EX;
                        continue block15;
                    }
                    if (c == 61) {
                        return SqlBinaryOperator.EQ;
                    }
                    if (c >= 48 && c <= 57) {
                        b = new StringBuffer().append((char)c);
                        stat = S.NUM;
                        continue block15;
                    }
                    if (c == 46) {
                        b = new StringBuffer().append('0').append('.');
                        stat = S.NM2;
                        continue block15;
                    }
                    if (Character.isWhitespace(c)) continue block15;
                    return Character.valueOf((char)c);
                }
                case QUO: {
                    if (c < 0) {
                        throw ErrorBundle.getDefault(10021, new Object[0]);
                    }
                    if (c == 39) {
                        return b.toString();
                    }
                    if (c == 92) {
                        stat = S.QU2;
                        continue block15;
                    }
                    b.append((char)c);
                    continue block15;
                }
                case QU2: {
                    if (c < 0) {
                        throw ErrorBundle.getDefault(10021, new Object[0]);
                    }
                    b.append((char)c);
                    stat = S.QUO;
                    continue block15;
                }
                case BAR: {
                    if (c == 124) {
                        return DbSqlReserved.CONCAT;
                    }
                    if (c >= 0) {
                        r.unread((char)c);
                    }
                    return Character.valueOf('|');
                }
                case SYM: {
                    String s;
                    if (Character.isJavaIdentifierPart(c) || c == 46) {
                        b.append((char)c);
                        continue block15;
                    }
                    if (c >= 0) {
                        r.unread((char)c);
                    }
                    if ((s = b.toString().toUpperCase()).equals("LIKE")) {
                        return SqlBinaryOperator.LIKE;
                    }
                    try {
                        return DbSqlReserved.valueOf(s);
                    }
                    catch (IllegalArgumentException e) {
                        return new DbSqlSymbol(s);
                    }
                }
                case NUM: {
                    if (c == 46) {
                        b.append((char)c);
                        stat = S.NM2;
                        continue block15;
                    }
                    if (c >= 48 && c <= 57) {
                        b.append((char)c);
                        continue block15;
                    }
                    if (c >= 0) {
                        r.unread((char)c);
                    }
                    return Rational.valueOf(new BigDecimal(b.toString()));
                }
                case NM2: {
                    if (c >= 48 && c <= 57) {
                        b.append((char)c);
                        continue block15;
                    }
                    if (c >= 0) {
                        r.unread((char)c);
                    }
                    return Rational.valueOf(new BigDecimal(b.toString()));
                }
                case DQO: {
                    if (c < 0) {
                        throw ErrorBundle.getDefault(10021, new Object[0]);
                    }
                    if (c == 34) {
                        return new DbSqlSymbol(b.toString().toUpperCase());
                    }
                    b.append((char)c);
                    continue block15;
                }
                case LT: {
                    if (c == 61) {
                        return SqlBinaryOperator.LE;
                    }
                    if (c == 62) {
                        return SqlBinaryOperator.NE;
                    }
                    if (c >= 0) {
                        r.unread((char)c);
                    }
                    return SqlBinaryOperator.LT;
                }
                case GT: {
                    if (c == 61) {
                        return SqlBinaryOperator.GE;
                    }
                    if (c >= 0) {
                        r.unread((char)c);
                    }
                    return SqlBinaryOperator.GT;
                }
                case EX: {
                    if (c == 61) {
                        return SqlBinaryOperator.NE;
                    }
                    if (c >= 0) {
                        r.unread((char)c);
                    }
                    return Character.valueOf('!');
                }
            }
        }
    }

    public Object next() throws IOException, SQLException {
        return this.lookahead == END ? END : (this.lookahead = DbSqlLexer.lex(this.reader));
    }

    public Object get() {
        return this.lookahead;
    }

    public int nextPlaceNumber() {
        return this.placeNumber++;
    }

    public int getPlaceNumber() {
        return this.placeNumber;
    }

    private static enum S {
        INI,
        QUO,
        QU2,
        BAR,
        SYM,
        NUM,
        NM2,
        DQO,
        LT,
        GT,
        EX;

    }
}

