/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.relations;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.morilib.db.engine.SqlEngine;
import net.morilib.db.relations.RelationAggregate;
import net.morilib.db.relations.RelationExpression;
import net.morilib.db.relations.RelationFunction;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.schema.SqlSchema;

public class RelationFunctionApply
extends RelationExpression {
    private RelationFunction op;
    private List<RelationExpression> exs;

    public RelationFunctionApply(RelationFunction o, List<RelationExpression> ex) {
        this.op = o;
        this.exs = new ArrayList<RelationExpression>(ex);
    }

    @Override
    public Object eval(SqlEngine v, SqlSchema f, RelationTuple tuple, RelationAggregate m, List<String> group, List<Object> h) throws IOException, SQLException {
        Object[] a = new Object[this.exs.size()];
        ArrayList<Object> l = new ArrayList<Object>();
        int i = 0;
        while (i < this.exs.size()) {
            if (group != null) {
                for (String s : group) {
                    l.add(tuple.get(s));
                }
            }
            a[i] = this.exs.get(i).eval(v, f, tuple, m, group, h);
            ++i;
        }
        return this.op.operate(m, l, a);
    }

    @Override
    public boolean isAggregate() {
        return this.op.isAggregate();
    }

    @Override
    public Object init(RelationAggregate m) throws SQLException {
        return this.op.init(m);
    }
}

