/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.misc;

import java.sql.SQLException;
import java.util.Locale;
import java.util.ResourceBundle;

public final class ErrorBundle {
    private static final ErrorBundle _DEF = ErrorBundle.getInstance(Locale.getDefault());
    private ResourceBundle bundle;

    private ErrorBundle(ResourceBundle b) {
        this.bundle = b;
    }

    public static synchronized ErrorBundle getInstance(Locale locale) {
        ResourceBundle b = ResourceBundle.getBundle("net/morilib/db/misc/relations_errors", locale);
        return new ErrorBundle(b);
    }

    public SQLException getException(int code, Object ... mesg) {
        String s = this.bundle.getString(String.valueOf(code));
        if (s != null) {
            s = String.format(s, mesg);
            return new SQLException(s, null, code);
        }
        return new SQLException("unknown code: " + code, null, 99999);
    }

    public static SQLException getDefault(int code, Object ... mesg) {
        return _DEF.getException(code, mesg);
    }
}

