/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.jdbc;

import java.io.IOException;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.List;
import net.morilib.db.jdbc.RelationsConnection;
import net.morilib.db.jdbc.RelationsResultSet;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.relations.Relation;

public class RelationsStatement
implements Statement {
    RelationsConnection conn;
    int maxFieldSize = 0;
    int maxRows = 0;
    Relation select0 = null;
    int count0 = -1;
    List<String> batch;

    RelationsStatement(RelationsConnection c) {
        this.conn = c;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            Object o = this.conn.engine.execute(this.conn.schema, sql);
            if (o instanceof Relation) {
                return new RelationsResultSet(this, (Relation)o);
            }
            throw ErrorBundle.getDefault(10038, new Object[0]);
        }
        catch (IOException e) {
            throw ErrorBundle.getDefault(10037, new Object[0]);
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        try {
            Object o = this.conn.engine.execute(this.conn.schema, sql);
            if (o instanceof Number) {
                return ((Number)o).intValue();
            }
            return 0;
        }
        catch (IOException e) {
            throw ErrorBundle.getDefault(10037, new Object[0]);
        }
    }

    void checkclose() throws SQLException {
        if (this.conn == null) {
            throw ErrorBundle.getDefault(20002, new Object[0]);
        }
    }

    @Override
    public void close() throws SQLException {
        this.checkclose();
        this.conn = null;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.maxFieldSize = max;
        if (this.maxFieldSize < 0) {
            throw ErrorBundle.getDefault(20001, new Object[0]);
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.maxRows = max;
        if (this.maxRows < 0) {
            throw ErrorBundle.getDefault(20001, new Object[0]);
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
    }

    @Override
    public void cancel() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkclose();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkclose();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        block5: {
            Object o;
            block4: {
                this.checkclose();
                try {
                    o = this.conn.engine.execute(this.conn.schema, sql);
                    if (!(o instanceof Relation)) break block4;
                    this.select0 = (Relation)o;
                    return true;
                }
                catch (IOException e) {
                    throw ErrorBundle.getDefault(10037, new Object[0]);
                }
            }
            if (!(o instanceof Number)) break block5;
            this.count0 = ((Number)o).intValue();
            return false;
        }
        this.count0 = 0;
        return false;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkclose();
        if (this.select0 != null) {
            Relation s = this.select0;
            this.select0 = null;
            return new RelationsResultSet(this, s);
        }
        return null;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkclose();
        if (this.select0 != null) {
            int s = this.count0;
            this.count0 = -1;
            return s;
        }
        return -1;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkclose();
        return this.select0 != null;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1003;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkclose();
        RelationsStatement relationsStatement = this;
        synchronized (relationsStatement) {
            this.batch.add(sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearBatch() throws SQLException {
        this.checkclose();
        RelationsStatement relationsStatement = this;
        synchronized (relationsStatement) {
            this.batch.clear();
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int[] r = new int[this.batch.size()];
        this.checkclose();
        int i = 0;
        while (i < this.batch.size()) {
            try {
                Object o = this.conn.engine.execute(this.conn.schema, this.batch.get(i));
                if (o instanceof Relation) {
                    throw new BatchUpdateException();
                }
                r[i] = o instanceof Number ? ((Number)o).intValue() : -2;
            }
            catch (SQLException e) {
                throw new BatchUpdateException(e);
            }
            catch (IOException e) {
                throw ErrorBundle.getDefault(10037, new Object[0]);
            }
            ++i;
        }
        return r;
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkclose();
        return this.conn;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkclose();
        return this.getMoreResults();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.conn == null;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }
}

