/*
 * Decompiled with CFR 0.152.
 */
package org.ho.yaml;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.ho.util.Logger;
import org.ho.yaml.JYamlParserEvent;
import org.ho.yaml.SpecialTreatmentManager;
import org.ho.yaml.YamlConfig;
import org.ho.yaml.YamlParserException;
import org.ho.yaml.YamlStream;
import yaml.parser.SyntaxException;
import yaml.parser.YamlParser;
import yaml.parser.YamlParserEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YamlDecoder {
    BufferedReader in;
    SpecialTreatmentManager stManager = new SpecialTreatmentManager();
    YamlParser parser;
    YamlConfig config = YamlConfig.getDefaultConfig();

    YamlDecoder(String string, YamlConfig yamlConfig) throws FileNotFoundException {
        this(string);
        this.config = yamlConfig;
    }

    YamlDecoder(InputStream inputStream, YamlConfig yamlConfig) {
        this(inputStream);
        this.config = yamlConfig;
    }

    public YamlDecoder(InputStream inputStream) {
        this.in = new BufferedReader(new InputStreamReader(inputStream));
    }

    public YamlDecoder(File file) throws FileNotFoundException {
        this(new FileInputStream(file));
    }

    public YamlDecoder(String string) throws FileNotFoundException {
        this(new File(string));
    }

    public Object readObject() throws EOFException {
        try {
            JYamlParserEvent jYamlParserEvent = new JYamlParserEvent(this.createLogger(), this);
            if (this.parser == null) {
                this.parser = new YamlParser(this.in, jYamlParserEvent);
                this.firstDocument(this.parser, jYamlParserEvent);
            } else {
                this.parser.setEvent(jYamlParserEvent);
                if (!this.nextDocument(this.parser, jYamlParserEvent)) {
                    throw new EOFException();
                }
            }
            Object object = jYamlParserEvent.getBean();
            if (object == null) {
                throw new YamlParserException("Document is empty.");
            }
            return object;
        }
        catch (EOFException eOFException) {
            throw eOFException;
        }
        catch (Exception exception) {
            throw new YamlParserException(exception);
        }
    }

    public <T> YamlStream asStreamOfType(Class<T> clazz) {
        return new Stream<T>(clazz);
    }

    public YamlStream asStream() {
        return new Stream<Object>(Object.class);
    }

    Logger createLogger() {
        if (this.isSuppressWarnings()) {
            return new Logger(Logger.Level.NONE);
        }
        return new Logger();
    }

    void firstDocument(YamlParser yamlParser, YamlParserEvent yamlParserEvent) throws Exception {
        try {
            while (yamlParser.comment(-1, false)) {
            }
            if (!yamlParser.header()) {
                yamlParser.document_first();
            } else {
                yamlParser.value_na(-1);
            }
        }
        catch (SyntaxException syntaxException) {
            yamlParserEvent.error(syntaxException, syntaxException.line);
        }
    }

    boolean nextDocument(YamlParser yamlParser, YamlParserEvent yamlParserEvent) throws Exception {
        try {
            return yamlParser.document_next();
        }
        catch (SyntaxException syntaxException) {
            yamlParserEvent.error(syntaxException, syntaxException.line);
            return false;
        }
    }

    public <T> T readObjectOfType(Class<T> clazz) throws EOFException {
        try {
            JYamlParserEvent jYamlParserEvent = new JYamlParserEvent(clazz, this.createLogger(), this);
            if (this.parser == null) {
                this.parser = new YamlParser(this.in, jYamlParserEvent);
                this.firstDocument(this.parser, jYamlParserEvent);
            } else {
                this.parser.setEvent(jYamlParserEvent);
                if (!this.nextDocument(this.parser, jYamlParserEvent)) {
                    throw new EOFException();
                }
            }
            Object object = jYamlParserEvent.getBean();
            if (object == null) {
                throw new YamlParserException("Document is empty.");
            }
            return (T)object;
        }
        catch (EOFException eOFException) {
            throw eOFException;
        }
        catch (Exception exception) {
            throw new YamlParserException(exception);
        }
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isSuppressWarnings() {
        return this.config.isSuppressWarnings();
    }

    public void setSuppressWarnings(boolean bl) {
        this.config.setSuppressWarnings(bl);
    }

    SpecialTreatmentManager getStManager() {
        return this.stManager;
    }

    void setStManager(SpecialTreatmentManager specialTreatmentManager) {
        this.stManager = specialTreatmentManager;
    }

    public YamlConfig getConfig() {
        return this.config;
    }

    public void setConfig(YamlConfig yamlConfig) {
        this.config = yamlConfig;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Stream<T>
    implements YamlStream<T> {
        Class<T> clazz;
        T buffer;

        Stream(Class<T> clazz) {
            this.clazz = clazz;
            this.peek();
        }

        private void peek() {
            try {
                this.buffer = this.clazz == Object.class ? YamlDecoder.this.readObject() : YamlDecoder.this.readObjectOfType(this.clazz);
            }
            catch (EOFException eOFException) {
                YamlDecoder.this.close();
                this.buffer = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.buffer != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T t = this.buffer;
            this.peek();
            return t;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported.");
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }
    }
}

