/*
 * Decompiled with CFR 0.152.
 */
package org.ho.yaml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Iterator;
import org.ho.util.BiDirectionalMap;
import org.ho.yaml.YamlDecoder;
import org.ho.yaml.YamlEncoder;
import org.ho.yaml.YamlOperations;
import org.ho.yaml.YamlStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YamlConfig
implements YamlOperations,
Cloneable {
    private static YamlConfig defaultConfig;
    String indentAmount = "  ";
    boolean minimalOutput = false;
    boolean suppressWarnings = false;
    BiDirectionalMap<String, String> transfers = null;

    public static YamlConfig getDefaultConfig() {
        return defaultConfig;
    }

    public String getIndentAmount() {
        return this.indentAmount;
    }

    public void setIndentAmount(String string) {
        this.indentAmount = string;
    }

    public boolean isMinimalOutput() {
        return this.minimalOutput;
    }

    public void setMinimalOutput(boolean bl) {
        this.minimalOutput = bl;
    }

    public boolean isSuppressWarnings() {
        return this.suppressWarnings;
    }

    public void setSuppressWarnings(boolean bl) {
        this.suppressWarnings = bl;
    }

    public BiDirectionalMap<String, String> getTransfers() {
        return this.transfers;
    }

    public void setTransfers(BiDirectionalMap<String, String> biDirectionalMap) {
        this.transfers = biDirectionalMap;
    }

    String transfer2classname(String string) {
        if (this.transfers != null && this.transfers.containsKey(string)) {
            return (String)this.transfers.get(string);
        }
        return string;
    }

    String classname2transfer(String string) {
        if (this.transfers != null && this.transfers.getReverse().containsKey(string)) {
            return this.transfers.getReverse().get(string);
        }
        return string;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
    }

    public static YamlConfig fromFile(String string) throws FileNotFoundException, EOFException {
        YamlDecoder yamlDecoder = new YamlDecoder(string, new YamlConfig());
        YamlConfig yamlConfig = yamlDecoder.readObjectOfType(YamlConfig.class);
        yamlDecoder.close();
        return yamlConfig;
    }

    public static YamlConfig fromResource(String string) throws EOFException {
        YamlDecoder yamlDecoder = new YamlDecoder(YamlConfig.class.getClassLoader().getResourceAsStream(string), new YamlConfig());
        YamlConfig yamlConfig = yamlDecoder.readObjectOfType(YamlConfig.class);
        yamlDecoder.close();
        return yamlConfig;
    }

    @Override
    public Object load(InputStream inputStream) {
        YamlDecoder yamlDecoder = new YamlDecoder(inputStream);
        yamlDecoder.setConfig(this);
        Object object = null;
        try {
            object = yamlDecoder.readObject();
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return object;
    }

    @Override
    public Object load(File file) throws FileNotFoundException {
        return this.load(new FileInputStream(file));
    }

    @Override
    public Object load(String string) {
        return this.load(new ByteArrayInputStream(string.getBytes()));
    }

    @Override
    public <T> T loadType(InputStream inputStream, Class<T> clazz) {
        YamlDecoder yamlDecoder = new YamlDecoder(inputStream);
        yamlDecoder.setConfig(this);
        T t = null;
        try {
            t = yamlDecoder.readObjectOfType(clazz);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return t;
    }

    @Override
    public <T> T loadType(File file, Class<T> clazz) throws FileNotFoundException {
        return this.loadType(new FileInputStream(file), clazz);
    }

    @Override
    public <T> T loadType(String string, Class<T> clazz) {
        return this.loadType(new ByteArrayInputStream(string.getBytes()), clazz);
    }

    @Override
    public YamlStream loadStream(InputStream inputStream) {
        YamlDecoder yamlDecoder = new YamlDecoder(inputStream);
        yamlDecoder.setConfig(this);
        return yamlDecoder.asStream();
    }

    @Override
    public YamlStream loadStream(File file) throws FileNotFoundException {
        return this.loadStream(new FileInputStream(file));
    }

    @Override
    public YamlStream loadStream(String string) {
        return this.loadStream(new ByteArrayInputStream(string.getBytes()));
    }

    @Override
    public <T> YamlStream<T> loadStreamOfType(InputStream inputStream, Class<T> clazz) {
        YamlDecoder yamlDecoder = new YamlDecoder(inputStream);
        yamlDecoder.setConfig(this);
        return yamlDecoder.asStreamOfType(clazz);
    }

    @Override
    public <T> YamlStream<T> loadStreamOfType(File file, Class<T> clazz) throws FileNotFoundException {
        return this.loadStreamOfType(new FileInputStream(file), clazz);
    }

    @Override
    public <T> YamlStream<T> loadStreamOfType(String string, Class<T> clazz) throws FileNotFoundException {
        return this.loadStreamOfType(new ByteArrayInputStream(string.getBytes()), clazz);
    }

    @Override
    public void dump(Object object, File file) throws FileNotFoundException {
        YamlEncoder yamlEncoder = new YamlEncoder(new FileOutputStream(file));
        yamlEncoder.setConfig(this);
        yamlEncoder.writeObject(object);
        yamlEncoder.close();
    }

    @Override
    public void dump(Object object, File file, boolean bl) throws FileNotFoundException {
        YamlEncoder yamlEncoder = new YamlEncoder(new FileOutputStream(file));
        yamlEncoder.setConfig(this);
        yamlEncoder.setMinimalOutput(bl);
        yamlEncoder.writeObject(object);
        yamlEncoder.close();
    }

    @Override
    public void dumpStream(Iterator iterator, File file, boolean bl) throws FileNotFoundException {
        YamlEncoder yamlEncoder = new YamlEncoder(new FileOutputStream(file));
        yamlEncoder.setConfig(this);
        yamlEncoder.setMinimalOutput(bl);
        while (iterator.hasNext()) {
            yamlEncoder.writeObject(iterator.next());
        }
        yamlEncoder.close();
    }

    @Override
    public void dumpStream(Iterator iterator, File file) throws FileNotFoundException {
        YamlEncoder yamlEncoder = new YamlEncoder(new FileOutputStream(file));
        yamlEncoder.setConfig(this);
        while (iterator.hasNext()) {
            yamlEncoder.writeObject(iterator.next());
        }
        yamlEncoder.close();
    }

    @Override
    public String dump(Object object) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        YamlEncoder yamlEncoder = new YamlEncoder(byteArrayOutputStream);
        yamlEncoder.setConfig(this);
        yamlEncoder.writeObject(object);
        yamlEncoder.close();
        return new String(byteArrayOutputStream.toByteArray());
    }

    @Override
    public String dump(Object object, boolean bl) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        YamlEncoder yamlEncoder = new YamlEncoder(byteArrayOutputStream);
        yamlEncoder.setConfig(this);
        yamlEncoder.setMinimalOutput(bl);
        yamlEncoder.writeObject(object);
        yamlEncoder.close();
        return new String(byteArrayOutputStream.toByteArray());
    }

    @Override
    public String dumpStream(Iterator iterator) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        YamlEncoder yamlEncoder = new YamlEncoder(byteArrayOutputStream);
        yamlEncoder.setConfig(this);
        while (iterator.hasNext()) {
            yamlEncoder.writeObject(iterator.next());
        }
        yamlEncoder.close();
        return new String(byteArrayOutputStream.toByteArray());
    }

    @Override
    public String dumpStream(Iterator iterator, boolean bl) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        YamlEncoder yamlEncoder = new YamlEncoder(byteArrayOutputStream);
        yamlEncoder.setConfig(this);
        yamlEncoder.setMinimalOutput(bl);
        while (iterator.hasNext()) {
            yamlEncoder.writeObject(iterator.next());
        }
        yamlEncoder.close();
        return new String(byteArrayOutputStream.toByteArray());
    }

    static {
        try {
            defaultConfig = YamlConfig.fromResource("jyaml.yml");
        }
        catch (Exception exception) {
            try {
                defaultConfig = YamlConfig.fromFile("jyaml.yml");
            }
            catch (Exception exception2) {
                defaultConfig = new YamlConfig();
            }
        }
    }
}

