/*
 * Decompiled with CFR 0.152.
 */
package org.ho.yaml;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.ho.util.Logger;
import org.ho.yaml.ListState;
import org.ho.yaml.MapState;
import org.ho.yaml.ReflectionUtil;
import org.ho.yaml.YamlDecoder;
import org.ho.yaml.YamlParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class State {
    Logger logger;
    YamlDecoder decoder;
    Map<String, Object> aliasMap;
    Stack<State> stack;
    Object obj;
    String declaredClassname;
    String arrayComponentName;
    String anchorname;

    State(Map<String, Object> map, Stack<State> stack, YamlDecoder yamlDecoder, Logger logger) {
        this.aliasMap = map;
        this.stack = stack;
        this.decoder = yamlDecoder;
        this.logger = logger;
    }

    public void nextOnEvent(int n) {
        switch (n) {
            case 123: {
                this.openMap(this.stack);
                break;
            }
            case 91: {
                this.openList(this.stack);
                break;
            }
        }
    }

    public void nextOnContent(String string, String string2) {
    }

    public void nextOnProperty(String string, String string2) {
        if ("transfer".equals(string)) {
            if (this.getDeclaredClassname() == null && string2.startsWith("!")) {
                this.setDeclaredClassname(ReflectionUtil.transfer2classname(string2.substring(1), this.decoder.getConfig()));
            }
        } else if ("anchor".equals(string) && string2.startsWith("&")) {
            this.setAnchorname(string2.substring(1));
        }
    }

    public abstract void childCallback(Object var1);

    void clear() {
        this.setDeclaredClassname(null);
        this.setAnchorname(null);
    }

    Object createObject() {
        if (this.getClassname() == null) {
            return null;
        }
        try {
            if (this.decoder.getStManager().needsSpecialTreatment(this.getClassname())) {
                return this.decoder.getStManager().getHolder(this.getClassname());
            }
            return Class.forName(this.getClassname()).newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    void openMap(Stack<State> stack) {
        HashMap hashMap = this.createObject();
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        if (this.getAnchorname() != null) {
            this.markAnchor(hashMap, this.getAnchorname());
        }
        MapState mapState = new MapState(this.aliasMap, stack, this.decoder, this.logger);
        mapState.obj = hashMap;
        stack.push(mapState);
    }

    void openList(Stack<State> stack) {
        String string = stack.peek().getClassname();
        ArrayList arrayList = this.createObject();
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        if (this.getAnchorname() != null) {
            this.markAnchor(arrayList, this.getAnchorname());
        }
        ListState listState = new ListState(this.aliasMap, stack, this.decoder, this.logger);
        if (!(arrayList instanceof Collection)) {
            throw new YamlParserException(arrayList + " is not a Collection and so cannot be mapped from a sequence.");
        }
        listState.obj = arrayList;
        stack.push(listState);
        if (ReflectionUtil.isArrayName(string)) {
            stack.peek().setArrayComponentName(ReflectionUtil.arrayComponentName(string));
        }
    }

    void markAnchor(Object object, String string) {
        if (this.aliasMap.get(string) == null) {
            this.aliasMap.put(string, object);
        }
    }

    static Object decodeSimpleType(String string) {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            if (string.length() > 2) {
                return string.substring(1, string.length() - 1);
            }
            return "";
        }
        if ("~".equals(string)) {
            return null;
        }
        try {
            return new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return new Double(string);
            }
            catch (NumberFormatException numberFormatException2) {
                if ("true".equalsIgnoreCase(string) || "false".equalsIgnoreCase(string)) {
                    return new Boolean(string);
                }
                return string;
            }
        }
    }

    static Object convertType(Object object, Class clazz) {
        if ("~".equals(object)) {
            return null;
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return new Integer(object.toString());
        }
        if (clazz == String.class) {
            return (String)object;
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return new Long(object.toString());
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return new Double(object.toString());
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return new Boolean(object.toString());
        }
        if (clazz == BigDecimal.class) {
            return new BigDecimal((String)object);
        }
        if (clazz == BigInteger.class) {
            return new BigInteger((String)object);
        }
        if (clazz == File.class) {
            return new File((String)object);
        }
        if (clazz == Date.class) {
            String string = (String)object;
            try {
                return new Date(Long.parseLong(string));
            }
            catch (NumberFormatException numberFormatException) {
                return new Date(string);
            }
        }
        if (clazz.isEnum()) {
            try {
                return clazz.getMethod("valueOf", String.class).invoke((Object)clazz, object);
            }
            catch (Exception exception) {
                throw new YamlParserException("Problem getting " + object + " value of enum type " + clazz);
            }
        }
        return State.decodeSimpleType((String)object);
    }

    public Object getObj() {
        return this.obj;
    }

    public void setObj(Object object) {
        this.obj = object;
    }

    public String getClassname() {
        if (this.declaredClassname == null || ReflectionUtil.classForName(this.declaredClassname) == null) {
            return this.arrayComponentName;
        }
        return this.declaredClassname;
    }

    public String getDeclaredClassname() {
        return this.declaredClassname;
    }

    public void setDeclaredClassname(String string) {
        this.declaredClassname = string;
    }

    public String getAnchorname() {
        return this.anchorname;
    }

    public void setAnchorname(String string) {
        this.anchorname = string;
    }

    public String getArrayComponentName() {
        return this.arrayComponentName;
    }

    public void setArrayComponentName(String string) {
        this.arrayComponentName = string;
    }
}

