/*
 * Decompiled with CFR 0.152.
 */
package org.ho.yaml;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.ho.util.Logger;
import org.ho.yaml.NoneState;
import org.ho.yaml.ReflectionUtil;
import org.ho.yaml.State;
import org.ho.yaml.YamlDecoder;
import org.ho.yaml.YamlParserException;
import yaml.parser.YamlParserEvent;

class JYamlParserEvent
extends YamlParserEvent {
    Stack<State> stack = new Stack();
    Map<String, Object> aliasMap = new HashMap<String, Object>();

    public JYamlParserEvent(Logger logger, YamlDecoder yamlDecoder) {
        this.stack.push(new NoneState(this.aliasMap, this.stack, yamlDecoder, logger));
    }

    public JYamlParserEvent(Class clazz, Logger logger, YamlDecoder yamlDecoder) {
        this(logger, yamlDecoder);
        String string = ReflectionUtil.className(clazz);
        this.stack.peek().setDeclaredClassname(string);
        if (yamlDecoder.getStManager().needsSpecialTreatment(string)) {
            this.stack.peek().setObj(yamlDecoder.getStManager().getHolder(string));
        } else if (!clazz.isArray() && !ReflectionUtil.isSimpleType(clazz)) {
            try {
                this.stack.peek().setObj(clazz.newInstance());
            }
            catch (Exception exception) {
                throw new YamlParserException("Can't instantiate object of type " + clazz.getName());
            }
        }
    }

    public void content(String string, String string2) {
        this.stack.peek().nextOnContent(string, string2);
    }

    public void error(Exception exception, int n) {
        throw new YamlParserException("Error near line " + n + ": " + exception);
    }

    public void event(int n) {
        this.stack.peek().nextOnEvent(n);
    }

    public void property(String string, String string2) {
        this.stack.peek().nextOnProperty(string, string2);
    }

    public Object getBean() {
        return this.stack.peek().getObj();
    }
}

