/*
 * Decompiled with CFR 0.152.
 */
package org.nishiohirokazu.narVisualizer;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Hashtable;
import org.nishiohirokazu.awt.ColorHolder;
import org.nishiohirokazu.graph.RenderableEdge;
import org.nishiohirokazu.graph.RenderableVertex;
import org.nishiohirokazu.grinEdit.UtilCast;

public class TarminalEdge
extends RenderableEdge {
    private Color color;

    public TarminalEdge() {
        this.color = Color.BLACK;
    }

    public TarminalEdge(RenderableVertex v1, RenderableVertex v2) {
        super(v1, v2);
        this.color = Color.BLACK;
    }

    public TarminalEdge(RenderableVertex v1, RenderableVertex v2, int r, int g, int b) {
        super(v1, v2);
        this.color = ColorHolder.get(r, g, b);
    }

    public void render(Object target) {
        double[] p1 = this.v1.getTerminal(this.id);
        double[] p2 = this.v2.getTerminal(this.id);
        if (p1 == null || p2 == null) {
            return;
        }
        Graphics g = (Graphics)target;
        if (this.selected) {
            g.setColor(ColorHolder.SELECTED_EDGE);
        } else {
            g.setColor(this.color);
        }
        g.drawLine((int)p1[0], (int)p1[1], (int)p2[0], (int)p2[1]);
    }

    public void setColor(int r, int g, int b) {
        this.color = ColorHolder.get(r, g, b);
    }

    public void setColor(Object rgb) {
        this.color = UtilCast.o2awtColor(rgb);
    }

    public Hashtable getParams() {
        Hashtable result = super.getParams();
        result.put("color", UtilCast.Color2Vector(this.color));
        return result;
    }
}

