/*
 * Decompiled with CFR 0.152.
 */
package org.nishiohirokazu.graph;

import java.util.Hashtable;
import java.util.Set;
import org.nishiohirokazu.graph.IEdge;
import org.nishiohirokazu.graph.IGRINObject;
import org.nishiohirokazu.graph.IVertex;
import org.nishiohirokazu.graph.RenderableEdge;
import org.nishiohirokazu.graph.RenderableVertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graph {
    protected Hashtable namedDictionaries = new Hashtable();

    public Graph() {
        this.makeDict("All");
        this.makeDict("Vertex");
        this.makeDict("Edge");
        this.makeDict("Law");
    }

    public Hashtable<String, IVertex> getVertexDict() {
        return (Hashtable)this.namedDictionaries.get("Vertex");
    }

    public Hashtable<String, IEdge> getEdgeDict() {
        return (Hashtable)this.namedDictionaries.get("Edge");
    }

    public Hashtable<String, Object> getLawDict() {
        return (Hashtable)this.namedDictionaries.get("Law");
    }

    public void addVertex(RenderableVertex v, String name) {
        this.addObj("Vertex", name, v);
    }

    public void addEdge(RenderableEdge e, String name) {
        this.addObj("Edge", name, e);
    }

    public RenderableVertex getVertex(String value) {
        Hashtable vertexDict = (Hashtable)this.namedDictionaries.get("Vertex");
        RenderableVertex result = (RenderableVertex)vertexDict.get(value);
        assert (result != null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addObj(String dictName, String name, Object obj) {
        Hashtable dict;
        IGRINObject o = (IGRINObject)obj;
        o.setId(name);
        Hashtable hashtable = dict = (Hashtable)this.namedDictionaries.get(dictName);
        synchronized (hashtable) {
            dict.put(name, o);
        }
        hashtable = dict = (Hashtable)this.namedDictionaries.get("All");
        synchronized (hashtable) {
            dict.put(name, o);
        }
        return name;
    }

    public Hashtable makeDict(String dictName) {
        if (this.namedDictionaries.containsKey(dictName)) {
            throw new RuntimeException(String.valueOf(dictName) + "\u3068\u3044\u3046\u540d\u524d\u306e\u8f9e\u66f8\u306f\u3059\u3067\u306b\u5b58\u5728\u3057\u307e\u3059\u3002");
        }
        Hashtable result = new Hashtable();
        this.namedDictionaries.put(dictName, result);
        return result;
    }

    public Hashtable getNamedDict(String dictName) {
        Hashtable namedDict = (Hashtable)this.namedDictionaries.get(dictName);
        if (namedDict == null) {
            throw new RuntimeException(String.valueOf(dictName) + "\u3068\u3044\u3046\u540d\u524d\u306e\u8f9e\u66f8\u306f\u3042\u308a\u307e\u305b\u3093");
        }
        return namedDict;
    }

    public Set getDictNames() {
        return this.namedDictionaries.keySet();
    }
}

