/*
 * Decompiled with CFR 0.152.
 */
package org.nishiohirokazu.graph;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.program.Program;
import org.nishiohirokazu.graph.RenderableVertex;
import org.nishiohirokazu.grinEdit.Infrastructure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileIconVertex
extends RenderableVertex {
    private Image icon;
    private String extension;
    private int w;
    private int h;

    @Override
    public Hashtable<String, Object> getParams() {
        Hashtable<String, Object> result = super.getParams();
        result.put("extension", this.extension);
        return result;
    }

    public void setExtension(Object o) {
        this.extension = o.toString();
        this.updateIcon();
    }

    private void updateIcon() {
        Program program = Program.findProgram((String)this.extension);
        ImageData imageData = program.getImageData();
        int transparentColor = imageData.getPixel(0, 0);
        BufferedImage tmpImage = this.mask(this.toAwtImage(imageData), transparentColor);
        this.icon = tmpImage.getScaledInstance(this.w * 2, this.h * 2, 8);
    }

    BufferedImage toAwtImage(ImageData imageData) {
        BufferedImage result = null;
        ImageLoader il = new ImageLoader();
        il.data = new ImageData[]{imageData};
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        il.save((OutputStream)bos, 0);
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        try {
            result = ImageIO.read(bis);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    BufferedImage mask(BufferedImage org, int transparentColor) {
        this.w = org.getWidth();
        this.h = org.getHeight();
        BufferedImage dst = new BufferedImage(this.w, this.h, 2);
        int y = 0;
        while (y < this.h) {
            int x = 0;
            while (x < this.w) {
                if (x == 0) {
                    // empty if block
                }
                if (org.getRGB(x, y) % 0x1000000 == transparentColor) {
                    dst.setRGB(x, y, 0);
                } else {
                    dst.setRGB(x, y, org.getRGB(x, y));
                }
                ++x;
            }
            ++y;
        }
        return dst;
    }

    @Override
    public void render(Object target) {
        Graphics g = (Graphics)target;
        g.drawImage(this.icon, (int)this.screenPos[0] - this.w, (int)this.screenPos[1] - this.h, Infrastructure.canvas);
    }
}

