/*
 * Decompiled with CFR 0.152.
 */
package org.nishiohirokazu.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Hashtable;
import java.util.Vector;
import org.nishiohirokazu.awt.ColorHolder;
import org.nishiohirokazu.graph.RenderableVertex;
import org.nishiohirokazu.grinEdit.UtilCast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoxVertex
extends RenderableVertex {
    protected Point size;
    protected int margin = 3;
    protected Color bgcolor = ColorHolder.GRINGREEN;
    protected Point bound;
    protected Color frameColor = ColorHolder.BLACK;
    boolean hasSelflink;
    protected Color letterColor = ColorHolder.BLACK;
    public String label = "";

    public String getLabel() {
        return this.label;
    }

    public void setLabel(Object o) {
        this.label = o.toString();
        this.size = null;
    }

    public void setBgcolor(Object rgb) {
        this.bgcolor = UtilCast.o2awtColor(rgb);
    }

    public void setBackgroundColor(Object rgb) {
        System.out.println("Hello");
        this.bgcolor = UtilCast.o2awtColor(rgb);
    }

    public void setFrameColor(Object rgb) {
        this.frameColor = UtilCast.o2awtColor(rgb);
    }

    public void setLetterColor(Object rgb) {
        this.letterColor = UtilCast.o2awtColor(rgb);
    }

    public void setSelfLink(Object o) {
        this.hasSelflink = UtilCast.o2bool(o);
    }

    public void setBound(Object o) {
        this.bound = UtilCast.o2awtPoint(o);
    }

    @Override
    public Hashtable<String, Object> getParams() {
        Hashtable<String, Object> result = super.getParams();
        result.put("bgcolor", UtilCast.Color2Vector(this.bgcolor));
        result.put("frameColor", UtilCast.Color2Vector(this.frameColor));
        result.put("letterColor", UtilCast.Color2Vector(this.letterColor));
        result.put("selfLink", this.hasSelflink);
        Vector _bound = UtilCast.point2Vector(this.bound);
        if (_bound != null) {
            result.put("bound", _bound);
        }
        result.put("label", this.label);
        return result;
    }

    @Override
    public void render(Object target) {
        Graphics gc = (Graphics)target;
        if (this.size == null || this.bound == null) {
            if (this.label != "") {
                int x = gc.getFontMetrics().stringWidth(this.label);
                int y = gc.getFontMetrics().getHeight();
                this.size = new Point(x, y);
            } else {
                this.size = new Point(0, 0);
            }
            this.bound = new Point(this.size.x + this.margin * 2, this.size.y + this.margin * 2);
        }
        if (this.selected) {
            gc.setColor(ColorHolder.SELECTED_VERTEX);
        } else {
            gc.setColor(this.bgcolor);
        }
        int left = (int)(this.screenPos[0] - (double)(this.bound.x / 2));
        int top = (int)(this.screenPos[1] - (double)(this.bound.y / 2));
        int ascent = gc.getFontMetrics().getAscent();
        gc.fillRect(left, top, this.bound.x, this.bound.y);
        gc.setColor(this.frameColor);
        gc.drawRect(left, top, this.bound.x, this.bound.y);
        gc.setColor(this.letterColor);
        gc.drawString(this.label, left + this.margin, top + this.margin + ascent);
    }

    @Override
    public double calcOffset(double[] ndir) {
        Point b = this.bound;
        double offset = b == null || b.x == 0 || b.y == 0 ? 0.0 : (Math.abs((double)b.x * ndir[1]) < Math.abs((double)b.y * ndir[0]) ? Math.abs((double)b.x / ndir[0] / 2.0) : Math.abs((double)b.y / ndir[1] / 2.0));
        return offset;
    }

    public String toString() {
        if (this.label != "") {
            return this.label;
        }
        return super.toString();
    }
}

