/*
 * Decompiled with CFR 0.152.
 */
package com.sdicons.json.serializer.helper.impl;

import com.sdicons.json.model.JSONArray;
import com.sdicons.json.model.JSONObject;
import com.sdicons.json.model.JSONString;
import com.sdicons.json.model.JSONValue;
import com.sdicons.json.serializer.helper.Helper;
import com.sdicons.json.serializer.marshall.JSONMarshall;
import com.sdicons.json.serializer.marshall.MarshallException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class ArrayHelper
implements Helper {
    public void renderValue(Object aObj, JSONObject aObjectElement, JSONMarshall aMarshall, HashMap aPool) throws MarshallException {
        block12: {
            JSONArray lElements;
            block10: {
                int i;
                Object[] lArr;
                String lComponentName;
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                block13: {
                                    block11: {
                                        JSONMarshall.requireStringAttribute(aObjectElement, "c");
                                        JSONString lComponentAttr = (JSONString)aObjectElement.get("c");
                                        lComponentName = lComponentAttr.getValue();
                                        lElements = new JSONArray();
                                        aObjectElement.getValue().put("=", lElements);
                                        if (!this.isPrimitiveArray(lComponentName)) break block10;
                                        if ("I".equals(lComponentName)) {
                                            lArr = (int[])aObj;
                                            for (i = 0; i < lArr.length; ++i) {
                                                lElements.getValue().add(aMarshall.marshall(lArr[i]));
                                            }
                                        }
                                        if (!"C".equals(lComponentName)) break block11;
                                        lArr = (char[])aObj;
                                        for (i = 0; i < lArr.length; ++i) {
                                            lElements.getValue().add(aMarshall.marshall(lArr[i]));
                                        }
                                        break block12;
                                    }
                                    if (!"Z".equals(lComponentName)) break block13;
                                    lArr = (boolean[])aObj;
                                    for (i = 0; i < lArr.length; ++i) {
                                        lElements.getValue().add(aMarshall.marshall(lArr[i]));
                                    }
                                    break block12;
                                }
                                if (!"S".equals(lComponentName)) break block14;
                                lArr = (short[])aObj;
                                for (i = 0; i < lArr.length; ++i) {
                                    lElements.getValue().add(aMarshall.marshall(lArr[i]));
                                }
                                break block12;
                            }
                            if (!"B".equals(lComponentName)) break block15;
                            lArr = (byte[])aObj;
                            for (i = 0; i < lArr.length; ++i) {
                                lElements.getValue().add(aMarshall.marshall(lArr[i]));
                            }
                            break block12;
                        }
                        if (!"J".equals(lComponentName)) break block16;
                        lArr = (long[])aObj;
                        for (i = 0; i < lArr.length; ++i) {
                            lElements.getValue().add(aMarshall.marshall((long)lArr[i]));
                        }
                        break block12;
                    }
                    if (!"F".equals(lComponentName)) break block17;
                    lArr = (float[])aObj;
                    for (i = 0; i < lArr.length; ++i) {
                        lElements.getValue().add(aMarshall.marshall((float)lArr[i]));
                    }
                    break block12;
                }
                if (!"D".equals(lComponentName)) break block12;
                lArr = (double[])aObj;
                for (i = 0; i < lArr.length; ++i) {
                    lElements.getValue().add(aMarshall.marshall((double)lArr[i]));
                }
                break block12;
            }
            for (Object lArrEl : Arrays.asList((Object[])aObj)) {
                lElements.getValue().add(aMarshall.marshallImpl(lArrEl, aPool));
            }
        }
    }

    public Object parseValue(JSONObject aObjectElement, JSONMarshall aMarshall, HashMap aPool) throws MarshallException {
        String lId = null;
        try {
            JSONMarshall.requireStringAttribute(aObjectElement, "&");
            lId = ((JSONString)aObjectElement.get("&")).getValue();
        }
        catch (Exception eIgnore) {
            // empty catch block
        }
        JSONMarshall.requireStringAttribute(aObjectElement, "c");
        String lArrClassName = ((JSONString)aObjectElement.get("c")).getValue();
        JSONArray lValues = (JSONArray)aObjectElement.get("=");
        LinkedList<Object> lElements = new LinkedList<Object>();
        for (JSONValue jsonValue : lValues.getValue()) {
            lElements.add(aMarshall.unmarshallImpl((JSONObject)jsonValue, aPool));
        }
        int lArrSize = lElements.size();
        if (this.isPrimitiveArray(lArrClassName)) {
            Object[] lArr;
            if ("I".equals(lArrClassName)) {
                lArr = new int[lArrSize];
                Iterator lIter = lElements.iterator();
                int i = 0;
                while (lIter.hasNext()) {
                    lArr[i] = (Integer)lIter.next();
                    ++i;
                }
                if (lId != null) {
                    aPool.put(lId, lArr);
                }
                return lArr;
            }
            if ("C".equals(lArrClassName)) {
                lArr = new char[lArrSize];
                Iterator lIter = lElements.iterator();
                int i = 0;
                while (lIter.hasNext()) {
                    lArr[i] = ((Character)lIter.next()).charValue();
                    ++i;
                }
                if (lId != null) {
                    aPool.put(lId, lArr);
                }
                return lArr;
            }
            if ("Z".equals(lArrClassName)) {
                lArr = new boolean[lArrSize];
                Iterator lIter = lElements.iterator();
                int i = 0;
                while (lIter.hasNext()) {
                    lArr[i] = ((Boolean)lIter.next()).booleanValue() ? 1 : 0;
                    ++i;
                }
                if (lId != null) {
                    aPool.put(lId, lArr);
                }
                return lArr;
            }
            if ("S".equals(lArrClassName)) {
                lArr = new short[lArrSize];
                Iterator lIter = lElements.iterator();
                int i = 0;
                while (lIter.hasNext()) {
                    lArr[i] = ((Short)lIter.next()).shortValue();
                    ++i;
                }
                if (lId != null) {
                    aPool.put(lId, lArr);
                }
                return lArr;
            }
            if ("B".equals(lArrClassName)) {
                lArr = new byte[lArrSize];
                Iterator lIter = lElements.iterator();
                int i = 0;
                while (lIter.hasNext()) {
                    lArr[i] = ((Byte)lIter.next()).byteValue();
                    ++i;
                }
                if (lId != null) {
                    aPool.put(lId, lArr);
                }
                return lArr;
            }
            if ("J".equals(lArrClassName)) {
                lArr = new long[lArrSize];
                Iterator lIter = lElements.iterator();
                int i = 0;
                while (lIter.hasNext()) {
                    lArr[i] = (int)((Long)lIter.next()).longValue();
                    ++i;
                }
                if (lId != null) {
                    aPool.put(lId, lArr);
                }
                return lArr;
            }
            if ("F".equals(lArrClassName)) {
                lArr = new float[lArrSize];
                Iterator lIter = lElements.iterator();
                int i = 0;
                while (lIter.hasNext()) {
                    lArr[i] = (int)((Float)lIter.next()).floatValue();
                    ++i;
                }
                if (lId != null) {
                    aPool.put(lId, lArr);
                }
                return lArr;
            }
            if ("D".equals(lArrClassName)) {
                lArr = new double[lArrSize];
                Iterator lIter = lElements.iterator();
                int i = 0;
                while (lIter.hasNext()) {
                    lArr[i] = (int)((Double)lIter.next()).doubleValue();
                    ++i;
                }
                if (lId != null) {
                    aPool.put(lId, lArr);
                }
                return lArr;
            }
            String lMsg = "Unknown primitive array type: " + lArrClassName;
            throw new MarshallException(lMsg);
        }
        try {
            Class<?> lComponentClass = Class.forName(lArrClassName);
            Object lArr = Array.newInstance(lComponentClass, lArrSize);
            Iterator lIter = lElements.iterator();
            int i = 0;
            while (lIter.hasNext()) {
                Array.set(lArr, i, lIter.next());
                ++i;
            }
            if (lId != null) {
                aPool.put(lId, lArr);
            }
            return lArr;
        }
        catch (ClassNotFoundException e) {
            String lMsg = "Exception while trying to unmarshall an array of JavaObjects: " + lArrClassName;
            throw new MarshallException(lMsg);
        }
    }

    public Class getHelpedClass() {
        return null;
    }

    private boolean isPrimitiveArray(String aClassName) {
        return "I".equals(aClassName) || "Z".equals(aClassName) || "S".equals(aClassName) || "B".equals(aClassName) || "J".equals(aClassName) || "F".equals(aClassName) || "D".equals(aClassName) || "C".equals(aClassName);
    }
}

