/*
 * Decompiled with CFR 0.152.
 */
package com.sdicons.json.serializer.helper;

import com.sdicons.json.model.JSONObject;
import com.sdicons.json.serializer.helper.Helper;
import com.sdicons.json.serializer.marshall.JSONMarshall;
import com.sdicons.json.serializer.marshall.MarshallException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class HelperRepository {
    private HelperTreeNode root = new HelperTreeNode(new RootHelper());

    public void addHelper(Helper aHelper) {
        this.root.insertNode(new HelperTreeNode(aHelper));
    }

    public Helper findHelper(Class aClass) {
        return this.root.findHelper(aClass);
    }

    private class RootHelper
    implements Helper {
        private RootHelper() {
        }

        public void renderValue(Object aObj, JSONObject aObjectElement, JSONMarshall aMarshall, HashMap aPool) throws MarshallException {
        }

        public Object parseValue(JSONObject aObjectElement, JSONMarshall aMarshall, HashMap aPool) throws MarshallException {
            throw new MarshallException("Not implemented.");
        }

        public Class getHelpedClass() {
            return Object.class;
        }
    }

    private static class HelperTreeNode {
        private Helper helper;
        private List<HelperTreeNode> children;

        public HelperTreeNode(Helper aClass) {
            this.helper = aClass;
            this.children = new LinkedList<HelperTreeNode>();
        }

        public Helper getHelper() {
            return this.helper;
        }

        public boolean insertNode(HelperTreeNode aNode) {
            if (aNode.getHelper().getHelpedClass() == this.helper.getHelpedClass()) {
                this.helper = aNode.getHelper();
                return true;
            }
            if (this.helper.getHelpedClass().isAssignableFrom(aNode.getHelper().getHelpedClass())) {
                boolean insertedToSomeChild = false;
                for (HelperTreeNode aChildren : this.children) {
                    HelperTreeNode lChild = aChildren;
                    boolean lSuccess = lChild.insertNode(aNode);
                    if (!lSuccess) continue;
                    insertedToSomeChild = true;
                    break;
                }
                if (!insertedToSomeChild) {
                    Iterator<HelperTreeNode> lIter2 = this.children.iterator();
                    while (lIter2.hasNext()) {
                        HelperTreeNode lChild = lIter2.next();
                        if (!aNode.getHelper().getHelpedClass().isAssignableFrom(lChild.getHelper().getHelpedClass())) continue;
                        lIter2.remove();
                        aNode.insertNode(lChild);
                    }
                    this.children.add(aNode);
                }
                return true;
            }
            return false;
        }

        Helper findHelper(Class aClass) {
            if (this.helper.getHelpedClass() == aClass) {
                return this.helper;
            }
            for (HelperTreeNode lChildNode : this.children) {
                Helper lHelper = lChildNode.findHelper(aClass);
                if (lHelper == null) continue;
                return lHelper;
            }
            if (this.helper.getHelpedClass().isAssignableFrom(aClass)) {
                return this.helper;
            }
            return null;
        }
    }
}

