/*
 * Decompiled with CFR 0.152.
 */
package org.ho.yaml;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.ho.util.Logger;
import org.ho.yaml.ListState;
import org.ho.yaml.ReflectionUtil;
import org.ho.yaml.State;
import org.ho.yaml.YamlDecoder;
import org.ho.yaml.YamlParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MapState
extends State {
    String key;

    MapState(Map<String, Object> map, Stack<State> stack, YamlDecoder yamlDecoder, Logger logger) {
        super(map, stack, yamlDecoder, logger);
    }

    @Override
    public void nextOnContent(String string, String string2) {
        if (this.key == null) {
            this.key = string2;
        } else {
            Object object;
            Object object2 = null;
            if ("alias".equals(string)) {
                object = string2.substring(1);
                object2 = this.aliasMap.get(object);
            }
            if (this.decoder.getStManager().needsSpecialTreatment(this.obj)) {
                object = this.decoder.getStManager().getPropertyType(this.obj, this.key);
                this.decoder.getStManager().setProperty(this.obj, this.key, MapState.convertType(string2, (Class)object));
            } else if (this.getObj() instanceof Map) {
                if (object2 == null) {
                    object2 = MapState.decodeSimpleType(string2);
                }
                ((Map)this.getObj()).put(MapState.decodeSimpleType(this.key), object2);
            } else if (ReflectionUtil.hasProperty(this.obj, this.key)) {
                if (object2 == null) {
                    object2 = this.setProperty(this.obj, this.key, string2);
                } else {
                    ReflectionUtil.setProperty(this.obj, this.key, object2);
                }
            } else {
                try {
                    object = this.obj.getClass().getField(this.key);
                    if (object != null && ReflectionUtil.isPublicMemberField((Field)object)) {
                        if (object2 == null) {
                            object2 = MapState.convertType(string2, ((Field)object).getType());
                        }
                        ((Field)object).set(this.obj, object2);
                    }
                }
                catch (Exception exception) {
                    this.logger.warn("Can't set " + this.key + " field on " + this.obj + " with value " + object2 + "\n" + exception);
                }
            }
            if (this.getAnchorname() != null) {
                this.markAnchor(object2, this.getAnchorname());
            }
            this.clear();
            this.key = null;
        }
    }

    @Override
    Object createObject() {
        Object object = super.createObject();
        if (object != null) {
            return object;
        }
        if (!(this.obj instanceof Map)) {
            Class<?> clazz = null;
            if (this.decoder.getStManager().needsSpecialTreatment(this.obj)) {
                clazz = this.decoder.getStManager().getPropertyType(this.obj, this.key);
            } else if (ReflectionUtil.hasProperty(this.obj, this.key)) {
                clazz = ReflectionUtil.getPropertyDescriptor(this.obj, this.key).getPropertyType();
            } else {
                try {
                    Field field = this.obj.getClass().getField(this.key);
                    clazz = field.getType();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (clazz != null) {
                try {
                    return clazz.newInstance();
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }
        return null;
    }

    @Override
    public void nextOnEvent(int n) {
        switch (n) {
            case 58: {
                break;
            }
            case 125: {
                this.stack.pop();
                if (this.decoder.getStManager().needsSpecialTreatment(this.obj)) {
                    this.obj = this.decoder.getStManager().getRealObject(this.obj);
                }
                ((State)this.stack.peek()).childCallback(this.obj);
                break;
            }
            default: {
                super.nextOnEvent(n);
            }
        }
    }

    Collection createCollectionObjectFromExpectedType(Class clazz) {
        if (clazz.isArray()) {
            this.setDeclaredClassname(clazz.getComponentType().getName() + "[]");
            return new ArrayList();
        }
        if (clazz.isInterface()) {
            if (clazz == Set.class) {
                return new HashSet();
            }
            if (clazz == List.class) {
                return new Vector();
            }
            if (clazz == Queue.class) {
                return new LinkedList();
            }
            throw new YamlParserException("Unsupported collection type " + clazz.getCanonicalName());
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            try {
                return (Collection)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new YamlParserException("Can't instantiate type " + clazz.getCanonicalName());
            }
        }
        throw new YamlParserException("Expecting a Collection type, got " + clazz.getCanonicalName());
    }

    @Override
    void openList(Stack<State> stack) {
        Object object;
        Collection collection = this.createObject();
        Class<?> clazz = null;
        String string = null;
        if (collection == null) {
            if (ReflectionUtil.isArrayName(this.getClassname())) {
                collection = new ArrayList();
                string = ReflectionUtil.arrayComponentName(this.getClassname());
            } else if (this.getObj() instanceof Map) {
                collection = new ArrayList();
            } else {
                object = ReflectionUtil.getPropertyDescriptor(this.getObj(), this.key);
                if (object != null) {
                    clazz = ((PropertyDescriptor)object).getPropertyType();
                    collection = this.createCollectionObjectFromExpectedType(clazz);
                } else {
                    try {
                        clazz = this.getObj().getClass().getField(this.key).getType();
                        collection = this.createCollectionObjectFromExpectedType(clazz);
                    }
                    catch (Exception exception) {
                        this.logger.info("Can't read from field or property " + this.key + " on " + this.getObj() + ".");
                        collection = new ArrayList();
                    }
                }
            }
        }
        if (this.getAnchorname() != null) {
            this.markAnchor(collection, this.getAnchorname());
        }
        object = new ListState(this.aliasMap, stack, this.decoder, this.logger);
        if (!(collection instanceof Collection)) {
            throw new YamlParserException(collection + " is not a Collection and so cannot be mapped from a sequence.");
        }
        ((State)object).obj = collection;
        if (string != null || clazz != null && clazz.isArray()) {
            ((State)object).setArrayComponentName(string == null ? ReflectionUtil.className(clazz.getComponentType()) : string);
        }
        stack.push((State)object);
    }

    @Override
    public void childCallback(Object object) {
        if (this.decoder.getStManager().needsSpecialTreatment(this.obj)) {
            this.decoder.getStManager().setProperty(this.obj, this.key, object);
        } else if (this.obj instanceof Map) {
            ((Map)this.obj).put(this.key, object);
        } else if (ReflectionUtil.hasProperty(this.obj, this.key)) {
            ReflectionUtil.setProperty(this.obj, this.key, object);
        } else {
            try {
                this.obj.getClass().getField(this.key).set(this.obj, object);
            }
            catch (Exception exception) {
                this.logger.warn("Can't set " + this.key + " field on " + this.obj + " with value " + object + "\n" + exception);
            }
        }
        this.clear();
        this.key = null;
    }

    Object setProperty(Object object, String string, Object object2) {
        PropertyDescriptor propertyDescriptor = ReflectionUtil.getPropertyDescriptor(object, string);
        try {
            Object object3 = MapState.convertType(object2, propertyDescriptor.getPropertyType());
            propertyDescriptor.getWriteMethod().invoke(object, object3);
            return object3;
        }
        catch (Exception exception) {
            this.logger.warn("Can't set " + string + " property on " + object + " with value " + object2 + "\n" + exception);
            return null;
        }
    }
}

