/*
 * Decompiled with CFR 0.152.
 */
package org.nishiohirokazu.swt;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Canvas;
import org.nishiohirokazu.swt.IDrawable;
import org.nishiohirokazu.swt.ResizeListener;

public class DoubleBufferer
implements IDrawable {
    private Image bgImage;
    protected GC gc;
    protected GC bg;
    int width;
    int height;
    public Canvas canvas;

    public DoubleBufferer(Canvas canvas) {
        this.setCanvas(canvas);
    }

    public void setCanvas(Canvas canvas) {
        this.canvas = canvas;
        canvas.addControlListener((ControlListener)new ResizeListener(this));
        this.gc = new GC((Drawable)canvas);
    }

    public void initBackgroundImage() {
        if (this.canvas.getClientArea().width != 0) {
            this.bgImage = new Image((Device)this.canvas.getDisplay(), this.canvas.getClientArea());
            this.bg = new GC((Drawable)this.bgImage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw() {
        if (this.bgImage == null) {
            this.initBackgroundImage();
        }
        GC gC = this.gc;
        synchronized (gC) {
            this.gc.drawImage(this.bgImage, 0, 0);
        }
    }

    public void drawOnBackground() {
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.bgImage.dispose();
        this.gc.dispose();
        this.bg.dispose();
    }

    public GC getBG() {
        return this.bg;
    }

    public GC getGC() {
        return this.gc;
    }

    public void clearBG() {
        this.bg.setForeground(new Color(null, 255, 255, 255));
        this.bg.fillRectangle(this.bgImage.getBounds());
        this.bg.setForeground(new Color(null, 0, 0, 0));
    }

    public void saveImage(String filename) {
        ImageLoader il = new ImageLoader();
        il.data = new ImageData[]{this.bgImage.getImageData()};
        il.save(filename, 0);
    }
}

