/*
 * Decompiled with CFR 0.152.
 */
package org.nishiohirokazu.layout;

import java.util.Hashtable;
import java.util.Map;
import org.nishiohirokazu.graph.IEdge;
import org.nishiohirokazu.graph.IVertex;
import org.nishiohirokazu.grinEdit.Mediator;
import org.nishiohirokazu.grinEdit.UtilCast;
import org.nishiohirokazu.layout.IMassPoint;
import org.nishiohirokazu.layout.PhysicalLaw;
import org.nishiohirokazu.vector.Vec;

public class PL_Flow
extends PhysicalLaw {
    private double kx = 0.01;
    private double ky1 = 0.3;
    private double ky2 = 0.1;
    private double length = 3.0;
    private Map<IEdge, Double> normalLength = new Hashtable<IEdge, Double>();
    private Map<IEdge, Double> springStrength = new Hashtable<IEdge, Double>();
    private String targetName;

    public PL_Flow() {
        this.targetName = "Edge";
    }

    public PL_Flow(String targetName) {
        this.targetName = targetName;
    }

    public boolean apply(int iter) {
        Hashtable target = Mediator.getInstance().getNamedDict(this.targetName);
        if (iter == 0) {
            for (IEdge e : target.values()) {
                IVertex v1 = e.getV1();
                IVertex v2 = e.getV2();
                if (v1 == null || v2 == null) continue;
                IMassPoint mv1 = (IMassPoint)((Object)v1);
                IMassPoint mv2 = (IMassPoint)((Object)v2);
                double[] dir = Vec.sub(mv2.getPosition(), mv1.getPosition());
                double fx = this.calcFx(dir[0]);
                double fy = this.calcFy(dir[1]);
                double[] force = new double[]{fx, fy};
                mv1.getDVelList().add(force);
                mv2.getDVelList().add(Vec.inv(force));
            }
        }
        return true;
    }

    private double calcFy(double d) {
        if (d > this.length) {
            return (d - this.length) * this.ky1;
        }
        return (d - this.length) * this.ky2;
    }

    private double calcFx(double d) {
        return this.kx * d;
    }

    public void setKx(Object o) {
        this.kx = UtilCast.o2double(o);
    }

    public void setKy1(Object o) {
        this.ky1 = UtilCast.o2double(o);
    }

    public void setKy2(Object o) {
        this.ky2 = UtilCast.o2double(o);
    }

    public Hashtable getParams() {
        Hashtable result = super.getParams();
        result.put("kx", this.kx);
        result.put("ky1", this.ky1);
        result.put("ky2", this.ky2);
        return result;
    }

    public void setTargetName(Object o) {
        this.targetName = o.toString();
    }

    public void putNormalLength(String name, Object value) {
        this.normalLength.put((IEdge)Mediator.getInstance().getObject(name), UtilCast.o2double(value));
    }

    public void putNormalLength(IEdge o, Object value) {
        this.normalLength.put(o, UtilCast.o2double(value));
    }

    public void removeNormalLength(String name) {
        this.normalLength.remove(Mediator.getInstance().getObject(name));
    }

    public void setNormalLength(Object o) {
        this.normalLength = new Hashtable<IEdge, Double>();
        Map map = UtilCast.maplike2map(o);
        Mediator med = Mediator.getInstance();
        for (Object key : map.keySet()) {
            this.normalLength.put(med.getEdge(key.toString()), UtilCast.o2double(map.get(key)));
        }
    }

    public void putSpringStrength(String name, Object value) {
        this.springStrength.put((IEdge)Mediator.getInstance().getObject(name), UtilCast.o2double(value));
    }

    public void putSpringStrength(IEdge o, Object value) {
        this.springStrength.put(o, UtilCast.o2double(value));
    }

    public void removeSpringStrength(String name) {
        this.springStrength.remove(Mediator.getInstance().getObject(name));
    }

    public void setSpringStrength(Object o) {
        this.springStrength = new Hashtable<IEdge, Double>();
        Map map = UtilCast.maplike2map(o);
        Mediator med = Mediator.getInstance();
        for (Object key : map.keySet()) {
            this.springStrength.put(med.getEdge(key.toString()), UtilCast.o2double(map.get(key)));
        }
    }
}

