/*
 * Decompiled with CFR 0.152.
 */
package org.nishiohirokazu.grinEdit.mouseOperation;

import java.util.HashMap;
import java.util.Map;
import org.nishiohirokazu.graph.Graph;
import org.nishiohirokazu.graph.RenderableVertex;
import org.nishiohirokazu.grinEdit.Infrastructure;
import org.nishiohirokazu.grinEdit.Mediator;
import org.nishiohirokazu.grinEdit.mouseOperation.MouseOperation;
import org.nishiohirokazu.grinEdit.mouseOperation.UtilMetaKey;
import org.nishiohirokazu.layout.PL_Anchor;
import org.nishiohirokazu.swt.ViewportTransformer;

public class MO_MoveVertex
extends MouseOperation {
    private RenderableVertex target;

    public String getName() {
        return "Move vertex";
    }

    public Map getDesc() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("ja", "\u30c9\u30e9\u30c3\u30b0\u3067\u9802\u70b9\u3092\u3064\u304b\u3093\u3067\u79fb\u52d5\u3059\u308b\u3002\u96e2\u3059\u3068\u304d\u306b\u30b7\u30d5\u30c8\u30ad\u30fc\u304c\u62bc\u3055\u308c\u3066\u3044\u306a\u3051\u308c\u3070\u305d\u306e\u5834\u306b\u56fa\u5b9a\u3059\u308b\u3002");
        result.put("en", "To move vertex by drag.Releasing mouse button without shift-key, the vertex is anchored.");
        return result;
    }

    private void setAnchor() {
        Graph g = this.med.getGraph();
        PL_Anchor a = (PL_Anchor)g.getLawDict().get("PL_Anchor");
        a.putTarget(this.target.getId(), this.target.getPosition().clone());
    }

    private void removeAnchor() {
        Graph g = this.med.getGraph();
        PL_Anchor a = (PL_Anchor)g.getLawDict().get("PL_Anchor");
        a.removeTarget(this.target.getId());
    }

    public void mouseDown(int x, int y, int mask) {
        int RADIUS = 20;
        int SQ_RADIUS = RADIUS * RADIUS;
        this.med = Mediator.getInstance();
        this.target = (RenderableVertex)this.med.getNearestVertex(x, y, SQ_RADIUS);
        if (this.target != null) {
            this.setAnchor();
            this.mouseMove(x, y, mask);
        }
    }

    public void mouseMove(int x, int y, int mask) {
        ViewportTransformer vp = Infrastructure.getViewportTransformer();
        if (this.target != null) {
            double[] screenPos = new double[]{x, y};
            double[] anchorPos = vp.invViewportTransform(screenPos);
            this.target.setPosition(anchorPos);
            this.setAnchor();
        }
    }

    public void mouseUp(int x, int y, int mask) {
        UtilMetaKey.setMask(mask);
        if (this.target != null) {
            if (UtilMetaKey.ctrl) {
                this.removeAnchor();
            } else if (UtilMetaKey.shift) {
                this.removeAnchor();
            }
        }
        this.target = null;
    }
}

