/*
 * Decompiled with CFR 0.152.
 */
package org.nishiohirokazu.grinEdit;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.nishiohirokazu.graph.DefaultGraph;
import org.nishiohirokazu.grinEdit.Infrastructure;
import org.nishiohirokazu.grinEdit.Mediator;
import org.nishiohirokazu.grinEdit.UtilCast;
import org.nishiohirokazu.grinEdit.UtilUniqName;
import org.nishiohirokazu.grinEdit.UtilXMLRPC;

public class CommonGateway {
    private Mediator med = Mediator.getInstance();
    private Method[] methods = this.getClass().getDeclaredMethods();

    public static CommonGateway getInstance() {
        return new CommonGateway();
    }

    private CommonGateway() {
    }

    public String addEdge(String edgeType, Hashtable params) throws Throwable {
        return this.addObject("Edge", edgeType, params);
    }

    public String addEdge(String edgeType, Object params) throws Throwable {
        return this.addObject("Edge", edgeType, params);
    }

    public String addLaw(String className, Hashtable params) throws Throwable {
        return this.addObject("Law", className, params);
    }

    public String addLaw(String className, Object params) throws Throwable {
        return this.addObject("Law", className, params);
    }

    public String addVertex(String vertexType, Hashtable params) throws Throwable {
        return this.addObject("Vertex", vertexType, params);
    }

    public String addVertex(String vertexType, Object params) throws Throwable {
        return this.addObject("Vertex", vertexType, params);
    }

    public String addObject(String namespace, String typename, Hashtable params) throws Throwable {
        return this.addObject(namespace, typename, (Object)params);
    }

    public String addObject(String namespace, String typename, Object params) throws Throwable {
        Object v;
        Map _params = UtilCast.maplike2map(params);
        String id = _params.containsKey("id") ? _params.get("id").toString() : UtilUniqName.getUniqName(namespace.toLowerCase());
        try {
            v = UtilXMLRPC.makeObjForName(typename, _params, id);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        this.med.graph.addObj(namespace, id, v);
        return id;
    }

    public boolean autoLayout(boolean b) {
        boolean result = this.med.autoLayout;
        this.med.autoLayout = b;
        return result;
    }

    public Object batch(Vector v) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Vector<Object> result = new Vector<Object>(v.size());
        block0: for (Hashtable q : v) {
            String methodName = (String)q.get("method");
            Object[] params = ((Vector)q.get("params")).toArray();
            int j = 0;
            while (j < this.methods.length) {
                Method m = this.methods[j];
                if (methodName.equals(m.getName())) {
                    result.add(m.invoke((Object)this, params));
                    continue block0;
                }
                ++j;
            }
        }
        return result;
    }

    public void delObject(String frmNamespace, String name) {
        Hashtable namespace = this.med.getNamedDict(frmNamespace);
        if (namespace == null) {
            throw new RuntimeException(String.valueOf(frmNamespace) + "\u3068\u3044\u3046\u540d\u524d\u306e\u540d\u524d\u7a7a\u9593\u306f\u3042\u308a\u307e\u305b\u3093");
        }
        namespace.remove(name);
    }

    public String delEdge(String name) {
        this.delObject("Edge", name);
        return name;
    }

    public String delLaw(String name) {
        this.delObject("Law", name);
        return name;
    }

    public String delVertex(String name) {
        this.delObject("Vertex", name);
        return name;
    }

    public Object getObjects(String dictName) throws IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchMethodException {
        Hashtable dict = this.med.getNamedDict(dictName);
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        for (String name : dict.keySet()) {
            result.put(name, UtilXMLRPC.getParams(dict.get(name)));
        }
        return result;
    }

    public Object getParams(String dictName, String name) throws IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchMethodException {
        Hashtable dict = this.med.getNamedDict(dictName);
        return UtilXMLRPC.getParams(dict.get(name));
    }

    public Object getEdge(String name) throws IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchMethodException {
        return this.getParams("Edge", name);
    }

    public Object getLaw(String name) throws IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchMethodException {
        return this.getParams("Law", name);
    }

    public Object getVertex(String name) throws IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchMethodException {
        return this.getParams("Vertex", name);
    }

    public int initGraph() {
        this.med.graph = new DefaultGraph();
        return 0;
    }

    public Object modObject(String namespace, String name, Object params) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Hashtable _namespace = this.med.getNamedDict(namespace);
        Object target = _namespace.get(name);
        if (target == null) {
            throw new RuntimeException(String.valueOf(namespace) + " named '" + name + "' doesn't exist");
        }
        UtilXMLRPC.modParams(target, UtilCast.maplike2map(params));
        return UtilXMLRPC.getParams(target);
    }

    public Object modEdge(String name, Hashtable params) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.modObject("Edge", name, params);
    }

    public Object modLaw(String name, Hashtable params) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.modObject("Law", name, params);
    }

    public Object modVertex(String name, Hashtable params) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.modObject("Vertex", name, params);
    }

    public void addHandler(String name, String classname, Hashtable params) throws SecurityException, IllegalArgumentException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Infrastructure.server.addHandler(name, UtilXMLRPC.makeObjForName(classname, params));
    }

    public void removeHandler(String name) throws SecurityException, IllegalArgumentException {
        Infrastructure.server.removeHandler(name);
    }

    public boolean pause(boolean b) {
        boolean result = this.med.pause;
        this.med.pause = b;
        return result;
    }

    public boolean rendering(boolean b) {
        boolean result = this.med.rendering;
        this.med.rendering = b;
        return result;
    }

    public void makeDict(String dictName) {
        this.med.graph.makeDict(dictName);
    }

    public void addObject(String dictName, String objName) {
        Object obj = this.med.getObject(objName);
        this.med.graph.addObj(dictName, objName, obj);
    }

    public void copyTable(String srcName, String newName) {
        Hashtable srcDict = this.med.getNamedDict(srcName);
        Hashtable newDict = new Hashtable();
        for (Object key : srcDict.keySet()) {
            newDict.put(key, srcDict.get(key));
        }
    }

    public String addBoxVertex(String label) throws Throwable {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("label", label);
        String result = this.addVertex("BoxVertex", params);
        return result;
    }

    public String addLinearEdge(String v1, String v2) throws Throwable {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("v1", v1);
        params.put("v2", v2);
        String result = this.addEdge("LinearEdge", params);
        return result;
    }
}

