/*
 * Decompiled with CFR 0.152.
 */
package org.nishiohirokazu.graph;

import java.util.Hashtable;
import org.nishiohirokazu.graph.Graph;
import org.nishiohirokazu.graph.IHasScreenPos;
import org.nishiohirokazu.graph.IRenderable;
import org.nishiohirokazu.graph.RenderableEdge;
import org.nishiohirokazu.grinEdit.IHasProperty;
import org.nishiohirokazu.grinEdit.Mediator;
import org.nishiohirokazu.layout.MassPoint;
import org.nishiohirokazu.layout.PL_Anchor;
import org.nishiohirokazu.narVisualizer.IHasTerminal;
import org.nishiohirokazu.vector.Vec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderableVertex
extends MassPoint
implements IHasProperty,
IRenderable,
IHasTerminal,
IHasScreenPos {
    public boolean selected;
    protected double[] screenPos;
    public Hashtable properties = new Hashtable();

    public RenderableVertex() {
        double[] position = new double[]{Math.random() - 0.5, Math.random() - 0.5};
        this.setPosition(position);
    }

    @Override
    public Hashtable<String, Object> getParams() {
        Hashtable result = super.getParams();
        result.put("id", this.getId());
        return result;
    }

    public void setAnchored(Object value) {
        Graph g = Mediator.getInstance().getGraph();
        PL_Anchor a = (PL_Anchor)g.getLawDict().get("PL_Anchor");
        a.putTarget(this, value);
    }

    public void setDisanchored() {
        Graph g = Mediator.getInstance().getGraph();
        PL_Anchor a = (PL_Anchor)g.getLawDict().get("PL_Anchor");
        a.removeTarget(this.getId());
    }

    public void setDisanchored(Object value) {
        this.setDisanchored();
    }

    @Override
    public void render(Object target) {
    }

    public double calcOffset(double[] ndir) {
        return 0.0;
    }

    @Override
    public void putProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double[] getTerminal(String edge_id) {
        void var3_3;
        double[] ndir;
        RenderableEdge e = (RenderableEdge)Mediator.getInstance().getObject(edge_id);
        if (e.v1 == this) {
            ndir = Vec.normalize(Vec.sub(e.v2.screenPos, e.v1.screenPos));
        } else if (e.v2 == this) {
            ndir = Vec.normalize(Vec.sub(e.v1.screenPos, e.v2.screenPos));
        } else {
            throw new RuntimeException();
        }
        double offset = this.calcOffset((double[])var3_3);
        return Vec.add(Vec.scale((double[])var3_3, offset), this.screenPos);
    }

    @Override
    public double[] getScreenPos() {
        return this.screenPos;
    }

    @Override
    public void setScreenPos(double[] pos) {
        this.screenPos = pos;
    }
}

