/*
 * Decompiled with CFR 0.152.
 */
package org.nishiohirokazu.layout;

import java.util.Hashtable;
import java.util.Vector;
import org.nishiohirokazu.graph.RenderableVertex;
import org.nishiohirokazu.grinEdit.UtilXMLRPC;
import org.nishiohirokazu.layout.PhysicalLaw;
import org.nishiohirokazu.vector.Vec;

public class Repulsion
extends PhysicalLaw {
    private Vector target;
    public double repulsionK = 0.02;
    public double repulsionRadius = 3.0;

    public Repulsion(Vector target) {
        this.target = target;
    }

    public boolean apply() {
        double REPULSION_RADIUS = this.repulsionRadius;
        double REPULSION_K = this.repulsionK;
        int i = 0;
        while (i < this.target.size()) {
            RenderableVertex v1 = (RenderableVertex)this.target.get(i);
            int j = 0;
            while (j < i) {
                RenderableVertex v2 = (RenderableVertex)this.target.get(j);
                double[] dir = Vec.sub(v2.position, v1.position);
                double dist = Vec.mag(dir);
                if (dist < REPULSION_RADIUS) {
                    double[] ndir = Vec.normalize(dir);
                    double power = REPULSION_K * (1.0 - dist / REPULSION_RADIUS);
                    double[] force = Vec.scale(ndir, power);
                    v2.velocityList.add(force);
                    v1.velocityList.add(Vec.inv(force));
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public int tolerance() {
        return -1;
    }

    public void rpc_repulsionK(Object o) {
        this.repulsionK = UtilXMLRPC.ToDouble(o);
    }

    public void rpc_repulsionRadius(Object o) {
        this.repulsionRadius = UtilXMLRPC.ToDouble(o);
    }

    public Hashtable rpc_getParams() {
        Hashtable<String, Double> result = new Hashtable<String, Double>();
        result.put("repulsionK", this.repulsionK);
        result.put("repulsionRadius", this.repulsionRadius);
        return result;
    }
}

