/*
 * Decompiled with CFR 0.152.
 */
package org.nishiohirokazu.grinEdit.mouseOperation;

import java.util.Vector;
import org.nishiohirokazu.graph.RenderableVertex;
import org.nishiohirokazu.grinEdit.Infrastructure;
import org.nishiohirokazu.grinEdit.Mediator;
import org.nishiohirokazu.grinEdit.mouseOperation.MouseOperation;
import org.nishiohirokazu.swt.ViewportTransformer;
import org.nishiohirokazu.vector.Vec;

public class MO_MoveVertex
extends MouseOperation {
    private RenderableVertex target;
    public boolean toAnchor = true;

    public String getName() {
        return "Move vertex";
    }

    public MO_MoveVertex(boolean toAnchor) {
        this.toAnchor = toAnchor;
    }

    public void mouseDown(int x, int y) {
        int RADIUS = 20;
        double[] pos = new double[]{x, y};
        double minDist = RADIUS * 2;
        Vector vs = this.med.graph.vertexList;
        int i = 0;
        while (i < vs.size()) {
            double dist;
            RenderableVertex v = (RenderableVertex)vs.get(i);
            if (v.screenPos != null && (dist = Vec.distance(v.screenPos, pos)) < minDist) {
                minDist = dist;
                this.target = v;
            }
            ++i;
        }
        if (this.target != null) {
            this.med.graph.anchorTable.put(this.target, this.target.position);
        }
    }

    public void mouseMove(int x, int y) {
        ViewportTransformer vp = Infrastructure.getViewportTransformer();
        if (this.target != null) {
            double[] screenPos = new double[]{x, y};
            Mediator med = Mediator.getInstance();
            med.graph.anchorTable.put(this.target, vp.invViewportTransform(screenPos));
        }
    }

    public void mouseUp(int x, int y) {
        if (this.target != null && !this.toAnchor) {
            this.med.graph.anchorTable.remove(this.target);
        }
        this.target = null;
    }
}

