/*
 * Decompiled with CFR 0.152.
 */
package org.nishiohirokazu.dummy_package.sample_impl;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JFrame;
import org.nishiohirokazu.graph.RenderableVertex;
import org.nishiohirokazu.grinEdit.Mediator;
import org.nishiohirokazu.layout.Repulsion;

public class SampleImpl
extends JFrame
implements ActionListener {
    private Mediator med;
    private ArrayList buttonList = new ArrayList();
    private ArrayList vertexList = new ArrayList();

    public static void main(String[] args) {
        SampleImpl frame = new SampleImpl();
        frame.setSize(300, 200);
        frame.setVisible(true);
    }

    public SampleImpl() {
        this.med = Mediator.getInstance();
        Repulsion rep = (Repulsion)this.med.graph.aggregator.getLaw(1);
        rep.repulsionK = 1.0;
        rep.repulsionRadius = 20.0;
        this.addNewVertex(50.0, 50.0);
        this.setLayout(null);
        Timer t = new Timer();
        TimerTask tt = new TimerTask(){

            public void run() {
                SampleImpl.this.updateScreen();
            }
        };
        t.schedule(tt, 0L, 10L);
        this.setDefaultCloseOperation(3);
    }

    public void actionPerformed(ActionEvent arg) {
        if (arg.getActionCommand().equals("AddNewVertex")) {
            JButton b = (JButton)arg.getSource();
            Rectangle r = b.getBounds();
            this.addNewVertex(r.x, r.y);
        }
    }

    public void addNewVertex(double x, double y) {
        Random r = new Random();
        JButton b = new JButton();
        b.setActionCommand("AddNewVertex");
        b.addActionListener(this);
        b.setBounds((int)x, (int)y, 10, 10);
        this.getContentPane().add(b);
        this.buttonList.add(b);
        RenderableVertex v = this.med.graph.addVertex();
        double[] pos = new double[]{x + r.nextDouble(), y + r.nextDouble()};
        v.position = pos;
        this.vertexList.add(v);
    }

    public void updateButtonPos() {
        int i = 0;
        while (i < this.buttonList.size()) {
            JButton b = (JButton)this.buttonList.get(i);
            RenderableVertex v = (RenderableVertex)this.vertexList.get(i);
            b.setBounds((int)v.position[0], (int)v.position[1], 10, 10);
            ++i;
        }
    }

    public void updateScreen() {
        if (!this.med.pause) {
            this.med.graph.layoutStep();
            this.updateButtonPos();
        }
    }
}

