unit UNsmSession;
(* NSM ZbV֘Ajbg *)

interface

uses
  Classes, SyncObjs, UNsmMemberList, UNsmConnection;

type
  TNsmSessionList = class;
  // ZbVNX
  TNsmSession = class(TObject)
  private
    FOwner: TNsmSessionList;
    FConnection: TNsmConnection;
    FProtocol: String;
    FCaption: WideString;
    FStatus: Integer;
    FMembers: TNsmMemberList;
  public
    constructor Create(AOwner: TNsmSessionList);
    destructor Destroy; override;
    property Connection: TNsmConnection read FConnection write FConnection;
    property Protocol: String read FProtocol write FProtocol;
    property Caption: WideString read FCaption write FCaption;
    property Status: Integer read FStatus write FStatus;
    property Members: TNsmMemberList read FMembers;
  end;

  // ZbVXg
  TNsmSessionList = class(TObject)
  private
    FSessions: TList;
    function GetCount: Integer;
    function GetSession(Index: Integer): TNsmSession;
  public
    constructor Create;
    destructor Destroy; override;
    property Count: Integer read GetCount;
    property Session[Index: Integer]: TNsmSession read GetSession; default;
    function Add(AConnection: TNsmConnection): TNsmSession;
    procedure Delete(Index: Integer);
    procedure Remove(Item: TNsmSession);
    procedure Clear;
    function IndexOf(ASession: TNsmSession): Integer;
  end;

  // XbhZ[tȃZbVXg
  TNsmThreadSessionList = class(TObject)
  private
    FSessions: TNsmSessionList;
  public
    constructor Create;
    destructor Destroy; override;
    function LockList: TNsmSessionList;
    procedure UnlockList;
  end;

implementation

var
  FCriticalSection: TCriticalSection;

// TNsmConnection --------------------------------------------------------------
constructor TNsmSession.Create(AOwner: TNsmSessionList);
begin
  FOwner := AOwner;
  FMembers := TNsmMemberList.Create;
end;

destructor TNsmSession.Destroy;
begin
  FMembers.Free;
  inherited;
end;

// TNsmConnectionList ----------------------------------------------------------
constructor TNsmSessionList.Create;
begin
  FSessions := TList.Create;
end;

destructor TNsmSessionList.Destroy;
begin
  Clear;
  FSessions.Free;
  inherited;
end;

function TNsmSessionList.GetCount: Integer;
begin
  Result := FSessions.Count;
end;

function TNsmSessionList.GetSession(Index: Integer): TNsmSession;
begin
  Result := TNsmSession(FSessions[Index]);
end;

function TNsmSessionList.Add(AConnection: TNsmConnection): TNsmSession;
begin
  Result := TNsmSession.Create(Self);
  Result.Connection := AConnection;
  if Assigned(AConnection) then
    Result.Protocol := AConnection.Protocol;
  FSessions.Add(Result);
end;

procedure TNsmSessionList.Delete(Index: Integer);
begin
  TNsmSession(FSessions[Index]).Free;
  FSessions.Delete(Index);
end;

procedure TNsmSessionList.Remove(Item: TNsmSession);
begin
  FSessions.Remove(Item);
  Item.Free;
end;

procedure TNsmSessionList.Clear;
begin
  while FSessions.Count > 0 do
    Delete(0);
end;

function TNsmSessionList.IndexOf(ASession: TNsmSession): Integer;
var
  I: Integer;
begin
  Result := -1;
  for I := 0 to FSessions.Count - 1 do
    if FSessions[I] = ASession then
    begin
      Result := I;
      Break;
    end;
end;

// TNsmThreadConnectionList ----------------------------------------------------

constructor TNsmThreadSessionList.Create;
begin
  FSessions := TNsmSessionList.Create;
end;

destructor TNsmThreadSessionList.Destroy;
begin
  FSessions.Free;
  inherited;
end;

function TNsmThreadSessionList.LockList: TNsmSessionList;
begin
  FCriticalSection.Enter;
  Result := FSessions;
end;

procedure TNsmThreadSessionList.UnlockList;
begin
  FCriticalSection.Leave;
end;

// -----------------------------------------------------------------------------

initialization
  FCriticalSection := TCriticalSection.Create;

finalization
  FCriticalSection.Free;

end.
