unit UNsmMemberList;
(* NSM oXg֘Ajbg *)

interface

uses
  Windows, SysUtils, Classes, UNsmConsts, IniFiles;

type
  TNsmMemberStatus = 0..1000;
  TNsmSortType = (stNone, stState, stName, stAccount);

  TNsmUser = class(TObject)
  private
    FAccount: String;           // AJEg
    FName: WideString;          // \
    FStatus: TNsmMemberStatus;  // IC
    FStatusStr: WideString;     // Ԃ\
    FBusyness: Integer;         // Z
    procedure SetStatus(Value: TNsmMemberStatus);
  public
    property Account: String read FAccount write FAccount;
    property Name: WideString read FName write FName;
    property Status: TNsmMemberStatus read FStatus write SetStatus;
    property StatusStr: WideString read FStatusStr write FStatusStr;
    property Busyness: Integer read FBusyness write FBusyness;
  end;

  TNsmMember = class(TObject)
  private
    FAccount: String;           // AJEg
    FName: WideString;          // \
    FStatus: TNsmMemberStatus;  // IC
    FStatusStr: WideString;     // Ԃ\
    FBusyness: Integer;         // Z
    FGroup: Integer;            // O[v
    procedure SetStatus(Value: TNsmMemberStatus);
  public
    constructor Create(AnAccount: String);
    destructor Destroy; override;
    procedure Assign(Source: TNsmMember);
    property Account: String read FAccount;
    property Name: WideString read FName write FName;
    property Status: TNsmMemberStatus read FStatus write SetStatus;
    property StatusStr: WideString read FStatusStr write FStatusStr;
    property Busyness: Integer read FBusyness write FBusyness;
    property Group: Integer read FGroup write FGroup;
  end;

  // oXg
  TNsmMemberList = class(TObject)
  private
    FMembers: THashedStringList;
    FUpdated: Boolean;
    function GetMember(Index: Integer): TNsmMember;
    function GetCount: Integer;
  public
    constructor Create;
    destructor Destroy; override;
    function Add(Account: String): TNsmMember;
    procedure Move(CurIndex, NewIndex: Integer);
    procedure Delete(Idx: Integer);
    procedure Clear;
    function IndexOfAccount(Account: String): Integer;
    function Find(Account: String): TNsmMember;
    function Contains(Account: String): Boolean;

    property Member[Index: Integer]: TNsmMember read GetMember; default;
    property Count: Integer read GetCount;
    property Updated: Boolean read FUpdated write FUpdated;
  end;

  // O[v
  TNsmGroup = class(TObject)
  private
    FName: WideString;
    FId: Integer;
    FExpanded: Boolean;
    FCount: Integer;
  public
    property Name: WideString read FName write FName;
    property Id: Integer read FId write FId;
    property Expanded: Boolean read FExpanded write FExpanded;
    property Count: Integer read FCount write FCount;
  end;

  // O[vXg
  TNsmGroupList = class(TObject)
  private
    FGroups: TList;
    function GetGroup(Index: Integer): TNsmGroup;
    function GetCount: Integer;
  public
    constructor Create;
    destructor Destroy; override;

    function Add: TNsmGroup;
    function Insert(Idx: Integer): TNsmGroup;
    procedure Move(CurIndex, NewIndex: Integer);
    procedure Delete(Idx: Integer);
    procedure Clear;
    function IndexOf(Id: Integer): Integer;
    procedure AlphaSort;

    property Group[Index: Integer]: TNsmGroup read GetGroup; default;
    property Count: Integer read GetCount;
  end;

implementation

// TNsmUser --------------------------------------------------------------------

procedure TNsmUser.SetStatus(Value: TNsmMemberStatus);
begin
  FStatus := Value;
  case FStatus of
  NMST_OFFLINE:     FBusyness := 100;
  NMST_ONLINE:      FBusyness := 0;
  NMST_BUSY:        FBusyness := 80;
  NMST_IDLE:        FBusyness := 40;
  NMST_BERIGHTBACK: FBusyness := 40;
  NMST_AWAY:        FBusyness := 50;
  NMST_ONTHEPHONE:  FBusyness := 80;
  NMST_OUTTOLUNCH:  FBusyness := 50;
  NMST_HIDDEN:      FBusyness := 100;
  end;
end;

// TNsmMember ------------------------------------------------------------------

constructor TNsmMember.Create(AnAccount: String);
begin
  inherited Create;
  FAccount := AnAccount;
end;

destructor TNsmMember.Destroy;
begin
  inherited;
end;

procedure TNsmMember.Assign(Source: TNsmMember);
begin
  FAccount := Source.Account;
  FName := Source.Name;
  FStatus := Source.Status;
  FStatusStr := Source.StatusStr;
  FBusyness := Source.Busyness;
  FGroup := Source.Group;
end;

procedure TNsmMember.SetStatus(Value: TNsmMemberStatus);
begin
  FStatus := Value;
  case FStatus of
  NMST_OFFLINE:     FBusyness := 100;
  NMST_ONLINE:      FBusyness := 0;
  NMST_BUSY:        FBusyness := 80;
  NMST_IDLE:        FBusyness := 40;
  NMST_BERIGHTBACK: FBusyness := 40;
  NMST_AWAY:        FBusyness := 50;
  NMST_ONTHEPHONE:  FBusyness := 80;
  NMST_OUTTOLUNCH:  FBusyness := 50;
  NMST_HIDDEN:      FBusyness := 100;
  end;
end;

// TNsmMemberList --------------------------------------------------------------

constructor TNsmMemberList.Create;
begin
  FMembers := THashedStringList.Create;
  FMembers.Sorted := True;
end;

destructor TNsmMemberList.Destroy;
begin
  Clear;
  FMembers.Free;
end;

function TNsmMemberList.GetMember(Index: Integer): TNsmMember;
begin
  Result := TNsmMember(FMembers.Objects[Index]);
end;

function TNsmMemberList.GetCount: Integer;
begin
  Result := FMembers.Count;
end;

// ǉ
function TNsmMemberList.Add(Account: String): TNsmMember;
begin
  Result := TNsmMember.Create(Account);
  FMembers.AddObject(Account, Result);
end;

// ړ
procedure TNsmMemberList.Move(CurIndex, NewIndex: Integer);
begin
  FMembers.Move(CurIndex, NewIndex);
end;

// 폜
procedure TNsmMemberList.Delete(Idx: Integer);
begin
  TNsmMember(FMembers.Objects[Idx]).Free;
  FMembers.Delete(Idx);
end;

// S
procedure TNsmMemberList.Clear;
begin
  while FMembers.Count > 0 do
    Delete(0);
end;

// 
function TNsmMemberList.IndexOfAccount(Account: String): Integer;
begin
  Result := FMembers.IndexOf(Account);
end;

//  2
function TNsmMemberList.Find(Account: String): TNsmMember;
var
  Idx: Integer;
begin
  Idx := IndexOfAccount(Account);
  if Idx > -1 then
    Result := TNsmMember(FMembers.Objects[Idx])
  else
    Result := nil;
end;

//  3
function TNsmMemberList.Contains(Account: String): Boolean;
begin
  if IndexOfAccount(Account) > -1 then
    Result := True
  else
    Result := False;
end;


// TNsmGroupList ---------------------------------------------------------------

constructor TNsmGroupList.Create;
begin
  FGroups := TList.Create;
end;

destructor TNsmGroupList.Destroy;
begin
  Clear;
  FGroups.Free;
end;

function TNsmGroupList.GetGroup(Index: Integer): TNsmGroup;
begin
  Result := TNsmGroup(FGroups[Index]);
end;

function TNsmGroupList.GetCount: Integer;
begin
  Result := FGroups.Count;
end;

// ǉ
function TNsmGroupList.Add: TNsmGroup;
begin
  Result := TNsmGroup.Create;
  FGroups.Add(Result);
end;

// }
function TNsmGroupList.Insert(Idx: Integer): TNsmGroup;
begin
  Result := TNsmGroup.Create;
  FGroups.Insert(Idx, Result);
end;

// ړ
procedure TNsmGroupList.Move(CurIndex, NewIndex: Integer);
begin
  FGroups.Move(CurIndex, NewIndex);
end;

// 폜
procedure TNsmGroupList.Delete(Idx: Integer);
begin
  TNsmGroup(FGroups[Idx]).Free;
  FGroups.Delete(Idx);
end;

// S
procedure TNsmGroupList.Clear;
begin
  while FGroups.Count > 0 do
    Delete(0);
end;

// 
function TNsmGroupList.IndexOf(Id: Integer): Integer;
var
  I: Integer;
begin
  Result := -1;
  for I := 0 to FGroups.Count - 1 do
  begin
    if TNsmGroup(FGroups[I]).Id = Id then
    begin
      Result := I;
      Break;
    end;
  end;
end;

function CompareGroupName(Item1, Item2: Pointer): Integer;
begin
  if (TNsmGroup(Item1).Id = 0) and (TNsmGroup(Item2).Id <> 0) then
    Result := 1
  else if (TNsmGroup(Item1).Id <> 0) and (TNsmGroup(Item2).Id = 0) then
    Result := -1
  else
    Result := CompareText(TNsmGroup(Item1).Name, TNsmGroup(Item2).Name);
  if Result = 0 then
    Result := TNsmGroup(Item1).Id - TNsmGroup(Item2).Id;
end;

// ёւ
procedure TNsmGroupList.AlphaSort;
begin
  FGroups.Sort(@CompareGroupName);
end;

end.
