unit UMsnUtils;
(* ֘A[eBeB *)

interface

uses
  Windows, Classes, StrUtils, SysUtils, UIntList;

procedure Split(List: TIntegerList; const S, Delimiter: String; Count: Integer = 0); overload;
procedure Split(List: TStrings; const S, Delimiter: String; Count: Integer = 0); overload;
procedure SplitMimeHeader(List: TStrings; const MimeHeader: String);
function EncodeSpace(const S: String): String;
function UrlEncode(const S: String): String;
function UrlDecode(const S: String): String;
function HexToInt(HexStr: String): Int64;

implementation

// ؂蕶ŕĐlXgɊi[
procedure Split(List: TIntegerList; const S, Delimiter: String; Count: Integer = 0);
var
  P: Integer;
  Temp: String;
begin
  List.Clear;
  Temp := S;
  P := Pos(Delimiter, Temp);
  while (P <> 0) and ((Count = 0) or (List.Count < Count - 1)) do
  begin
    List.Add(StrToIntDef(Copy(Temp, 1, P - 1), 0));
    Delete(Temp, 1, P + Length(Delimiter) - 1);
    P := Pos(Delimiter, Temp);
  end;
  if Length(Temp) > 0 then
    List.Add(StrToIntDef(Temp, 0));
end;

// ؂蕶ŕĕ񃊃XgɊi[
procedure Split(List: TStrings; const S, Delimiter: String; Count: Integer = 0);
var
  P: Integer;
  Temp: String;
begin
  List.Clear;
  Temp := S;
  P := Pos(Delimiter, Temp);
  while (P <> 0) and ((Count = 0) or (List.Count < Count - 1)) do
  begin
    List.Add(Copy(Temp, 1, P - 1));
    Delete(Temp, 1, P + Length(Delimiter) - 1);
    P := Pos(Delimiter, Temp);
  end;
  if Length(Temp) > 0 then
    List.Add(Temp);
end;

// ؂蕶ŕĕ񃊃XgɊi[
// AnsiString Ή
procedure AnsiSplit(List: TStrings; const Str, Delimiter: String; Count: Integer = 0);
var
  Pos: Integer;
  Temp: String;
begin
  List.Clear;
  Temp := Str;
  Pos := AnsiPos(Delimiter, Temp);
  while (Pos <> 0) and ((Count = 0) or (List.Count < Count - 1)) do
  begin
    List.Add(Copy(Temp, 1, Pos - 1));
    Delete(Temp, 1, Pos + Length(Delimiter) - 1);
    Pos := AnsiPos(Delimiter, Temp);
  end;
  if Length(Temp) > 0 then
    List.Add(Temp);
end;

// MIME wb_ TStringList ɕϊ
// Name=Value `Ŋi[
procedure SplitMimeHeader(List: TStrings; const MimeHeader: String);
var
  I: Integer;
  Temp: TStringList;
begin
  Temp := TStringList.Create;
  Temp.Text := MimeHeader;

  List.Clear;
  for I := 0 to Temp.Count - 1 do
    List.Add(StringReplace(Temp[I], ': ', '=', []));

  Temp.Free;
end;

function EncodeSpace(const S: String): String;
var
  I, Len: Integer;
begin
  Result := '';
  Len := Length(S);
  for I := 1 to Len do
  begin
    if S[I] = ' ' then
      Result := Result + '%20'
    else if S[I] = '%' then
      Result := Result + '%25'
    else
      Result := Result + S[I];
  end;
end;

// url-encode
function UrlEncode(const S: String): String;
var
  I, Len: Integer;
begin
  Result := '';
  Len := Length(S);
  for I := 1 to Len do
  begin
    if not (S[I] in ['0'..'9', 'a'..'z', 'A'..'Z']) then
      Result := Result + '%' + IntToHex(Ord(S[I]), 2)
    else
      Result := Result + S[I];
  end;
end;

//@url-decode
function UrlDecode(const S: String): String;
var
  I, Len: Integer;
  C: Char;
begin
  Result := '';
  Len := Length(S);
  I := 1;
  while I <= Len do
  begin
    if (I < Len - 1) and (S[I] = '%') then
    begin
      C := Chr(HexToInt(S[I + 1] + S[I + 2]));
      if C <> #0 then
      begin
        Result := Result + C;
        Inc(I, 2);
      end else
        Result := Result + S[I];
    end else
      Result := Result + S[I];

    Inc(I);
  end;
end;

// 16i񂩂琮^
function HexToInt(HexStr: String): Int64;
var
  RetVar : Int64;
  I : Byte;
begin
  HexStr := UpperCase(HexStr);
  RetVar := 0;

  for I := 1 to Length(HexStr) do
  begin
    RetVar := RetVar shl 4;
    if HexStr[I] in ['0'..'9'] then
      RetVar := RetVar + (Byte(HexStr[I]) - 48)
    else
      if HexStr[i] in ['A'..'F'] then
        RetVar := RetVar + (Byte(HexStr[I]) - 55)
      else
      begin
        Retvar := 0;
        Break;
      end;
  end;

  Result := RetVar;
end;

end.
