unit UVersionInfo;

interface

uses
  Windows, SysUtils;

type
  TVerResourceKey = (
        vrComments,         // Rg
        vrCompanyName,      // Ж
        vrFileDescription,  // 
        vrFileVersion,      // t@Co[W
        vrInternalName,     // 
        vrLegalCopyright,   // 쌠
        vrLegalTrademarks,  // W
        vrOriginalFilename, // t@C
        vrPrivateBuild,     // vCx[grh
        vrProductName,      // i
        vrProductVersion,   // io[W
        vrSpecialBuild);    // XyVrh

function GetVersionInfo(KeyWord: TVerResourceKey): String;        
function GetWin32VersionInfo: String;

implementation

const
  KeyWordStr: array [TVerResourceKey] of String = (
        'Comments',
        'CompanyName',
        'FileDescription',
        'FileVersion',
        'InternalName',
        'LegalCopyright',
        'LegalTrademarks',
        'OriginalFilename',
        'PrivateBuild',
        'ProductName',
        'ProductVersion',
        'SpecialBuild');

// o[W擾
function GetVersionInfo(KeyWord: TVerResourceKey): String;
const
  Translation = '\VarFileInfo\Translation';
  FileInfo = '\StringFileInfo\%0.4s%0.4s\';
var
  BufSize, HWnd: DWORD;
  VerInfoBuf: Pointer;
  VerData: Pointer;
  VerDataLen: Longword;
  PathLocale: String;
  ModuleName: array[0..255] of Char;
begin
  GetModuleFileName(HInstance, ModuleName, SizeOf(ModuleName));

  // Kvȃobt@̃TCY擾
  BufSize := GetFileVersionInfoSize(ModuleName, HWnd);
  if BufSize <> 0 then
  begin
    // m
    GetMem(VerInfoBuf, BufSize);
    try
      GetFileVersionInfo(ModuleName, 0, BufSize, VerInfoBuf);
      // ϐubN̕ϊe[uw
      VerQueryValue(VerInfoBuf, PChar(Translation), VerData, VerDataLen);
      if not (VerDataLen > 0) then
        raise Exception.Create('̎擾Ɏs܂');
      // 8̂PUiɕϊ
      // '\StringFileInfo\027382\FileDescription'
      PathLocale := Format(FileInfo + KeyWordStr[KeyWord],
        [IntToHex(Integer(VerData^) and $FFFF, 4),
         IntToHex((Integer(VerData^) shr 16) and $FFFF, 4)]);
      VerQueryValue(VerInfoBuf, PChar(PathLocale), VerData, VerDataLen);
      if VerDataLen > 0 then
      begin
        // VerData̓[ŏI镶ł͂ȂƂɒ
        result := '';
        SetLength(result, VerDataLen);
        StrLCopy(PChar(result), VerData, VerDataLen);
      end;
    finally
      // 
      FreeMem(VerInfoBuf);
    end;
  end;
end;

function GetWin32VersionInfo: String;
var
  Platfrm: String;
begin
  if Win32Platform = VER_PLATFORM_WIN32_NT then
    Platfrm := ' NT'
  else if Win32MajorVersion < 4 then
    Platfrm := ''
  else if Win32MinorVersion < 10 then
    Platfrm := ' 95'
  else
    Platfrm := ' 98';
  Result := Format('Windows%s %d.%.2d.%d %s', [Platfrm, Win32MajorVersion,
    Win32MinorVersion, LOWORD(Win32BuildNumber), Win32CSDVersion])
end;

end.
 