unit UFrmMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  UFrmBaseContainer, Menus, ExtCtrls, ActnList, ExTabSet, ExPanel, UFrmBase,
  ExSpeedButton, StdCtrls, USkinResource, UStrResource, USimpleUICore,
  ComCtrls, ToolWin, UNsmTypes, UNsmConsts, UConfig, ExTaskTray, (*ExLabelList,*)
  UUserProfile, ResizeArea;

type
  TFrmMain = class(TFrmBaseContainer)
    actExit: TAction;
    actUpdateThemeMenu: TAction;
    actGetNewTheme: TAction;
    actLogOut: TAction;
    actAbout: TAction;
    actOpenOfficialWeb: TAction;
    actOpenBbs: TAction;
    CoolBar: TCoolBar;
    MenuBar: TToolBar;
    MainMenu: TMainMenu;
    mnuConnect: TMenuItem;
    mnuLogout: TMenuItem;
    N1: TMenuItem;
    mnuClose: TMenuItem;
    mnuCommands: TMenuItem;
    mnuThemes: TMenuItem;
    N3: TMenuItem;
    mnuUpdateThemeMenu: TMenuItem;
    mnuGetNewTheme: TMenuItem;
    mnuHelp: TMenuItem;
    mnuOpenOfficialWeb: TMenuItem;
    mnuOpenBBS: TMenuItem;
    N2: TMenuItem;
    mnuAbout: TMenuItem;
    actUIOption: TAction;
    mnuOption: TMenuItem;
    TaskTray: TExTaskTray;
    pmTaskTray: TPopupMenu;
    mnuExit2: TMenuItem;
    actShowMainWindow: TAction;
    mnuShowMainWindow: TMenuItem;
    mnuOpenOfficialWeb2: TMenuItem;
    N4: TMenuItem;
    actEditProfile: TAction;
    E1: TMenuItem;
    mnuProfiles: TMenuItem;
    N5: TMenuItem;
    actOpenThemeFolder: TAction;
    mnuOpenThemeFolder: TMenuItem;
    actStayOnTop: TAction;
    T1: TMenuItem;
    N6: TMenuItem;
    mnuOpenBbs2: TMenuItem;
    N8: TMenuItem;
    mnuGlobalStatus: TMenuItem;
    actGlobalOnline: TAction;
    actGlobalHidden: TAction;
    actGlobalAway: TAction;
    actGlobalBusy: TAction;
    actGlobalBeRightBack: TAction;
    actGlobalOnThePhone: TAction;
    actGlobalOutToLunch: TAction;
    N9: TMenuItem;
    N10: TMenuItem;
    N11: TMenuItem;
    N12: TMenuItem;
    N13: TMenuItem;
    X1: TMenuItem;
    N14: TMenuItem;
    mnuStatus: TMenuItem;
    mnuChangeUserName: TMenuItem;
    N15: TMenuItem;
    actQuickLogin: TAction;
    Q1: TMenuItem;
    N16: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure actExitExecute(Sender: TObject);
    procedure actLogOutExecute(Sender: TObject);
    procedure actUpdateThemeMenuExecute(Sender: TObject);
    procedure actGetNewThemeExecute(Sender: TObject);
    procedure actAboutExecute(Sender: TObject);
    procedure actOpenOfficialWebExecute(Sender: TObject);
    procedure actOpenBbsExecute(Sender: TObject);
    procedure mnuThemesClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure actUIOptionExecute(Sender: TObject);
    procedure actShowMainWindowExecute(Sender: TObject);
    procedure TaskTrayDblClick(Sender: TObject);
    procedure actEditProfileExecute(Sender: TObject);
    procedure actOpenThemeFolderExecute(Sender: TObject);
    procedure actStayOnTopExecute(Sender: TObject);
    procedure actGlobalOnlineExecute(Sender: TObject);
    procedure actGlobalAwayExecute(Sender: TObject);
    procedure actGlobalBusyExecute(Sender: TObject);
    procedure actGlobalBeRightBackExecute(Sender: TObject);
    procedure actGlobalOnThePhoneExecute(Sender: TObject);
    procedure actGlobalOutToLunchExecute(Sender: TObject);
    procedure actGlobalHiddenExecute(Sender: TObject);
    procedure mnuGlobalStatusClick(Sender: TObject);
    procedure actQuickLoginExecute(Sender: TObject);
  private
    FThemes: TStringList;
    function GetSkinsPath: String;
    procedure UpdateProfileMenu;
    procedure ProfileMenuClick(Sender: TObject);
    procedure UpdateThemeMenu;
    procedure ApplyTheme(Folder: String);
    procedure ThemeMenuClick(Sender: TObject);
  protected
    procedure UpdateSkinObjects; override;
    procedure SetActiveDockedForm(Value: TFrmBase); override;
  public
    procedure UpdateActions; override;  
    procedure ApplyConfig; override;
    procedure ApplyPrivateConfig; override;
    procedure UpdateConfig; override;
    procedure FloatWindow(Form: TFrmBase); override;
    procedure Initialize;
    procedure UpdateTaskTray;
  end;

var
  FrmMain: TFrmMain;

implementation

uses UFrmNotify, UFrmList, UFrmAbout, UFrmOption, UFrmProfiles,
  UFrmQuickLogin;

{$R *.dfm}

procedure TFrmMain.ApplyConfig;
begin
  inherited;
  TaskTray.Active := Config.UseTaskTray;
  if Config.MainTransparency > 0 then
  begin
    AlphaBlend := True;
    AlphaBlendValue := (100 - Config.MainTransparency) * 255 div 100;
  end else
    AlphaBlend := False;
end;

procedure TFrmMain.ApplyPrivateConfig;
begin
  inherited;
  with Config do
  begin
    SetBounds(MainLeft, MainTop, MainWidth, MainHeight);
    WindowState := MainWinState;
    StayOnTop := MainStayOnTop;
    SetTabSetPosition(MainTabPosition);
  end;
end;

procedure TFrmMain.UpdateConfig;
var
  R: TRect;
begin
  inherited;
  R := NormalWindowRect;
  Config.MainWidth    := R.Right - R.Left;
  Config.MainHeight   := R.Bottom - R.Top;
  Config.MainLeft     := R.Left;
  Config.MainTop      := R.Top;
  Config.MainWinState := WindowState;
  Config.MainStayOnTop    := StayOnTop;
  Config.MainTabPosition  := TabSet.TabPosition;

  Config.ThemeName := ExtractFileName(ExcludeTrailingPathDelimiter(
        SkinResources.SkinFolder));
end;

procedure TFrmMain.UpdateActions;
begin
  inherited;
  actLogOut.Enabled := (TabSet.TabIndex > -1);
  actStayOnTop.Checked := StayOnTop;
end;

procedure TFrmMain.UpdateSkinObjects;
begin
  inherited;
  UpdateTaskTray;
  mnuGlobalStatus.SubMenuImages := SkinResources.StateImages;
  mnuStatus.SubMenuImages := SkinResources.StateImages;
  mnuProfiles.SubMenuImages := SkinResources.StateImages;
end;

procedure TFrmMain.FloatWindow(Form: TFrmBase);
begin
  inherited;
  Form.StayOnTop := Self.StayOnTop;
end;

procedure TFrmMain.SetActiveDockedForm(Value: TFrmBase);
begin
  inherited;
  SyncMenuItems([mnuStatus, mnuChangeUserName]);
end;

// pX̃fBNg̃XgԂ
procedure GetDirList(List: TStrings; Path: String);
var
  sr: TSearchRec;
begin
  if DirectoryExists(Path) then begin
    if FindFirst(Path + '*.*', faAnyFile, sr) = 0 then
    begin
      repeat
      begin
        if (sr.Name <> '.') and (sr.Name <> '..') and
           ((sr.Attr and faDirectory) <> 0) then
          List.Add(sr.Name);
      end until FindNext(sr) <> 0;
      FindClose(sr);
    end;
  end;
end;

// 'Skins' tH_̏ꏊԂ
function TFrmMain.GetSkinsPath: String;
begin
  Result := SimpleUICore.WorkDir + 'Skins\';
end;

// vt@Cj[̍XV
procedure TFrmMain.UpdateProfileMenu;
var
  I: Integer;
  Item: TMenuItem;
begin
  while mnuProfiles.Count > 2 do
    mnuProfiles.Items[0].Free;
  for I := 0 to SimpleUICore.UserProfiles.Count - 1 do
  begin
    Item := TMenuItem.Create(Self);
    Item.Caption := SimpleUICore.UserProfiles[I].ProfileName;
    Item.Tag := I;
    Item.OnClick := ProfileMenuClick;
    if SimpleUICore.UserProfiles[I].Status = NMST_HIDDEN then
      Item.ImageIndex := 3
    else
      Item.ImageIndex := 0;
    mnuProfiles.Insert(mnuProfiles.Count - 2, Item);
  end;
end;

procedure TFrmMain.ProfileMenuClick(Sender: TObject);
begin
  if Sender is TMenuItem then
  begin
    SimpleUICore.LogIn(
        SimpleUICore.UserProfiles[TMenuItem(Sender).Tag].Protocol,
        SimpleUICore.UserProfiles[TMenuItem(Sender).Tag].Account,
        SimpleUICore.UserProfiles[TMenuItem(Sender).Tag].Password,
        SimpleUICore.UserProfiles[TMenuItem(Sender).Tag].ProfileName,
        SimpleUICore.UserProfiles[TMenuItem(Sender).Tag].Status);
  end;
end;

// e[}j[̍XV
procedure TFrmMain.UpdateThemeMenu;
var
  I: Integer;
  Item: TMenuItem;
begin
  FThemes.Clear;
  GetDirList(FThemes, GetSkinsPath);
  while mnuThemes.Count > 4 do
    mnuThemes.Items[0].Free;
  for I := 0 to FThemes.Count - 1 do
  begin
    Item := TMenuItem.Create(Self);
    Item.Caption := FThemes[I];
    Item.Tag := I;
    Item.OnClick := ThemeMenuClick;
    mnuThemes.Insert(mnuThemes.Count - 4, Item);
  end;
end;

// e[}Kp
procedure TFrmMain.ApplyTheme(Folder: String);
var
  I: Integer;
begin
  Screen.Cursor := crHourGlass;
  try
    SkinResources.SkinFolder := GetSkinsPath + Folder;
    // ׂẴtH[Ƀe[}Ǎ
    for I := 0 to Screen.FormCount - 1 do
      if Screen.Forms[I].InheritsFrom(TFrmBase) then
        TFrmBase(Screen.Forms[I]).LoadSkinResource;
    // ׂẴtH[Ƀe[}Kp
    for I := 0 to Screen.FormCount - 1 do
      if Screen.Forms[I].InheritsFrom(TFrmBase) then
        TFrmBase(Screen.Forms[I]).ApplySkinResource;
  finally
    Screen.Cursor := crDefault;
  end;
end;

procedure TFrmMain.ThemeMenuClick(Sender: TObject);
begin
  if Sender is TMenuItem then
    ApplyTheme(FThemes[TMenuItem(Sender).Tag]);
end;

procedure TFrmMain.mnuThemesClick(Sender: TObject);
var
  I: Integer;
  SkinName: String;
begin
  inherited;
  if SameText(GetSkinsPath, SkinResources.SkinFolder) then
    SkinName := ''
  else
    SkinName := ExtractFileName(ExcludeTrailingPathDelimiter(
        SkinResources.SkinFolder));
  for I := 0 to mnuThemes.Count - 4 do
    mnuThemes.Items[I].Checked :=
      SameText(FThemes[mnuThemes.Items[I].Tag], SkinName);
end;

procedure TFrmMain.UpdateTaskTray;
var
  Tip: String;
  I, S: Integer;
begin
  Tip := RS_APPTITLE;
  for I := 0 to SimpleUICore.Connections.Count - 1 do
  begin
    Tip := Tip + #13#10;
    Tip := Tip + SimpleUICore.Connections[I].Caption + ' - ';
    if SimpleUICore.Connections[I].Status = NMCS_CONNECTED then
      Tip := Tip + SimpleUICore.Connections[I].UserStatusStr
    else
      Tip := Tip + RS_NMCS_DISCONNECTED;
  end;
  TaskTray.Tip := Tip;
  case SimpleUICore.GetGlobalStatus of
  NMST_ONLINE                                               : S := 0;
  NMST_BUSY, NMST_ONTHEPHONE                                : S := 2;
  NMST_IDLE, NMST_BERIGHTBACK, NMST_AWAY, NMST_OUTTOLUNCH   : S := 1;
  else
    S := 3;
  end;
  SkinResources.StateImages.GetIcon(S, TaskTray.Icon);
  TaskTray.Active := Config.UseTaskTray;
end;

procedure TFrmMain.Initialize;
begin
  Show;
end;

procedure TFrmMain.FormCreate(Sender: TObject);
begin
  inherited;
  FThemes := TStringList.Create;
  FThemes.Sorted := True;
  UpdateThemeMenu;
  UpdateProfileMenu;
  WindowKind := wkMain;
  Caption := RS_APPTITLE;
  ApplyTheme(Config.ThemeName);
end;

procedure TFrmMain.FormDestroy(Sender: TObject);
begin
  inherited;
  TaskTray.Active := False;
  FThemes.Free;
end;

procedure TFrmMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  inherited;
  if Config.UseTaskTray then
  begin
    WindowState := wsMinimized;
    Hide;
    Action := caNone;
  end else
    actExit.Execute;
end;

procedure TFrmMain.actExitExecute(Sender: TObject);
begin
  inherited;
  SimpleUICore.SystemExit;
end;

procedure TFrmMain.actLogOutExecute(Sender: TObject);
var
  Form: TCustomForm;
begin
  inherited;
  Form := ActiveDockedForm;
  if Assigned(Form) and (Form is TFrmList) then
    TFrmList(Form).Close;
end;

procedure TFrmMain.actUpdateThemeMenuExecute(Sender: TObject);
begin
  inherited;
  UpdateThemeMenu;
end;

procedure TFrmMain.actGetNewThemeExecute(Sender: TObject);
begin
  inherited;
  SimpleUICore.OpenURL(RS_URL_LIBRARY);
end;

procedure TFrmMain.actAboutExecute(Sender: TObject);
begin
  inherited;
  with TFrmAbout.CreateAsDialog(Self) do
    ShowModal;
end;

procedure TFrmMain.actOpenOfficialWebExecute(Sender: TObject);
begin
  inherited;
  SimpleUICore.OpenURL(RS_URL_OFFICIALWEB);
end;

procedure TFrmMain.actOpenBbsExecute(Sender: TObject);
begin
  inherited;
  SimpleUICore.OpenURL(RS_URL_BBS);
end;

procedure TFrmMain.actUIOptionExecute(Sender: TObject);
begin
  inherited;
  with TFrmOption.CreateAsDialog(Self) do
  begin
    ShowModal;
  end;
end;

procedure TFrmMain.actShowMainWindowExecute(Sender: TObject);
begin
  inherited;
  Show;
  WindowState := wsNormal;  
end;

procedure TFrmMain.TaskTrayDblClick(Sender: TObject);
begin
  inherited;
  actShowMainWindow.Execute;
end;

procedure TFrmMain.actEditProfileExecute(Sender: TObject);
var
  Form: TFrmProfiles;
begin
  inherited;
  Form := TFrmProfiles.CreateAsDialog(Self);
  try
    Form.ShowModal;
    UpdateProfileMenu;
  finally
    Form.Release;
  end;
end;

procedure TFrmMain.actOpenThemeFolderExecute(Sender: TObject);
begin
  inherited;
  SimpleUICore.OpenURL(GetSkinsPath);
end;

procedure TFrmMain.actStayOnTopExecute(Sender: TObject);
begin
  inherited;
  StayOnTop := not StayOnTop;
end;

procedure TFrmMain.actGlobalOnlineExecute(Sender: TObject);
begin
  inherited;
  SimpleUICore.SetGlobalStatus(NMST_ONLINE);
end;

procedure TFrmMain.actGlobalAwayExecute(Sender: TObject);
begin
  inherited;
  SimpleUICore.SetGlobalStatus(NMST_AWAY);
end;

procedure TFrmMain.actGlobalBusyExecute(Sender: TObject);
begin
  inherited;
  SimpleUICore.SetGlobalStatus(NMST_BUSY);
end;

procedure TFrmMain.actGlobalBeRightBackExecute(Sender: TObject);
begin
  inherited;
  SimpleUICore.SetGlobalStatus(NMST_BERIGHTBACK);
end;

procedure TFrmMain.actGlobalOnThePhoneExecute(Sender: TObject);
begin
  inherited;
  SimpleUICore.SetGlobalStatus(NMST_ONTHEPHONE);
end;

procedure TFrmMain.actGlobalOutToLunchExecute(Sender: TObject);
begin
  inherited;
  SimpleUICore.SetGlobalStatus(NMST_OUTTOLUNCH);
end;

procedure TFrmMain.actGlobalHiddenExecute(Sender: TObject);
begin
  inherited;
  SimpleUICore.SetGlobalStatus(NMST_HIDDEN);
end;

procedure TFrmMain.mnuGlobalStatusClick(Sender: TObject);
var
  GS: Integer;
begin
  inherited;
  GS := SimpleUICore.GetGlobalStatus;
  actGlobalOnline.Checked := (GS = NMST_ONLINE);
  actGlobalAway.Checked := (GS = NMST_AWAY);
  actGlobalBusy.Checked := (GS = NMST_BUSY);
  actGlobalBeRightBack.Checked := (GS = NMST_BERIGHTBACK);
  actGlobalOnThePhone.Checked := (GS = NMST_ONTHEPHONE);
  actGlobalOutToLunch.Checked := (GS = NMST_OUTTOLUNCH);
  actGlobalHidden.Checked := (GS = NMST_HIDDEN);
end;

procedure TFrmMain.actQuickLoginExecute(Sender: TObject);
var
  Form: TFrmQuickLogin;
begin
  inherited;
  Form := TFrmQuickLogin.CreateAsDialog(Self);
  try
    if Form.ShowModal = mrOk then
      SimpleUICore.LogIn(
          Form.Protocol,
          Form.Account,
          Form.Password,
          Form.Caption,
          Form.Status);
  finally
    Form.Release;
  end;
end;

end.
