unit UFrmList;

interface

uses
  Windows, Classes, Forms, SysUtils, UFrmBaseClient, ActnList, Controls,
  ExtCtrls, StdCtrls, ComCtrls, Graphics, USkinResource, ExSpeedButton, ImgList,
  Math, ExPanel, SimpleTreeView, ExScrollBar, Menus, ToolWin, USimpleUICore,
  UNsmConsts, UStrResource, UFrmBase, UConfig, UWideGraphics, ResizeArea,
  Clipbrd, Messages, UNsmUIPluginMainEx;

type
  TFrmList = class(TFrmBaseClient)
    CoolBar: TCoolBar;
    MenuBar: TToolBar;
    MainMenu: TMainMenu;
    mnuConnect: TMenuItem;
    mnuLogout: TMenuItem;
    actLogOut: TAction;
    pnlMemberList: TExPanel;
    pnlUserStatus: TExPanel;
    TreeView: TSimpleTreeView;
    VScrollBar: TExScrollBar;
    pnlConnectionStatus: TExPanel;
    lblConnectionStatus: TLabel;
    imgConnectionStatus: TImage;
    tmrConnecting: TTimer;
    pmMember: TPopupMenu;
    actSendMessage: TAction;
    mnuSendMessage: TMenuItem;
    actHistory: TAction;
    mnuHistory: TMenuItem;
    N1: TMenuItem;
    pmStatus: TPopupMenu;
    N2: TMenuItem;
    N3: TMenuItem;
    N4: TMenuItem;
    actStatusOnline: TAction;
    actStatusAway: TAction;
    actStatusBusy: TAction;
    actStatusBeRightBack: TAction;
    actStatusOnThePhone: TAction;
    actStatusOutToLunch: TAction;
    actStatusHidden: TAction;
    N5: TMenuItem;
    N8: TMenuItem;
    N9: TMenuItem;
    N10: TMenuItem;
    N6: TMenuItem;
    actChangeUserName: TAction;
    Rename1: TMenuItem;
    actCopyName: TAction;
    actCopyAccount: TAction;
    N7: TMenuItem;
    mnuCopyAccount: TMenuItem;
    mnuCopyName: TMenuItem;
    mnuCommands: TMenuItem;
    actStayOnTop: TAction;
    T1: TMenuItem;
    pmGroup: TPopupMenu;
    N12: TMenuItem;
    actRemoveMember: TAction;
    actAddMember: TAction;
    actAddGroup: TAction;
    actRemoveGroup: TAction;
    actChangeGroupName: TAction;
    A2: TMenuItem;
    N13: TMenuItem;
    R1: TMenuItem;
    N14: TMenuItem;
    mnuAddMember: TMenuItem;
    mnuRemoveMember: TMenuItem;
    actBlockMember: TAction;
    actAllowMember: TAction;
    mnuAllowMember: TMenuItem;
    mnuBlockMember: TMenuItem;
    N15: TMenuItem;
    actPrivacyOption: TAction;
    P1: TMenuItem;
    pmList: TPopupMenu;
    A1: TMenuItem;
    A3: TMenuItem;
    mnuStatus: TMenuItem;
    N11: TMenuItem;
    N16: TMenuItem;
    N17: TMenuItem;
    N18: TMenuItem;
    N19: TMenuItem;
    N20: TMenuItem;
    N21: TMenuItem;
    N22: TMenuItem;
    mnuChangeUserName: TMenuItem;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure TreeViewDblClick(Sender: TObject);
    procedure TreeViewInfoTip(Sender: TObject; Node: TSimpleTreeNode;
      var InfoTip: String);
    procedure VScrollBarChange(Sender: TObject);
    procedure TreeViewCalcScrollInfo(Sender: TObject; AVisibleCount,
      ATopVisibleIndex, APageSize: Integer);
    procedure FormShow(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure actLogOutExecute(Sender: TObject);
    procedure pnlConnectionStatusResize(Sender: TObject);
    procedure tmrConnectingTimer(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure actSendMessageExecute(Sender: TObject);
    procedure actHistoryExecute(Sender: TObject);
    procedure actStatusOnlineExecute(Sender: TObject);
    procedure actStatusAwayExecute(Sender: TObject);
    procedure actStatusBusyExecute(Sender: TObject);
    procedure actStatusBeRightBackExecute(Sender: TObject);
    procedure actStatusOnThePhoneExecute(Sender: TObject);
    procedure actStatusOutToLunchExecute(Sender: TObject);
    procedure actStatusHiddenExecute(Sender: TObject);
    procedure pnlUserStatusMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure pnlUserStatusPaint(Sender: TObject);
    procedure TreeViewExpanded(Sender: TObject; Node: TSimpleTreeNode);
    procedure TreeViewCollapsed(Sender: TObject; Node: TSimpleTreeNode);
    procedure actChangeUserNameExecute(Sender: TObject);
    procedure actCopyNameExecute(Sender: TObject);
    procedure actCopyAccountExecute(Sender: TObject);
    procedure actStayOnTopExecute(Sender: TObject);
    procedure TreeViewContextPopup(Sender: TObject; MousePos: TPoint;
      var Handled: Boolean);
    procedure actPrivacyOptionExecute(Sender: TObject);
    procedure actAddMemberExecute(Sender: TObject);
    procedure actRemoveMemberExecute(Sender: TObject);
    procedure actAddGroupExecute(Sender: TObject);
    procedure actRemoveGroupExecute(Sender: TObject);
    procedure actChangeGroupNameExecute(Sender: TObject);
    procedure actBlockMemberExecute(Sender: TObject);
    procedure actAllowMemberExecute(Sender: TObject);
    procedure pmMemberPopup(Sender: TObject);
    procedure TreeViewMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure TreeViewDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure TreeViewDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure mnuStatusClick(Sender: TObject);
  private
    FAnimPos: Integer;
    FConnection: TNsmUIConnection;
    function BusynessToImageIndex(Busyness: Integer): Integer;
    function GetSelectedMember: TNsmUIMember;
    function GetSelectedGroup: TNsmUIGroup;
    procedure SetConnection(Value: TNsmUIConnection);
  protected
    procedure SetParent(AParent: TWinControl); override;
    procedure UpdateSkinObjects; override;
  public
    procedure UpdateActions; override;  
    procedure ApplyConfig; override;
    procedure UpdateUserStatus;
    procedure UpdateMemberList;
    property Connection: TNsmUIConnection read FConnection write SetConnection;
  end;

implementation

uses UFrmMain, UFrmChat, UFrmNotify, UFrmSession, UFrmHistory, UFrmInput,
  UFrmOption, UFrmPrivacy;

{$R *.dfm}

procedure TFrmList.ApplyConfig;
begin
  inherited;
  // DoubleBuffered
  pnlUserStatus.DoubleBuffered := Config.DoubleBuffered;
  pnlConnectionStatus.DoubleBuffered := Config.DoubleBuffered;
  pnlMemberList.DoubleBuffered := Config.DoubleBuffered;
  // MemberList
  if Assigned(FConnection) then
  begin
    SimpleUICore.SortMemberList(FConnection);
    UpdateMemberList;
  end;
end;

procedure TFrmList.UpdateSkinObjects;
begin
  inherited;
  TreeView.Images := SkinResources.StateImages;
  TreeView.SelectedStyle := SkinResources.GetWindowElementStyle(WindowKind, ssNone, seNone, 'SelectedListItem');
  pnlUserStatus.Height := SkinResources.StateImages.Height + 4;
  pmStatus.Images := SkinResources.StateImages;
  mnuStatus.SubMenuImages := SkinResources.StateImages;
  UpdateUserStatus;
end;
          
procedure TFrmList.UpdateActions;
begin
  inherited;
  actStayOnTop.Checked := StayOnTop;
end;

procedure TFrmList.SetParent(AParent: TWinControl);
begin
  inherited;
  if not Application.Terminated and (ControlCount > 0) then
    CoolBar.Visible := not Assigned(AParent);
end;

function TFrmList.GetSelectedMember: TNsmUIMember;
begin
  if Assigned(TreeView.Selected) and (TreeView.Selected.Level = 1) then
    Result := TNsmUIMember(TreeView.Selected.Data)
  else
    Result := nil;
end;

function TFrmList.GetSelectedGroup: TNsmUIGroup;
begin
  if Assigned(TreeView.Selected) and (TreeView.Selected.Level = 0) then
    Result := TNsmUIGroup(TreeView.Selected.Data)
  else
    Result := nil;
end;

procedure TFrmList.SetConnection(Value: TNsmUIConnection);
begin
  FConnection := Value;
  if Assigned(Value) then
  begin
    actRemoveMember.Enabled :=
        (SimpleUICore.GetService(Format(NMS_PROTOCOL_CONNECTION_REMOVEMEMBER, [FConnection.Protocol])) <> 0);
    actAddMember.Enabled :=
        (SimpleUICore.GetService(Format(NMS_PROTOCOL_CONNECTION_ADDMEMBER, [FConnection.Protocol])) <> 0);
    actAllowMember.Enabled := actRemoveMember.Enabled and actAddMember.Enabled;
    actBlockMember.Enabled := actAllowMember.Enabled;
    actChangeGroupName.Enabled :=
        (SimpleUICore.GetService(Format(NMS_PROTOCOL_CONNECTION_CHANGEGROUPNAME, [FConnection.Protocol])) <> 0);
    actRemoveGroup.Enabled :=
        (SimpleUICore.GetService(Format(NMS_PROTOCOL_CONNECTION_REMOVEGROUP, [FConnection.Protocol])) <> 0);
    actAddGroup.Enabled :=
        (SimpleUICore.GetService(Format(NMS_PROTOCOL_CONNECTION_ADDGROUP, [FConnection.Protocol])) <> 0);
    actChangeUserName.Enabled :=
        (SimpleUICore.GetService(Format(NMS_PROTOCOL_CONNECTION_CHANGEUSERNAME, [FConnection.Protocol])) <> 0);
    mnuStatus.Enabled :=
        (SimpleUICore.GetService(Format(NMS_PROTOCOL_CONNECTION_CHANGEUSERSTATUS, [FConnection.Protocol])) <> 0);
    actStatusOnline.Visible := mnuStatus.Enabled;
    actStatusAway.Visible := mnuStatus.Enabled;
    actStatusBusy.Visible := mnuStatus.Enabled;
    actStatusBeRightBack.Visible := mnuStatus.Enabled;
    actStatusOnThePhone.Visible := mnuStatus.Enabled;
    actStatusOutToLunch.Visible := mnuStatus.Enabled;
    actStatusHidden.Visible := mnuStatus.Enabled;
  end;
end;

function TFrmList.BusynessToImageIndex(Busyness: Integer): Integer;
begin
  Result := -1;
  case Busyness of
  0..33:   Result := 0;
  34..66:  Result := 1;
  67..99:  Result := 2;
  100: Result := 3;
  end;
end;

procedure TFrmList.UpdateUserStatus;
begin
  if Assigned(FConnection) then
  begin
    Caption := Connection.Caption;  
    if FConnection.Status = NMCS_CONNECTED then
    begin
      tmrConnecting.Enabled := False;
      pnlMemberList.Show;
      if TreeView.CanFocus then
        TreeView.SetFocus;
      pnlConnectionStatus.Hide;
      pnlUserStatus.Invalidate;
    end else
    begin
      pnlConnectionStatus.Show;
      pnlMemberList.Hide;
      imgConnectionStatus.Picture.Bitmap.Assign(nil);
      case FConnection.Status of
      NMCS_DISCONNECTED:
      begin
        tmrConnecting.Enabled := False;
        SkinResources.CommonImages.GetBitmap(NMNI_DISCONNECT,
            imgConnectionStatus.Picture.Bitmap);        
        lblConnectionStatus.Caption := RS_NMCS_DISCONNECTED;
      end;
      NMCS_CONNECTING:
      begin
        tmrConnecting.Enabled := True;
        SkinResources.CommonImages.GetBitmap(NMNI_DISCONNECT,
            imgConnectionStatus.Picture.Bitmap);
        lblConnectionStatus.Caption := RS_NMCS_CONNECTING;
      end;
      NMCS_DISCONNECTING:
      begin
        tmrConnecting.Enabled := True;
        SkinResources.CommonImages.GetBitmap(NMNI_DISCONNECT,
            imgConnectionStatus.Picture.Bitmap);
        lblConnectionStatus.Caption := RS_NMCS_DISCONNECTING;
      end;
      end;
      pnlConnectionStatusResize(pnlConnectionStatus);
    end;
  end else
  begin
    tmrConnecting.Enabled := False;  
    pnlConnectionStatus.Show;
    pnlMemberList.Hide;
    imgConnectionStatus.Picture.Bitmap.Assign(nil);
    SkinResources.CommonImages.GetBitmap(NMNI_DISCONNECT,
        imgConnectionStatus.Picture.Bitmap);
    lblConnectionStatus.Caption := RS_NMCS_DISCONNECTED;
    pnlConnectionStatusResize(pnlConnectionStatus);
  end;
end;

procedure TFrmList.UpdateMemberList;
var
  I, TopIdx, SelIdx, Idx: Integer;
  GroupNodes: array of TSimpleTreeNode;
  Node: TSimpleTreeNode;
  Blocked: Boolean;
begin
  if not Visible then Exit;
  if not Assigned(FConnection) then Exit;
  if not (FConnection.Status = NMCS_CONNECTED) then Exit;
  if Assigned(TreeView.TopItem) then
    TopIdx := TreeView.TopItem.VisibleIndex
  else
    TopIdx := -1;
  if Assigned(TreeView.Selected) then
    SelIdx := TreeView.Selected.AbsoluteIndex
  else
    SelIdx := -1;

  TreeView.Items.BeginUpdate;
  try
    TreeView.Items.Clear;
    SetLength(GroupNodes, FConnection.Groups.Count);
    for I := 0 to FConnection.Groups.Count - 1 do
    begin
      Node := TreeView.Items.Add(nil, FConnection.Groups[I].Name);
      GroupNodes[I] := Node;
      with Node do
      begin
        Data := FConnection.Groups[I];
        ImageIndex := 5;
        ExpandedIndex := 6;
        Expanded := FConnection.Groups[I].Expanded;
        Bold := True;
      end;
    end;
    for I := 0 to FConnection.Members.Count - 1 do
    begin
      Blocked := FConnection.Members[I].IsBlocked;
      if (Config.HideOffline and (FConnection.Members[I].Busyness = 100)) or
         (Config.HideBlocked and Blocked) then
        Continue;
      Idx := FConnection.Groups.IndexOfId(FConnection.Members[I].GroupID);
      if Idx > -1 then
      begin
        Node := TreeView.Items.AddChild(GroupNodes[Idx], FConnection.Members[I].Name);
        with Node do
        begin
          Data := FConnection.Members[I];
          OverlayIndex := IfThen(Blocked, 4, -1);
          ImageIndex := BusynessToImageIndex(FConnection.Members[I].Busyness);
          if not (FConnection.Members[I].Status in [NMST_OFFLINE, NMST_ONLINE]) then
            Text := Text + WideFormat(' (%s)', [FConnection.Members[I].StatusStr]);
        end;
      end;
    end;
    if Config.HideEmptyGroup then
      for I := 0 to Length(GroupNodes) - 1 do
        if GroupNodes[I].Count = 0 then
           GroupNodes[I].Delete;
    if (TopIdx > -1) and (TopIdx < TreeView.Items.VisibleCount) then
      TreeView.SetTopVisibleIndex(TopIdx);
    if (SelIdx > -1) and (SelIdx < TreeView.Items.Count) then
      TreeView.Items[SelIdx].Selected := True;
  finally
    TreeView.Items.EndUpdate;
  end;
end;

procedure TFrmList.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  inherited;
  TreeView.Items.Clear;
  actLogOut.Execute;
  Action := caFree;
end;

procedure TFrmList.FormCreate(Sender: TObject);
begin
  inherited;
  WindowKind := wkMain;
  Container := FrmMain;
  FAnimPos := 0;
  pnlConnectionStatus.Align := alClient;
  // SimpleLog Ag
  actHistory.Enabled :=
      (SimpleUICore.GetService(NMS_SIMPLELOG_GETLOGFILENAME) <> 0);
end;

procedure TFrmList.TreeViewDblClick(Sender: TObject);
begin
  inherited;
  actSendMessage.Execute;
end;

procedure TFrmList.TreeViewInfoTip(Sender: TObject; Node: TSimpleTreeNode;
  var InfoTip: String);
begin
  inherited;
  if Node.Level = 0 then
    InfoTip := TNsmUIGroup(Node.Data).Name
  else
    InfoTip := Format(RS_MEMBER_HINT,
      [TNsmUIMember(Node.Data).Name, TNsmUIMember(Node.Data).Account,
       TNsmUIMember(Node.Data).StatusStr]);
end;

procedure TFrmList.VScrollBarChange(Sender: TObject);
begin
  inherited;
  TreeView.SetTopVisibleIndex(VScrollBar.Position);
end;

procedure TFrmList.TreeViewCalcScrollInfo(Sender: TObject; AVisibleCount,
  ATopVisibleIndex, APageSize: Integer);
begin
  inherited;
  if APageSize < AVisibleCount then
  begin
    VScrollBar.Max := AVisibleCount;
    VScrollBar.ThumbSize := APageSize;
    VScrollBar.Show;
  end else
  begin
    VScrollBar.Hide;
  end;
  VScrollBar.Position := ATopVisibleIndex;
end;

procedure TFrmList.FormShow(Sender: TObject);
begin
  inherited;
  UpdateUserStatus;
  UpdateMemberList;  
  if TreeView.CanFocus then
    TreeView.SetFocus;
end;

procedure TFrmList.FormResize(Sender: TObject);
begin
  inherited;
//  pnlBack.Realign;
  pnlMemberList.Realign;
end;

procedure TFrmList.actLogOutExecute(Sender: TObject);
begin
  inherited;
  if Assigned(FConnection) then
    FConnection.LogOut;
end;

procedure TFrmList.pnlConnectionStatusResize(Sender: TObject);
begin
  inherited;
  with pnlConnectionStatus do
  begin
    imgConnectionStatus.Top := (ClientHeight - imgConnectionStatus.Height) div 2;
    lblConnectionStatus.Top := (ClientHeight - lblConnectionStatus.Height) div 2;
    imgConnectionStatus.Left := (ClientWidth - imgConnectionStatus.Width -
        lblConnectionStatus.Width - 2) div 2;
    lblConnectionStatus.Left := imgConnectionStatus.Left +
        imgConnectionStatus.Width + 2;
  end;
end;

procedure TFrmList.tmrConnectingTimer(Sender: TObject);
begin
  inherited;
  imgConnectionStatus.Picture.Bitmap.Assign(nil);
  SkinResources.CommonImages.GetBitmap(NMNI_CONNECT + (FAnimPos mod 2),
      imgConnectionStatus.Picture.Bitmap);
  Inc(FAnimPos);
end;

procedure TFrmList.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
var
  SessionExists: Boolean;
  I: Integer;
begin
  inherited;
  CanClose := True;
  SessionExists := False;
  for I := 0 to SimpleUICore.Sessions.Count - 1 do
    if SimpleUICore.Sessions[I].Connection = FConnection then
    begin
      SessionExists := True;
      Break;
    end;
  if SessionExists then
    CanClose := (MessageBox(Handle,
      'RlNVƁA֘AbEBhE܂B' +
      #13#10'̃RlNVĂ낵łH',
      PChar(String(Caption)), MB_OKCANCEL or MB_ICONEXCLAMATION) = ID_OK);
end;

procedure TFrmList.actSendMessageExecute(Sender: TObject);
var
  SHandle: Cardinal;
  Member: TNsmUIMember;
  I: Integer;
  Form: TFrmSession;
begin
  inherited;
  Member := GetSelectedMember;
  if Assigned(Member) then
  begin
    SHandle := 0;
    for I := 0 to SimpleUICore.Sessions.Count - 1 do
      if (SimpleUICore.Sessions[I].Connection = FConnection) and
         (SimpleUICore.Sessions[I].Members.Count = 1) and
         (SimpleUICore.Sessions[I].Members[0].Account = Member.Account) then
      begin
        SHandle := SimpleUICore.Sessions[I].Handle;
        Break;
      end;
    if SHandle = 0 then
    begin
      SHandle := FConnection.OpenSession(Member.Account);
    end;
    Form := TFrmSession(SimpleUICore.FindSessionWindow(SHandle));
    if Assigned(Form) then
      Form.ShowDocked;
  end;
end;

procedure TFrmList.actHistoryExecute(Sender: TObject);
begin
  inherited;
  if Assigned(TreeView.Selected) and (TreeView.Selected.Level = 1) then
  begin
    ShowHistory(TNsmUIMember(TreeView.Selected.Data));
  end;
end;

procedure TFrmList.actStatusOnlineExecute(Sender: TObject);
begin
  inherited;
  if Assigned(FConnection) then
    FConnection.ChangeUserStatus(NMST_ONLINE);
end;

procedure TFrmList.actStatusAwayExecute(Sender: TObject);
begin
  inherited;
  if Assigned(FConnection) then
    FConnection.ChangeUserStatus(NMST_AWAY);
end;

procedure TFrmList.actStatusBusyExecute(Sender: TObject);
begin
  inherited;
  if Assigned(FConnection) then
    FConnection.ChangeUserStatus(NMST_BUSY);
end;

procedure TFrmList.actStatusBeRightBackExecute(Sender: TObject);
begin
  inherited;
  if Assigned(FConnection) then
    FConnection.ChangeUserStatus(NMST_BERIGHTBACK);
end;

procedure TFrmList.actStatusOnThePhoneExecute(Sender: TObject);
begin
  inherited;
  if Assigned(FConnection) then
    FConnection.ChangeUserStatus(NMST_ONTHEPHONE);
end;

procedure TFrmList.actStatusOutToLunchExecute(Sender: TObject);
begin
  inherited;
  if Assigned(FConnection) then
    FConnection.ChangeUserStatus(NMST_OUTTOLUNCH);
end;

procedure TFrmList.actStatusHiddenExecute(Sender: TObject);
begin
  inherited;
  if Assigned(FConnection) then
    FConnection.ChangeUserStatus(NMST_HIDDEN);
end;

procedure TFrmList.pnlUserStatusMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  P: TPoint;
//  HPopupMenu: HWND;
begin
  inherited;
{
  HPopupMenu := FindWindow('#32768', nil);
  if (HPopupMenu <> 0) and IsWindowVisible(HPopupMenu) then
    PostMessage(HPopupMenu, WM_KEYDOWN, VK_ESCAPE, 0)
  else
  begin
}
    P := pnlUserStatus.ClientToScreen(Point(0, pnlUserStatus.Height));
    pmStatus.Popup(P.X, P.Y);
//  end;
end;

procedure TFrmList.pnlUserStatusPaint(Sender: TObject);
var
  H, T, W: Integer;
  Images: TImageList;
  Text: String;
  R: TRect;
begin
  inherited;
  if not Assigned(FConnection) then Exit;
  with pnlUserStatus.Canvas do
  begin
    Pen.Width := 1;
    Images := SkinResources.StateImages;
    // ACR
    Images.Draw(pnlUserStatus.Canvas, 0,
        (pnlUserStatus.Height - Images.Height) div 2,
        BusynessToImageIndex(FConnection.UserBusyness), True);
    // Op
    Brush.Color := pnlUserStatus.Font.Color;
    Pen.Color := pnlUserStatus.Font.Color;
    T := (pnlUserStatus.Height - 3) div 2;
    W := Images.Width + 2;
    Polygon([Point(W, T), Point(W + 6, T), Point(W + 3, T + 3)]);
    Brush.Color := pnlUserStatus.Color;
    // \
    SetBkMode(Handle, Windows.TRANSPARENT);
    Font.Assign(pnlUserStatus.Font);
    Font.Style := Font.Style + [fsBold];
    H := WideTextHeight(pnlUserStatus.Canvas, 'H');
    T := (pnlUserStatus.Height - H) div 2;
    R.TopLeft := Point(Images.Width + 14, T);
    WideDrawText(pnlUserStatus.Canvas, FConnection.UserName, R,
              DT_CALCRECT or DT_NOPREFIX or DT_SINGLELINE);
    Text := WideFormat(' (%s)', [FConnection.UserStatusStr]);
    W := WideTextWidth(pnlUserStatus.Canvas, Text);
    if (R.Right + W) > pnlUserStatus.Width then
      R.Right := pnlUserStatus.Width - W;
    WideDrawText(pnlUserStatus.Canvas, FConnection.UserName, R,
              DT_END_ELLIPSIS or DT_NOPREFIX or DT_SINGLELINE);
    Font.Style := pnlUserStatus.Font.Style;
    WideTextOut(pnlUserStatus.Canvas, R.Right, R.Top, Text);
  end;
end;

procedure TFrmList.TreeViewExpanded(Sender: TObject;
  Node: TSimpleTreeNode);
begin
  inherited;
  if Node.Level = 0 then
    TNsmUIGroup(Node.Data).Expanded := Node.Expanded;
end;

procedure TFrmList.TreeViewCollapsed(Sender: TObject;
  Node: TSimpleTreeNode);
begin
  inherited;
  if Node.Level = 0 then  
    TNsmUIGroup(Node.Data).Expanded := Node.Expanded;
end;

procedure TFrmList.actChangeUserNameExecute(Sender: TObject);
var
  UserName: WideString;
begin
  inherited;
  UserName := FConnection.UserName;
  if ExInputBox(ParentForm, 'O̕ύX',
      'VO͂ĂB', UserName) then
  begin
    FConnection.ChangeUserName(UserName);
  end;
end;

procedure TFrmList.actCopyNameExecute(Sender: TObject);
var
  Target: TNsmUIMember;
begin
  inherited;
  Target := GetSelectedMember;
  if Assigned(Target) then
  begin
    Clipboard.SetTextBuf(PChar(String(Target.Name)));
  end;
end;

procedure TFrmList.actCopyAccountExecute(Sender: TObject);
var
  Target: TNsmUIMember;
begin
  inherited;
  Target := GetSelectedMember;
  if Assigned(Target) then
  begin
    Clipboard.SetTextBuf(PChar(Target.Account));
  end;
end;

procedure TFrmList.actStayOnTopExecute(Sender: TObject);
begin
  inherited;
  StayOnTop := not StayOnTop;
end;

procedure TFrmList.TreeViewContextPopup(Sender: TObject; MousePos: TPoint;
  var Handled: Boolean);
var
  P: TPoint;
begin
  inherited;
  P := TreeView.ClientToScreen(MousePos);
  if Assigned(TreeView.Selected) and (TreeView.Selected.Level = 0) then
    pmGroup.Popup(P.X, P.Y)
  else
  if Assigned(TreeView.Selected) then
    pmMember.Popup(P.X, P.Y)
  else
    pmList.Popup(P.X, P.Y);
end;

procedure TFrmList.actPrivacyOptionExecute(Sender: TObject);
begin
  inherited;
  with TFrmPrivacy.CreateAsDialog(ParentForm) do
  begin
    Connection := FConnection;
    ShowModal;
  end;
end;

procedure TFrmList.actAddMemberExecute(Sender: TObject);
var
  Account: WideString;
begin
  inherited;
  if ExInputBox(ParentForm, 'o̒ǉ',
        'ǉõAJEg͂ĂB', Account) then
  begin
    FConnection.AddMember(Account, NMLK_FORWARDLIST);
  end;
end;

procedure TFrmList.actRemoveMemberExecute(Sender: TObject);
var
  Target: TNsmUIMember;
begin
  inherited;
  Target := GetSelectedMember;
  if Assigned(Target) then
  begin
    if MessageBox(Handle, PChar('"' + String(Target.Name) +
        '" oXg폜Ă낵łH'), 'o̍폜',
        MB_ICONQUESTION or MB_OKCANCEL) = ID_OK then
      FConnection.RemoveMember(Target.Account, NMLK_FORWARDLIST);
  end;
end;

procedure TFrmList.actAddGroupExecute(Sender: TObject);
var
  GroupName: WideString;
begin
  inherited;
  GroupName := 'VO[v';
  if ExInputBox(ParentForm, 'O[v̒ǉ',
        'ǉO[v̖O͂ĂB', GroupName) then
  begin
    FConnection.AddGroup(GroupName);
  end;
end;

procedure TFrmList.actRemoveGroupExecute(Sender: TObject);
var
  Target: TNsmUIGroup;
begin
  inherited;
  Target := GetSelectedGroup;
  if Assigned(Target) then
  begin
    if MessageBox(Handle, PChar('"' + String(Target.Name) +
        '" oXg폜Ă낵łH'), 'O[v̍폜',
        MB_ICONQUESTION or MB_OKCANCEL) = ID_OK then
    FConnection.RemoveGroup(Target.Id);
  end;
end;

procedure TFrmList.actChangeGroupNameExecute(Sender: TObject);
var
  Target: TNsmUIGroup;
  GroupName: WideString;
begin
  inherited;
  Target := GetSelectedGroup;
  if Assigned(Target) then
  begin
    GroupName := Target.Name;
    if ExInputBox(ParentForm, 'O[v̕ύX',
          'VO[v͂ĂB', GroupName) then
    FConnection.ChangeGroupName(Target.Id, GroupName);
  end;
end;

procedure TFrmList.actBlockMemberExecute(Sender: TObject);
var
  Target: TNsmUIMember;
begin
  inherited;
  Target := GetSelectedMember;
  if Assigned(Target) then
  begin
    if FConnection.AllowMembers.Contains(Target.Account) then
      FConnection.RemoveMember(Target.Account, NMLK_ALLOWLIST);
    if not FConnection.BlockMembers.Contains(Target.Account) then
      FConnection.AddMember(Target.Account, NMLK_BLOCKLIST);
  end;
end;

procedure TFrmList.actAllowMemberExecute(Sender: TObject);
var
  Target: TNsmUIMember;
begin
  inherited;
  Target := GetSelectedMember;
  if Assigned(Target) then
  begin
    if FConnection.BlockMembers.Contains(Target.Account) then
      FConnection.RemoveMember(Target.Account, NMLK_BLOCKLIST);
    if not FConnection.AllowMembers.Contains(Target.Account) then
      FConnection.AddMember(Target.Account, NMLK_ALLOWLIST);
  end;
end;

procedure TFrmList.pmMemberPopup(Sender: TObject);
var
  Member: TNsmUIMember;
begin
  inherited;
  Member := GetSelectedMember;
  if Assigned(Member) then
  begin
    actBlockMember.Visible := not Member.IsBlocked;
    actAllowMember.Visible := Member.IsBlocked
  end;
end;

procedure TFrmList.TreeViewMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  inherited;
  if (Button = mbLeft) and (GetSelectedMember <> nil) then
    TreeView.BeginDrag(False, -1);
end;

procedure TFrmList.TreeViewDragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
  inherited;
  Accept := True;//(Source = TreeView);
end;

procedure TFrmList.TreeViewDragDrop(Sender, Source: TObject; X,
  Y: Integer);
var
  Node: TSimpleTreeNode;
  Target: TNsmUIMember;
  NewGroup: Integer;
begin
  inherited;
  Target := GetSelectedMember;
  if Assigned(Target) then
  begin
    NewGroup := Target.GroupID;
    Node := TreeView.GetNodeAt(X, Y);
    if Assigned(Node) and (Node.Level = 1) then
      NewGroup := TNsmUIMember(Node.Data).GroupID
    else if Assigned(Node) then
      NewGroup := TNsmUIGroup(Node.Data).Id;
    if Target.GroupID <> NewGroup then
      FConnection.ChangeMemberGroup(Target.Account, NewGroup);
  end;
end;

procedure TFrmList.mnuStatusClick(Sender: TObject);
var
  Status: Integer;
begin
  inherited;
  if Assigned(FConnection) then
    Status := FConnection.UserStatus
  else
    Status := -1;
  actStatusOnline.Checked := (Status = NMST_ONLINE);
  actStatusAway.Checked := (Status = NMST_AWAY);
  actStatusBusy.Checked := (Status = NMST_BUSY);
  actStatusBeRightBack.Checked := (Status = NMST_BERIGHTBACK);
  actStatusOnThePhone.Checked := (Status = NMST_ONTHEPHONE);
  actStatusOutToLunch.Checked := (Status = NMST_OUTTOLUNCH);
  actStatusHidden.Checked := (Status = NMST_HIDDEN);
end;

end.
