unit UNsmUIPluginMain;

interface

uses
  Windows, SysUtils, UNsmConsts, UNsmTypes, UNsmPluginMain;

type
  TNsmUIPluginMain = class(TNsmPluginMain)
  private
  protected
    procedure DoInitialize; override;
    procedure DoAllModulesLoaded; override;

    procedure DoCreateConnection(AHandle: HNsmConnection; lParam: Cardinal); virtual;
    procedure DoDeleteConnection(AHandle: HNsmConnection; lParam: Cardinal); virtual;
    procedure DoConnectionChange; virtual;
    procedure DoConnectionInfoChange(AHandle: HNsmConnection; lParam: Cardinal); virtual;
    procedure DoAddMember(AHandle: HNsmConnection; AMInfo: TAddMemberInfo); virtual;
    procedure DoRemoveMember(AHandle: HNsmConnection; RMInfo: TRemoveMemberInfo); virtual;
    procedure DoMemberChange(AHandle: HNsmConnection); virtual;
    procedure DoMemberInfoChange(AHandle: HNsmConnection; lParam: Cardinal); virtual;
    procedure DoMemberInfoChanging(AHandle: HNsmConnection; lParam: Cardinal); virtual;
    procedure DoAddGroup(AHandle: HNsmConnection; GroupID: Integer); virtual;
    procedure DoRemoveGroup(AHandle: HNsmConnection; GroupID: Integer); virtual;
    procedure DoGroupChange(AHandle: HNsmConnection); virtual;
    procedure DoGroupInfoChange(AHandle: HNsmConnection; lParam: Cardinal); virtual;
    procedure DoCreateSession(AHandle: HNsmSession; lParam: Cardinal); virtual;
    procedure DoDeleteSession(AHandle: HNsmSession; lParam: Cardinal); virtual;
    procedure DoSessionChange; virtual;
    procedure DoSessionInfoChange(AHandle: HNsmSession; lParam: Cardinal); virtual;
    procedure DoSessionAddMember(AHandle: HNsmSession; Account: String); virtual;
    procedure DoSessionRemoveMember(AHandle: HNsmSession; Account: String); virtual;
    procedure DoSessionMemberChange(AHandle: HNsmSession); virtual;
    procedure DoSessionMemberInfoChange(AHandle: HNsmSession; lParam: Cardinal); virtual;
    procedure DoSessionSendMessage(AHandle: HNsmSession; lParam: Cardinal); virtual;
    procedure DoSessionReceiveMessage(AHandle: HNsmSession; lParam: Cardinal); virtual;
    procedure DoNotify(NInfo: TNotifyInfo; var Result: Integer); virtual;
    procedure DoMessageBox(MBInfo: TMessageBoxInfo; var Result: Integer); virtual;
    procedure DoShowOptionDialog(hWnd: HWND; var Result: Integer); virtual;
  public
    constructor Create; override;
    destructor Destroy; override;
  end;

implementation

var
  UIPluginMain: TNsmUIPluginMain;

function _OnCreateConnection(wParam, lParam: Cardinal): Integer; Stdcall; forward;
function _OnDeleteConnection(wParam, lParam: Cardinal): Integer; Stdcall; forward;
function _OnConnectionInfoChange(wParam, lParam: Cardinal): Integer; Stdcall; forward;
function _OnAddMember(wParam, lParam: Cardinal): Integer; Stdcall; forward;
function _OnRemoveMember(wParam, lParam: Cardinal): Integer; Stdcall; forward;
function _OnMemberInfoChange(wParam, lParam: Cardinal): Integer; Stdcall; forward;
function _OnMemberInfoChanging(wParam, lParam: Cardinal): Integer; Stdcall; forward;
function _OnAddGroup(wParam, lParam: Cardinal): Integer; Stdcall; forward;
function _OnRemoveGroup(wParam, lParam: Cardinal): Integer; Stdcall; forward;
function _OnGroupInfoChange(wParam, lParam: Cardinal): Integer; Stdcall; forward;

function _OnCreateSession(wParam, lParam: Cardinal): Integer; Stdcall; forward;
function _OnDeleteSession(wParam, lParam: Cardinal): Integer; Stdcall; forward;
function _OnSessionInfoChange(wParam, lParam: Cardinal): Integer; Stdcall; forward;
function _OnSessionAddMember(wParam, lParam: Cardinal): Integer; Stdcall; forward;
function _OnSessionRemoveMember(wParam, lParam: Cardinal): Integer; Stdcall; forward;
function _OnSessionMemberInfoChange(wParam, lParam: Cardinal): Integer; Stdcall; forward;
function _OnSessionSendMessage(wParam, lParam: Cardinal): Integer; Stdcall; forward;
function _OnSessionReceiveMessage(wParam, lParam: Cardinal): Integer; Stdcall; forward;

function _DoMessageBox(wParam, lParam: Cardinal): Integer; Stdcall; forward;
function _DoNotify(wParam, lParam: Cardinal): Integer; Stdcall; forward;
function _DoShowOptionDialog(wParam, lParam: Cardinal): Integer; Stdcall; forward;

// TNsmUIPluginMain ------------------------------------------------------------

constructor TNsmUIPluginMain.Create;
begin
  inherited;
  if NsmPluginMain = Self then
    UIPluginMain := Self;
end;

destructor TNsmUIPluginMain.Destroy;
begin
  if UIPluginMain = Self then
    UIPluginMain := nil;
  inherited;
end;

procedure TNsmUIPluginMain.DoInitialize;
begin
  inherited;
  CreateService(NMS_UI_NOTIFY, _DoNotify);
  CreateService(NMS_UI_MESSAGEBOX, _DoMessageBox);
  CreateService(Format(NMS_COMMON_SHOWOPTIONDIALOG, [NMM_UI]), _DoShowOptionDialog);
end;

procedure TNsmUIPluginMain.DoAllModulesLoaded;
begin
  inherited;
  HookEvent(NME_SYSTEM_CONNECTION_CONNECT, _OnCreateConnection);
  HookEvent(NME_SYSTEM_CONNECTION_DISCONNECT, _OnDeleteConnection);
  HookEvent(NME_SYSTEM_CONNECTION_INFOCHANGE, _OnConnectionInfoChange);
  HookEvent(NME_SYSTEM_CONNECTION_MEMBERS_ADD, _OnAddMember);
  HookEvent(NME_SYSTEM_CONNECTION_MEMBERS_REMOVE, _OnRemoveMember);
  HookEvent(NME_SYSTEM_CONNECTION_MEMBERS_INFOCHANGE, _OnMemberInfoChange);
  HookEvent(NME_SYSTEM_CONNECTION_MEMBERS_INFOCHANGING, _OnMemberInfoChanging);
  HookEvent(NME_SYSTEM_CONNECTION_GROUPS_ADD, _OnAddGroup);
  HookEvent(NME_SYSTEM_CONNECTION_GROUPS_REMOVE, _OnRemoveGroup);
  HookEvent(NME_SYSTEM_CONNECTION_GROUPS_INFOCHANGE, _OnGroupInfoChange);
  HookEvent(NME_SYSTEM_SESSION_OPEN, _OnCreateSession);
  HookEvent(NME_SYSTEM_SESSION_CLOSE, _OnDeleteSession);
  HookEvent(NME_SYSTEM_SESSION_INFOCHANGE, _OnSessionInfoChange);
  HookEvent(NME_SYSTEM_SESSION_MEMBERS_ADD, _OnSessionAddMember);
  HookEvent(NME_SYSTEM_SESSION_MEMBERS_REMOVE, _OnSessionRemoveMember);
  HookEvent(NME_SYSTEM_SESSION_MEMBERS_INFOCHANGE, _OnSessionMemberInfoChange);
  HookEvent(NME_SYSTEM_SESSION_SENDMESSAGE, _OnSessionSendMessage);
  HookEvent(NME_SYSTEM_SESSION_RECEIVEMESSAGE, _OnSessionReceiveMessage);
end;

procedure TNsmUIPluginMain.DoCreateConnection(AHandle: HNsmConnection; lParam: Cardinal);
begin
end;

procedure TNsmUIPluginMain.DoDeleteConnection(AHandle: HNsmConnection; lParam: Cardinal);
begin
end;

procedure TNsmUIPluginMain.DoConnectionChange;
begin
end;

procedure TNsmUIPluginMain.DoConnectionInfoChange(AHandle: HNsmConnection; lParam: Cardinal);
begin
end;

procedure TNsmUIPluginMain.DoAddMember(AHandle: HNsmConnection; AMInfo: TAddMemberInfo);
begin
end;

procedure TNsmUIPluginMain.DoRemoveMember(AHandle: HNsmConnection; RMInfo: TRemoveMemberInfo);
begin
end;

procedure TNsmUIPluginMain.DoMemberChange(AHandle: HNsmConnection);
begin
end;

procedure TNsmUIPluginMain.DoMemberInfoChange(AHandle: HNsmConnection; lParam: Cardinal);
begin
end;

procedure TNsmUIPluginMain.DoMemberInfoChanging(AHandle: HNsmConnection; lParam: Cardinal);
begin
end;

procedure TNsmUIPluginMain.DoAddGroup(AHandle: HNsmConnection; GroupID: Integer);
begin
end;

procedure TNsmUIPluginMain.DoRemoveGroup(AHandle: HNsmConnection; GroupID: Integer);
begin
end;

procedure TNsmUIPluginMain.DoGroupChange(AHandle: HNsmConnection);
begin
end;

procedure TNsmUIPluginMain.DoGroupInfoChange(AHandle: HNsmConnection; lParam: Cardinal);
begin
end;

procedure TNsmUIPluginMain.DoCreateSession(AHandle: HNsmSession; lParam: Cardinal);
begin
end;

procedure TNsmUIPluginMain.DoDeleteSession(AHandle: HNsmSession; lParam: Cardinal);
begin
end;

procedure TNsmUIPluginMain.DoSessionChange;
begin
end;

procedure TNsmUIPluginMain.DoSessionInfoChange(AHandle: HNsmSession; lParam: Cardinal);
begin
end;

procedure TNsmUIPluginMain.DoSessionAddMember(AHandle: HNsmSession; Account: String);
begin
end;

procedure TNsmUIPluginMain.DoSessionRemoveMember(AHandle: HNsmSession; Account: String);
begin
end;

procedure TNsmUIPluginMain.DoSessionMemberChange(AHandle: HNsmSession);
begin
end;

procedure TNsmUIPluginMain.DoSessionMemberInfoChange(AHandle: HNsmSession; lParam: Cardinal);
begin
end;

procedure TNsmUIPluginMain.DoSessionSendMessage(AHandle: HNsmSession; lParam: Cardinal);
begin
end;

procedure TNsmUIPluginMain.DoSessionReceiveMessage(AHandle: HNsmSession; lParam: Cardinal);
begin
end;

procedure TNsmUIPluginMain.DoNotify(NInfo: TNotifyInfo; var Result: Integer);
begin
end;

procedure TNsmUIPluginMain.DoMessageBox(MBInfo: TMessageBoxInfo; var Result: Integer);
begin
end;

procedure TNsmUIPluginMain.DoShowOptionDialog(hWnd: HWND; var Result: Integer);
begin
end;

// -----------------------------------------------------------------------------

// RlNV쐬Cxg
function _OnCreateConnection(wParam, lParam: Cardinal): Integer; Stdcall;
begin
  UIPluginMain.DoCreateConnection(wParam, lParam);
  UIPluginMain.DoConnectionChange;
  Result := 0;
end;

// RlNV폜Cxg
function _OnDeleteConnection(wParam, lParam: Cardinal): Integer; Stdcall;
begin
  UIPluginMain.DoDeleteConnection(wParam, lParam);
  UIPluginMain.DoConnectionChange;
  Result := 0;
end;

// RlNVύXCxg
function _OnConnectionInfoChange(wParam, lParam: Cardinal): Integer; Stdcall;
begin
  UIPluginMain.DoConnectionInfoChange(wParam, lParam);
  Result := 0;
end;

// oǉCxg
function _OnAddMember(wParam, lParam: Cardinal): Integer; Stdcall;
begin
  UIPluginMain.DoAddMember(wParam, PAddMemberInfo(lParam)^);
  UIPluginMain.DoMemberChange(wParam);
  Result := 0;
end;

// o폜Cxg
function _OnRemoveMember(wParam, lParam: Cardinal): Integer; Stdcall;
begin
  UIPluginMain.DoRemoveMember(wParam, PRemoveMemberInfo(lParam)^);
  UIPluginMain.DoMemberChange(wParam);
  Result := 0;
end;

// oύXCxg
function _OnMemberInfoChange(wParam, lParam: Cardinal): Integer; Stdcall;
begin
  UIPluginMain.DoMemberInfoChange(wParam, lParam);
  Result := 0;
end;

// oύXOCxg
function _OnMemberInfoChanging(wParam, lParam: Cardinal): Integer; Stdcall;
begin
  UIPluginMain.DoMemberInfoChanging(wParam, lParam);
  Result := 0;
end;

// O[vǉCxg
function _OnAddGroup(wParam, lParam: Cardinal): Integer; Stdcall;
begin
  UIPluginMain.DoAddGroup(wParam, lParam);
  UIPluginMain.DoGroupChange(wParam);
  Result := 0;
end;

// O[v폜Cxg
function _OnRemoveGroup(wParam, lParam: Cardinal): Integer; Stdcall;
begin
  UIPluginMain.DoRemoveGroup(wParam, lParam);
  UIPluginMain.DoGroupChange(wParam);
  Result := 0;
end;

// O[vύXCxg
function _OnGroupInfoChange(wParam, lParam: Cardinal): Integer; Stdcall;
begin
  UIPluginMain.DoGroupInfoChange(wParam, lParam);
  Result := 0;
end;

// ZbV쐬Cxg
function _OnCreateSession(wParam, lParam: Cardinal): Integer; Stdcall;
begin
  UIPluginMain.DoCreateSession(wParam, lParam);
  UIPluginMain.DoSessionChange;
  Result := 0;
end;

function _OnDeleteSession(wParam, lParam: Cardinal): Integer; Stdcall;
begin
  UIPluginMain.DoDeleteSession(wParam, lParam);
  UIPluginMain.DoSessionChange;
  Result := 0;
end;

function _OnSessionInfoChange(wParam, lParam: Cardinal): Integer; Stdcall;
begin
  UIPluginMain.DoSessionInfoChange(wParam, lParam);
  Result := 0;
end;

function _OnSessionAddMember(wParam, lParam: Cardinal): Integer; Stdcall;
begin
  UIPluginMain.DoSessionAddMember(wParam, PChar(lParam));
  UIPluginMain.DoSessionMemberChange(wParam);
  Result := 0;
end;

function _OnSessionRemoveMember(wParam, lParam: Cardinal): Integer; Stdcall;
begin
  UIPluginMain.DoSessionRemoveMember(wParam, PChar(lParam));
  UIPluginMain.DoSessionMemberChange(wParam);
  Result := 0;
end;

function _OnSessionMemberInfoChange(wParam, lParam: Cardinal): Integer; Stdcall;
begin
  UIPluginMain.DoSessionMemberInfoChange(wParam, lParam);
  Result := 0;
end;

function _OnSessionSendMessage(wParam, lParam: Cardinal): Integer; Stdcall;
begin
  UIPluginMain.DoSessionSendMessage(wParam, lParam);
  Result := 0;
end;

function _OnSessionReceiveMessage(wParam, lParam: Cardinal): Integer; Stdcall;
begin
  UIPluginMain.DoSessionReceiveMessage(wParam, lParam);
  Result := 0;
end;

// bZ[W{bNXT[rX
function _DoMessageBox(wParam, lParam: Cardinal): Integer; Stdcall;
begin
  Result := 0;
  UIPluginMain.DoMessageBox(PMessageBoxInfo(wParam)^, Result);
end;

// ʒmEBhE\T[rX
function _DoNotify(wParam, lParam: Cardinal): Integer; Stdcall;
begin
  Result := 0;
  UIPluginMain.DoNotify(PNotifyInfo(wParam)^, Result);
end;

// IvV_CAO\T[rX
function _DoShowOptionDialog(wParam, lParam: Cardinal): Integer; Stdcall;
begin
  Result := 0;
  UIPluginMain.DoShowOptionDialog(wParam, Result);
end;

end.
 