unit UNsmProtocolPluginMain;

interface

uses
  Windows, SysUtils, UNsmConsts, UNsmTypes, UNsmPluginMain;

type
  TNsmProtocolPluginMain = class(TNsmPluginMain)
  private
  protected
    procedure DoInitialize; override;

    function DoShowOptionDialog(Parent: HWND): Integer; virtual;
    function DoConnect(LoginInfo: TLogInInfo): Integer; virtual;
    function DoDisconnect(CHandle: HNsmConnection): Integer; virtual;
    function DoOpenSession(CHandle: HNsmConnection; OSInfo: TOpenSessionInfo): Integer; virtual;
    function DoCloseSession(SHandle: HNsmSession): Integer; virtual;
    function DoInviteMember(SHandle: HNsmSession; Account: String): Integer; virtual;
    function DoSendMessage(SHandle: HNsmSession; MsgInfo: TMessageInfo): Integer; virtual;
    function DoChangeStatus(CHandle: HNsmConnection; StatusInfo: TUserStatusInfo): Integer; virtual;
    function DoChangeUserName(CHandle: HNsmConnection; NameInfo: TUserNameInfo): Integer; virtual;
    function DoAddMember(CHandle: HNsmConnection; AddMemberInfo: TAddMemberInfo): Integer; virtual;
    function DoRemoveMember(CHandle: HNsmConnection; RemoveMemberInfo: TRemoveMemberInfo): Integer; virtual;
    function DoChangeMemberGroup(CHandle: HNsmConnection; MemberGroupInfo: TMemberGroupInfo): Integer; virtual;
    function DoAddGroup(CHandle: HNsmConnection; GroupName: WideString): Integer; virtual;
    function DoRemoveGroup(CHandle: HNsmConnection; GroupId: Integer): Integer; virtual;
    function DoChangeGroupName(CHandle: HNsmConnection; GroupNameInfo: TGroupNameInfo): Integer; virtual;
  public
    constructor Create; override;
    destructor Destroy; override;
  end;

implementation

var
  ProtocolPluginMain: TNsmProtocolPluginMain;

function _DoShowOptionDialog(wParam, lParam: Cardinal): Integer; Stdcall; forward;
function _DoConnect(wParam, lParam: Cardinal): Integer; Stdcall; forward;
function _DoDisconnect(wParam, lParam: Cardinal): Integer; Stdcall; forward;
function _DoOpenSession(wParam, lParam: Cardinal): Integer; Stdcall; forward;
function _DoCloseSession(wParam, lParam: Cardinal): Integer; Stdcall; forward;
function _DoChangeUserStatus(wParam, lParam: Cardinal): Integer; Stdcall; forward;
function _DoChangeUserName(wParam, lParam: Cardinal): Integer; Stdcall; forward;
function _DoAddMember(wParam, lParam: Cardinal): Integer; Stdcall; forward;
function _DoRemoveMember(wParam, lParam: Cardinal): Integer; Stdcall; forward;
function _DoChangeMemberGroup(wParam, lParam: Cardinal): Integer; Stdcall; forward;
function _DoAddGroup(wParam, lParam: Cardinal): Integer; Stdcall; forward;
function _DoRemoveGroup(wParam, lParam: Cardinal): Integer; Stdcall; forward;
function _DoChangeGroupName(wParam, lParam: Cardinal): Integer; Stdcall; forward;
function _DoInviteMember(wParam, lParam: Cardinal): Integer; Stdcall; forward;
function _DoSendMessage(wParam, lParam: Cardinal): Integer; Stdcall; forward;

// TNsmPluginMain --------------------------------------------------------------

constructor TNsmProtocolPluginMain.Create;
begin
  inherited;
  if NsmPluginMain = Self then
    ProtocolPluginMain := Self;
end;

destructor TNsmProtocolPluginMain.Destroy;
begin
  if ProtocolPluginMain = Self then
    ProtocolPluginMain := nil;
  inherited;
end;

procedure TNsmProtocolPluginMain.DoInitialize;
var
  ModuleName, ProtocolName: String;
begin
  inherited;
  ModuleName := PluginInfo[NMPI_MODULENAME];
  ProtocolName := Copy(ModuleName, Length(NMM_PROTOCOL) + 2, Length(ModuleName));

  CreateService(Format(NMS_COMMON_SHOWOPTIONDIALOG, [ModuleName]),
      _DoShowOptionDialog);
  CreateService(Format(NMS_PROTOCOL_CONNECTION_CONNECT, [ProtocolName]),
      _DoConnect);
  CreateService(Format(NMS_PROTOCOL_CONNECTION_DISCONNECT, [ProtocolName]),
      _DoDisconnect);
  CreateService(Format(NMS_PROTOCOL_SESSION_OPEN, [ProtocolName]),
      _DoOpenSession);
  CreateService(Format(NMS_PROTOCOL_SESSION_CLOSE, [ProtocolName]),
      _DoCloseSession);
  CreateService(Format(NMS_PROTOCOL_SESSION_INVITEMEMBER, [ProtocolName]),
      _DoInviteMember);
  CreateService(Format(NMS_PROTOCOL_SESSION_SENDMESSAGE, [ProtocolName]),
      _DoSendMessage);
  CreateService(Format(NMS_PROTOCOL_CONNECTION_CHANGEUSERSTATUS, [ProtocolName]),
      _DoChangeUserStatus);
  CreateService(Format(NMS_PROTOCOL_CONNECTION_CHANGEUSERNAME, [ProtocolName]),
      _DoChangeUserName);
  CreateService(Format(NMS_PROTOCOL_CONNECTION_ADDMEMBER, [ProtocolName]),
      _DoAddMember);
  CreateService(Format(NMS_PROTOCOL_CONNECTION_REMOVEMEMBER, [ProtocolName]),
      _DoRemoveMember);
  CreateService(Format(NMS_PROTOCOL_CONNECTION_CHANGEMEMBERGROUP, [ProtocolName]),
      _DoCHangeMemberGroup);
  CreateService(Format(NMS_PROTOCOL_CONNECTION_ADDGROUP, [ProtocolName]),
      _DoAddGroup);
  CreateService(Format(NMS_PROTOCOL_CONNECTION_REMOVEGROUP, [ProtocolName]),
      _DoRemoveGroup);
  CreateService(Format(NMS_PROTOCOL_CONNECTION_CHANGEGROUPNAME, [ProtocolName]),
      _DoChangeGroupName);
end;

function TNsmProtocolPluginMain.DoShowOptionDialog(Parent: HWND): Integer;
begin
  Result := 0;
end;

function TNsmProtocolPluginMain.DoConnect(LoginInfo: TLogInInfo): Integer;
begin
  Result := 0;
end;

function TNsmProtocolPluginMain.DoDisconnect(CHandle: HNsmConnection): Integer;
begin
  Result := 0;
end;

function TNsmProtocolPluginMain.DoOpenSession(CHandle: HNsmConnection; OSInfo: TOpenSessionInfo): Integer;
begin
  Result := 0;
end;

function TNsmProtocolPluginMain.DoCloseSession(SHandle: HNsmSession): Integer;
begin
  Result := 0;
end;

function TNsmProtocolPluginMain.DoInviteMember(SHandle: HNsmSession; Account: String): Integer;
begin
  Result := 0;
end;

function TNsmProtocolPluginMain.DoSendMessage(SHandle: HNsmSession; MsgInfo: TMessageInfo): Integer;
begin
  Result := 0;
end;

function TNsmProtocolPluginMain.DoChangeStatus(CHandle: HNsmConnection; StatusInfo: TUserStatusInfo): Integer;
begin
  Result := 0;
end;

function TNsmProtocolPluginMain.DoChangeUserName(CHandle: HNsmConnection; NameInfo: TUserNameInfo): Integer;
begin
  Result := 0;
end;

function TNsmProtocolPluginMain.DoAddMember(CHandle: HNsmConnection; AddMemberInfo: TAddMemberInfo): Integer;
begin
  Result := 0;
end;

function TNsmProtocolPluginMain.DoRemoveMember(CHandle: HNsmConnection; RemoveMemberInfo: TRemoveMemberInfo): Integer;
begin
  Result := 0;
end;

function TNsmProtocolPluginMain.DoChangeMemberGroup(CHandle: HNsmConnection; MemberGroupInfo: TMemberGroupInfo): Integer;
begin
  Result := 0;
end;

function TNsmProtocolPluginMain.DoAddGroup(CHandle: HNsmConnection; GroupName: WideString): Integer;
begin
  Result := 0;
end;

function TNsmProtocolPluginMain.DoRemoveGroup(CHandle: HNsmConnection; GroupId: Integer): Integer;
begin
  Result := 0;
end;

function TNsmProtocolPluginMain.DoChangeGroupName(CHandle: HNsmConnection; GroupNameInfo: TGroupNameInfo): Integer;
begin
  Result := 0;
end;

// -----------------------------------------------------------------------------

//  wParam  : HWND
//  lParam  : 0
//  Return  : ID_OK, ID_CANCEL
function _DoShowOptionDialog(wParam, lParam: Cardinal): Integer; Stdcall;
begin
  Result := ProtocolPluginMain.DoShowOptionDialog(wParam);
end;

//  wParam  : LPLPGININFO
//  lParam  : 0
//  Return  : ConnectionID
function _DoConnect(wParam, lParam: Cardinal): Integer; Stdcall;
begin
  Result := ProtocolPluginMain.DoConnect(PLoginInfo(wParam)^);
end;

//  wParam  : ConnectionID
//  lParam  : 0
//  Return  :  0 ȊOԂ
function _DoDisconnect(wParam, lParam: Cardinal): Integer; Stdcall;
begin
  Result := ProtocolPluginMain.DoDisconnect(wParam);
end;

//  wParam  : ConnectionID
//  lParam  : POpenSessionInfo
//  Return  : SessionID
function _DoOpenSession(wParam, lParam: Cardinal): Integer; Stdcall;
begin
  Result := ProtocolPluginMain.DoOpenSession(wParam, POpenSessionInfo(lParam)^);
end;

//  wParam  : SessionID
//  lParam  : 0
//  Return  :  0 ȊOԂ
function _DoCloseSession(wParam, lParam: Cardinal): Integer; Stdcall;
begin
  Result := ProtocolPluginMain.DoCloseSession(wParam);
end;

//  wParam  : SessionID
//  lParam  : PChar
//  Return  :  0 ȊOԂ
function _DoInviteMember(wParam, lParam: Cardinal): Integer; Stdcall;
begin
  Result := ProtocolPluginMain.DoInviteMember(wParam, PChar(lParam));
end;

//  wParam  : SessionID
//  lParam  : PMessageInfo
//  Return  :  0 ȊOԂ
function _DoSendMessage(wParam, lParam: Cardinal): Integer; Stdcall;
begin
  Result := ProtocolPluginMain.DoSendMessage(wParam, PMessageInfo(lParam)^)
end;

//  wParam  : ConnectionID
//  lParam  : PUserStatusInfo
//  Return  :  0 ȊOԂ
function _DoChangeUserStatus(wParam, lParam: Cardinal): Integer; Stdcall;
begin
  Result := ProtocolPluginMain.DoChangeStatus(wParam, PUserStatusInfo(lParam)^);
end;

//  wParam  : ConnectionID
//  lParam  : PUserNameInfo
//  Return  :  0 ȊOԂ
function _DoChangeUserName(wParam, lParam: Cardinal): Integer; Stdcall;
begin
  Result := ProtocolPluginMain.DoChangeUserName(wParam, PUserNameInfo(lParam)^);
end;

//  wParam  : HConnection
//  lParam  : PAddMemberInfo
//  Return  :  0 ȊOԂ
function _DoAddMember(wParam, lParam: Cardinal): Integer; Stdcall;
begin
  Result := ProtocolPluginMain.DoAddMember(wParam, PAddMemberInfo(lParam)^);
end;

//  wParam  : HConnection
//  lParam  :
//  Return  :  0 ȊOԂ
function _DoRemoveMember(wParam, lParam: Cardinal): Integer; Stdcall;
begin
  Result := ProtocolPluginMain.DoRemoveMember(wParam, PRemoveMemberInfo(lParam)^);
end;

//  wParam  : HConnection
//  lParam  :
//  Return  :  0 ȊOԂ
function _DoChangeMemberGroup(wParam, lParam: Cardinal): Integer; Stdcall;
begin
  Result := ProtocolPluginMain.DoChangeMemberGroup(wParam, PMemberGroupInfo(lParam)^);
end;

//  wParam  : HConnection
//  lParam  :
//  Return  :  0 ȊOԂ
function _DoAddGroup(wParam, lParam: Cardinal): Integer; Stdcall;
begin
  Result := ProtocolPluginMain.DoAddGroup(wParam, PWideChar(lParam));
end;

//  wParam  : HConnection
//  lParam  :
//  Return  :  0 ȊOԂ
function _DoRemoveGroup(wParam, lParam: Cardinal): Integer; Stdcall;
begin
  Result := ProtocolPluginMain.DoRemoveGroup(wParam, lParam);
end;

//  wParam  : HConnection
//  lParam  :
//  Return  :  0 ȊOԂ
function _DoChangeGroupName(wParam, lParam: Cardinal): Integer; Stdcall;
begin
  Result := ProtocolPluginMain.DoChangeGroupName(wParam, PGroupNameInfo(lParam)^);
end;

end.
