unit MinApp;
(* Copyright (C) 2001-2003 Yamaneko <ymnk160@hotmail.com> *)
(* ^ Application IuWFNg *)

interface

uses
  Windows, Messages, APIWindow;

type
  TMinFormClass = class of TMinForm;
  TIdleEvent = procedure (Sender: TObject; var Done: Boolean) of object;

  TMinApplication = class
  private
    FDialogHandle: HWnd;
    FMainForm: TMinForm;
    FTitle: String;
    FShowMainForm: Boolean;
    FTerminated: Boolean;
    FOnIdle: TIdleEvent;
    function GetExeName: String;
    function ProcessMessage: Boolean;
    function IsQuitMsg(Msg: TMsg): Boolean;
    function IsDlgMsg(Msg: TMsg): Boolean;
    function IsKeyMsg(Msg: TMsg): Boolean;
    procedure Idle;
  protected
    procedure DoIdle(var Done: Boolean); virtual;
  public
    constructor Create;
    destructor Destroy; override;
    procedure Initialize;
    procedure Terminate;
    procedure Run;
    procedure HandleMessage;
    procedure CreateMinForm(FormClass: TMinFormClass; var Reference);

    property MainForm: TMinForm read FMainForm;
    property ShowMainForm: Boolean read FShowMainForm write FShowMainForm;
    property ExeName: String read GetExeName;
    property Title: String read FTitle write FTitle;
    property Terminated: Boolean read FTerminated;
    property DialogHandle: HWnd read FDialogHandle;

    property OnIdle: TIdleEvent read FOnIdle write FOnIdle;
  end;

var
  Application: TMinApplication;

implementation

constructor TMinApplication.Create;
begin
  FShowMainForm := True;
  FTerminated := False;
  FDialogHandle := 0;
end;

destructor TMinApplication.Destroy;
begin
  inherited;
end;

procedure TMinApplication.Initialize;
begin

end;

procedure TMinApplication.Terminate;
begin
  if not FTerminated then
  begin
    FTerminated := True;
//    FMainForm.Close;
    PostQuitMessage(0);
  end;
end;

procedure TMinApplication.Run;
begin
  if not Assigned(FMainForm) then Exit;
  FMainForm.Visible := FShowMainForm;
  // CbZ[W[v
  while not FTerminated do
  begin
    if (not Assigned(FMainForm)) or (FMainForm.Handle = 0) then Break;
    HandleMessage;
  end;
  if Assigned(FMainForm) then
    FMainForm.Free;
end;

procedure TMinApplication.HandleMessage;
begin
  if not ProcessMessage then
    Idle;
end;

function TMinApplication.ProcessMessage: Boolean;
var
  Msg: TMsg;
begin
  Result := PeekMessage(Msg, 0, 0, 0, PM_REMOVE);
  if Result and 
     (not IsQuitMsg(Msg)) and
     (not IsKeyMsg(Msg)) and
     (not IsDlgMsg(Msg)) then
  begin
    TranslateMessage(Msg);
    DispatchMessage(Msg);
  end;
end;

function TMinApplication.IsQuitMsg(Msg: TMsg): Boolean;
begin
  Result := (Msg.message = WM_QUIT);
  if Result then
  begin
    FTerminated := True;
    if Assigned(FMainForm) then
      FMainForm.Close;
  end;
end;

function TMinApplication.IsDlgMsg(Msg: TMsg): Boolean;
begin
  Result := (FDialogHandle <> 0) and
            Boolean(IsDialogMessage(FDialogHandle, Msg));
end;

function TMinApplication.IsKeyMsg(Msg: TMsg): Boolean;
const
  CN_BASE = $BC00;
begin
  case Msg.message of
  WM_KEYFIRST ..WM_KEYLAST :
    Result := Boolean(SendMessage(Msg.hwnd,
                                CN_BASE + Msg.message,
                                Msg.wParam,
                                Msg.lParam));
  else
    Result := False;
  end;
end;

procedure TMinApplication.Idle;
var
  Done: Boolean;
begin
  Done := True;
  DoIdle(Done);
  if Done then
    WaitMessage;
end;

procedure TMinApplication.DoIdle(var Done: Boolean);
begin
  if Assigned(FOnIdle) then
    FOnIdle(Self, Done);
end;

procedure TMinApplication.CreateMinForm(FormClass: TMinFormClass; var Reference);
begin
  TMinForm(Reference) := FormClass.Create(0);
  if not Assigned(FMainForm) then
    FMainForm := TMinForm(Reference);
end;

function TMinApplication.GetExeName: String;
var
  buf: array[0..MAX_PATH] of Char;
  Len: Integer;
begin
  Len := GetModuleFileName(0, buf, SizeOf(buf));
  SetString(Result, buf, Len);
end;

initialization
  Application := TMinApplication.Create;
  
finalization
  Application.Free;
  
end.
