package jp.co.fujitsu.reffi.client.android.model;

import java.io.OutputStream;
import java.net.Socket;
import java.util.Map;

import jp.co.fujitsu.reffi.client.android.event.ModelProcessEvent;
import jp.co.fujitsu.reffi.client.android.manager.SocketCoreManager;

public class SocketSendCore extends SocketCore {

	@Override
	protected void mainproc() throws Exception {
		SocketCoreManager manager = SocketCoreManager.getInstance();
		Map<String, Object> socketInfo = manager.connect(this);
		
		Socket socket = (Socket)socketInfo.get(SocketCoreManager.SOCKET);
		OutputStream out = (OutputStream)socketInfo.get(SocketCoreManager.OUT);

		// 送信データフック用メソッドをテンプレートコール
		byte[] data = preSend(manager);
		
		// 送信
		if (socket != null && socket.isConnected()) {
	        out.write(data);
	        out.flush();
		}
		
		// 送信後タイミングフック用メソッドをテンプレートコール
		postSend(manager);
	}

	protected void postproc() throws Exception {
		fireModelSuccess(new ModelProcessEvent(this));
		fireModelFinished(new ModelProcessEvent(this));
	}
	
	protected byte[] preSend(SocketCoreManager manager) {
		return getData();
	}
	
	protected void postSend(SocketCoreManager manager) {
	}
}
